/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.mainmenu;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import javax.swing.filechooser.FileFilter;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.appwork.utils.zip.ZipIOException;
import org.appwork.utils.zip.ZipIOWriter;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.updatev2.ForcedRestartRequest;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;

public class BackupCreateAction
extends CustomizableAppAction {
    public static final String HIDE_ON_MAC = "HideOnMac";

    public BackupCreateAction() {
        this.setIconKey("save");
        this.setName(_GUI.T.BackupCreateAction_BackupCreateAction());
        this.setTooltipText(_GUI.T.BackupCreateAction_BackupCreateAction_tt());
    }

    public void actionPerformed(ActionEvent e) {
        new Thread("Create Backup"){

            @Override
            public void run() {
                ExtFileChooserDialog d = new ExtFileChooserDialog(0, _GUI.T.BackupCreateAction_actionPerformed_filechooser_title(), _GUI.T.lit_save(), null);
                d.setFileFilter(new FileFilter[]{new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "*.jd2backup";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".jd2backup");
                    }
                }});
                d.setFileSelectionMode(FileChooserSelectionMode.FILES_ONLY);
                d.setMultiSelection(false);
                d.setType(FileChooserType.SAVE_DIALOG);
                try {
                    FileOutputStream backupOutputStream;
                    Dialog.getInstance().showConfirmDialog(0, _GUI.T.lit_restart(), _GUI.T.BackupCreateAction_run_restart_ask(), null, _GUI.T.lit_continue(), null);
                    Dialog.getInstance().showDialog((AbstractDialog)d);
                    File file = d.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    if (!file.getName().endsWith(".jd2backup")) {
                        file = new File(file.getAbsolutePath() + ".jd2backup");
                    }
                    if (file.exists()) {
                        Dialog.getInstance().showConfirmDialog(0, _GUI.T.lit_overwrite(), _GUI.T.file_exists_want_to_overwrite_question(file.getName()));
                        file.delete();
                    }
                    try {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        backupOutputStream = new FileOutputStream(file);
                    }
                    catch (IOException e) {
                        String titleAndMsg = "Failed to write file " + file.getName();
                        Dialog.getInstance().showExceptionDialog(titleAndMsg, titleAndMsg, (Throwable)e);
                        return;
                    }
                    final File backupFile = file;
                    ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){
                        {
                            this.setHookPriority(Integer.MIN_VALUE);
                        }

                        public String toString() {
                            return "ShutdownHook: Create Backup";
                        }

                        public long getMaxDuration() {
                            return 0L;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onShutdown(ShutdownRequest shutdownRequest) {
                            try {
                                BackupCreateAction.create(backupOutputStream);
                            }
                            catch (Throwable e) {
                                try {
                                    try {
                                        backupOutputStream.close();
                                    }
                                    catch (IOException ignore) {
                                        LogV3.defaultLogger().log(e);
                                    }
                                    LogV3.defaultLogger().log(e);
                                }
                                finally {
                                    backupFile.delete();
                                }
                            }
                        }
                    });
                    RestartController.getInstance().directRestart((RestartRequest)new ForcedRestartRequest(new String[0]));
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
            }
        }.start();
    }

    protected static void create(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            BackupCreateAction.create(fos);
        }
        catch (IOException e) {
            fos.close();
            file.delete();
            throw e;
        }
        finally {
            fos.close();
        }
    }

    protected static void create(OutputStream fos) throws IOException {
        ZipIOWriter zipper = null;
        try {
            final StringBuilder backupErrors = new StringBuilder();
            zipper = new ZipIOWriter(fos){
                final byte[] buf;
                {
                    super(x0);
                    this.buf = new byte[32768];
                }

                protected void addDirectoryInternal(File addDirectory, boolean compress, String path) throws ZipIOException, IOException {
                    super.addDirectoryInternal(addDirectory, compress, path);
                }

                protected boolean throwExceptionOnFileGone(File file) {
                    return false;
                }

                private boolean isFiltered(File file) {
                    String name = file.getName();
                    if (StringUtils.startsWithCaseInsensitive((String)name, (String)"RememberRelativeLocator-")) {
                        return true;
                    }
                    if (StringUtils.startsWithCaseInsensitive((String)name, (String)"RememberLastDimensor-")) {
                        return true;
                    }
                    if (StringUtils.startsWithCaseInsensitive((String)name, (String)"RememberAbsoluteLocator-")) {
                        return true;
                    }
                    return StringUtils.startsWithCaseInsensitive((String)name, (String)"CaptchaDialogDimensions_");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public synchronized void addFile(File addFile, boolean compress, String fullPath) throws ZipIOException, IOException, FileNotFoundException {
                    block27: {
                        if (addFile == null) {
                            throw new ZipIOException("addFile invalid:null");
                        }
                        if (this.isFiltered(addFile)) {
                            return;
                        }
                        try {
                            FileInputStream fis = new FileInputStream(addFile);
                            try {
                                long remaining = addFile.length();
                                ZipEntry entry = null;
                                try {
                                    if (remaining == 0L) {
                                        entry = new ZipEntry(fullPath);
                                        entry.setMethod(8);
                                        this.zipStream.putNextEntry(entry);
                                        break block27;
                                    }
                                    long written = 0L;
                                    while (remaining > 0L) {
                                        int read;
                                        try {
                                            read = fis.read(this.buf);
                                        }
                                        catch (IOException e) {
                                            LogV3.defaultLogger().log((Throwable)e);
                                            break;
                                        }
                                        if (read == -1) break;
                                        if (read <= 0) continue;
                                        if (entry == null) {
                                            entry = new ZipEntry(fullPath);
                                            entry.setMethod(8);
                                            this.zipStream.putNextEntry(entry);
                                        }
                                        this.zipStream.write(this.buf, 0, read);
                                        remaining -= (long)read;
                                        this.notify(entry, read, written += (long)read);
                                    }
                                    if (written != addFile.length()) {
                                        if (written == 0L) {
                                            backupErrors.append("Missing(Gone):" + addFile.getAbsolutePath()).append("\r\n");
                                        } else {
                                            backupErrors.append("Incomplete:" + addFile.getAbsolutePath()).append("\r\n");
                                        }
                                    }
                                }
                                finally {
                                    if (entry != null) {
                                        this.zipStream.closeEntry();
                                    }
                                }
                            }
                            finally {
                                try {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                }
                                catch (IOException ignore) {
                                    LogV3.defaultLogger().log((Throwable)ignore);
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            backupErrors.append("Missing(Not Found):" + addFile.getAbsolutePath()).append("\r\n");
                            LogV3.defaultLogger().log((Throwable)e);
                            if (!addFile.exists()) {
                                if (this.throwExceptionOnFileGone(addFile)) {
                                    throw e;
                                }
                                return;
                            }
                            throw e;
                        }
                        catch (IOException e) {
                            LogV3.defaultLogger().log((Throwable)e);
                            throw e;
                        }
                    }
                }
            };
            zipper.addDirectory(Application.getResource((String)"cfg"), false, null);
            if (backupErrors.length() > 0) {
                zipper.addByteArry(backupErrors.toString().getBytes("UTF-8"), true, "cfg", "BackupErrors.txt");
            }
        }
        finally {
            try {
                zipper.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

