/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import org.appwork.swing.MigPanel;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;

public abstract class AbstractBubbleContentPanel
extends MigPanel {
    private final long startTime = System.currentTimeMillis();
    private AbstractNotifyWindow<?> window;

    public long getStartTime() {
        return this.startTime;
    }

    private String clean(String label) {
        label = label.trim();
        while (label.endsWith(":")) {
            label = label.substring(0, label.length() - 1);
        }
        return label + ":";
    }

    public void setWindow(AbstractNotifyWindow<?> window) {
        this.window = window;
    }

    public AbstractNotifyWindow<?> getWindow() {
        return this.window;
    }

    public abstract void updateLayout();

    protected Pair addPair(Pair existingPair, String lbl, Icon iconWait) {
        if (existingPair == null) {
            existingPair = new Pair();
            existingPair.lbl = this.createHeaderLabel(lbl, iconWait);
            existingPair.value = new JLabel("");
        }
        this.add(existingPair.lbl, "hidemode 3");
        this.add(existingPair.value, "hidemode 3");
        return existingPair;
    }

    protected Pair addPair(Pair existingPair, String lbl, String icon) {
        return this.addPair(existingPair, lbl, NewTheme.I().getIcon(icon, 18));
    }

    protected Pair addPair(String lbl, String iconWait) {
        return this.addPair(null, lbl, iconWait);
    }

    public void stop() {
    }

    protected JLabel createHeaderLabel(String lbl, Icon icon) {
        JLabel ret = this.createHeaderLabel(lbl);
        if (icon != null) {
            ret.setDisabledIcon(icon);
            ret.setHorizontalTextPosition(2);
        }
        return ret;
    }

    protected JLabel createHeaderLabel(String lbl, String icon) {
        return this.createHeaderLabel(lbl, NewTheme.I().getIcon(icon, 18));
    }

    protected JLabel createHeaderLabel(String label) {
        JLabel lbl = new JLabel(this.clean(label));
        SwingUtils.toBold((JLabel)lbl);
        lbl.setEnabled(false);
        lbl.setHorizontalAlignment(4);
        return lbl;
    }

    public AbstractBubbleContentPanel(String iconKey) {
        this(NewTheme.I().getIcon(iconKey, 20));
    }

    public AbstractBubbleContentPanel(Icon icon) {
        super("ins 3 3 0 3,wrap 3", "[][fill][grow,fill]", "[]");
        if (icon instanceof AbstractIcon) {
            ((AbstractIcon)icon).setAutoDisabledIconEnabled(false);
        }
        SwingUtils.setOpaque((JComponent)((Object)this), (boolean)false);
    }

    protected IconedProcessIndicator createProgress(String iconKey) {
        return this.createProgress(NewTheme.I().getIcon(iconKey, 20));
    }

    protected IconedProcessIndicator createProgress(Icon icon) {
        IconedProcessIndicator progressCircle = new IconedProcessIndicator(icon);
        progressCircle.setIndeterminate(false);
        progressCircle.setEnabled(false);
        progressCircle.setValue(100);
        return progressCircle;
    }

    public AbstractBubbleContentPanel() {
        super("ins 3 3 0 3,wrap 2", "[fill][grow,fill]", "[]");
        SwingUtils.setOpaque((JComponent)((Object)this), (boolean)false);
    }

    public class Pair {
        public JLabel lbl;
        public JLabel value;

        public void setText(final Object v) {
            new EDTRunner(){

                protected void runInEDT() {
                    Pair.this.value.setText(String.valueOf(v));
                }
            };
        }

        public void setVisible(final boolean b) {
            new EDTRunner(){

                protected void runInEDT() {
                    Pair.this.lbl.setVisible(b);
                    Pair.this.value.setVisible(b);
                }
            };
        }

        public void setTooltip(final String toolTip) {
            new EDTRunner(){

                protected void runInEDT() {
                    Pair.this.lbl.setToolTipText(toolTip);
                    Pair.this.value.setToolTipText(toolTip);
                }
            };
        }
    }
}

