/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify;

import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledEditorKit;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.swing.components.ExtTextPane;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;

public class BasicContentPanel
extends AbstractBubbleContentPanel {
    public BasicContentPanel(String text, Icon icon) {
        super(icon);
        this.setLayout((LayoutManager)new MigLayout("ins 0,wrap 2", "[][grow,fill]", "[]"));
        this.add(new JLabel(icon), "aligny top");
        this.add(this.getMessage(text), "aligny center");
        SwingUtils.setOpaque((JComponent)((Object)this), (boolean)false);
    }

    protected void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            CrossSystem.openURL((URL)e.getURL());
        }
    }

    private Component getMessage(String text) {
        ExtTextArea ret;
        if (text.matches("^<html>.+")) {
            ExtTextPane textPane = new ExtTextPane();
            textPane.setContentType("text/html");
            textPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    BasicContentPanel.this.hyperlinkUpdate(e);
                }
            });
            textPane.setEditable(false);
            textPane.setFocusable(false);
            textPane.setEditorKit((EditorKit)new StyledEditorKit());
            ret = textPane;
        } else {
            ExtTextArea textArea = new ExtTextArea();
            textArea.setLabelMode(true);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            ret = textArea;
        }
        SwingUtils.setOpaque((JComponent)ret, (boolean)false);
        ret.setText(text);
        return ret;
    }

    @Override
    public void updateLayout() {
    }
}

