/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify;

import java.awt.Frame;
import java.awt.Point;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import jd.gui.swing.jdgui.JDGui;
import jd.plugins.PluginsC;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.UpdatesBubbleSupport;
import org.jdownloader.gui.notify.captcha.CESBubbleSupport;
import org.jdownloader.gui.notify.captcha.CaptchaBubbleSupport;
import org.jdownloader.gui.notify.downloads.StartDownloadsBubbleSupport;
import org.jdownloader.gui.notify.downloads.StartStopPauseBubbleSupport;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.Balloner;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfig;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfigPanel;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.notify.linkcrawler.LinkCrawlerBubbleSupport;
import org.jdownloader.gui.notify.reconnect.ReconnectBubbleSupport;

public class BubbleNotify {
    private static final BubbleNotify INSTANCE = new BubbleNotify();
    private final Balloner ballooner;
    private final CopyOnWriteArrayList<AbstractBubbleSupport> types = new CopyOnWriteArrayList();
    private BubbleNotifyConfigPanel configPanel;

    public static BubbleNotify getInstance() {
        return INSTANCE;
    }

    private BubbleNotify() {
        if (Application.isHeadless()) {
            this.ballooner = null;
            return;
        }
        this.ballooner = new Balloner(null){

            @Override
            public JFrame getOwner() {
                if (JDGui.getInstance() == null) {
                    return null;
                }
                return JDGui.getInstance().getMainFrame();
            }
        };
        GenericConfigEventListener<Object> update = new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                BubbleNotify.this.ballooner.setScreenID(CFG_BUBBLE.CFG.getScreenID());
                if (CFG_BUBBLE.CFG.getAnimationStartPositionAnchor() == BubbleNotifyConfig.Anchor.SYSTEM_DEFAULT) {
                    switch (CrossSystem.getOS().getFamily()) {
                        case WINDOWS: {
                            BubbleNotify.this.ballooner.setStartPoint(new Point(-11, -1), BubbleNotifyConfig.Anchor.TOP_RIGHT);
                            break;
                        }
                        default: {
                            BubbleNotify.this.ballooner.setStartPoint(new Point(-11, 0), BubbleNotifyConfig.Anchor.BOTTOM_RIGHT);
                            break;
                        }
                    }
                } else {
                    BubbleNotify.this.ballooner.setStartPoint(new Point(CFG_BUBBLE.CFG.getAnimationStartPositionX(), CFG_BUBBLE.CFG.getAnimationStartPositionY()), CFG_BUBBLE.CFG.getAnimationStartPositionAnchor());
                }
                if (CFG_BUBBLE.CFG.getAnimationEndPositionAnchor() == BubbleNotifyConfig.Anchor.SYSTEM_DEFAULT) {
                    switch (CrossSystem.getOS().getFamily()) {
                        case WINDOWS: {
                            BubbleNotify.this.ballooner.setEndPoint(new Point(-1, -11), BubbleNotifyConfig.Anchor.BOTTOM_LEFT);
                            break;
                        }
                        default: {
                            BubbleNotify.this.ballooner.setEndPoint(new Point(-1, 10), BubbleNotifyConfig.Anchor.TOP_LEFT);
                            break;
                        }
                    }
                } else {
                    BubbleNotify.this.ballooner.setEndPoint(new Point(CFG_BUBBLE.CFG.getAnimationEndPositionX(), CFG_BUBBLE.CFG.getAnimationEndPositionY()), CFG_BUBBLE.CFG.getAnimationEndPositionAnchor());
                }
                if (CFG_BUBBLE.CFG.getFinalPositionAnchor() == BubbleNotifyConfig.Anchor.SYSTEM_DEFAULT) {
                    switch (CrossSystem.getOS().getFamily()) {
                        case WINDOWS: {
                            BubbleNotify.this.ballooner.setAnchorPoint(new Point(-11, -11), BubbleNotifyConfig.Anchor.BOTTOM_RIGHT);
                            break;
                        }
                        default: {
                            BubbleNotify.this.ballooner.setAnchorPoint(new Point(-11, 10), BubbleNotifyConfig.Anchor.TOP_RIGHT);
                            break;
                        }
                    }
                } else {
                    BubbleNotify.this.ballooner.setAnchorPoint(new Point(CFG_BUBBLE.CFG.getFinalPositionX(), CFG_BUBBLE.CFG.getFinalPositionY()), CFG_BUBBLE.CFG.getFinalPositionAnchor());
                }
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        };
        CFG_BUBBLE.CFG._getStorageHandler().getEventSender().addListener((EventListener)update);
        update.onConfigValueModified(null, null);
        this.types.add(new LinkCrawlerBubbleSupport());
        this.types.add(new UpdatesBubbleSupport());
        this.types.add(new ReconnectBubbleSupport());
        this.types.add(new CaptchaBubbleSupport());
        this.types.add(new StartDownloadsBubbleSupport());
        this.types.add(new StartStopPauseBubbleSupport());
        this.types.add(PluginsC.getBubbleSupportInstance());
        this.types.add(CESBubbleSupport.getInstance());
    }

    private boolean isBubbleNotificationEnabled() {
        if (JDGui.getInstance().isSilentModeActive() && !CFG_BUBBLE.BUBBLE_NOTIFY_ENABLED_DURING_SILENT_MODE.isEnabled()) {
            return false;
        }
        switch (CFG_BUBBLE.CFG.getBubbleNotifyEnabledState()) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case JD_ACTIVE: {
                return WindowManager.getInstance().hasFocus();
            }
            case JD_NOT_ACTIVE: {
                return !WindowManager.getInstance().hasFocus();
            }
            case TASKBAR: {
                return WindowManager.getInstance().getExtendedState((Frame)JDGui.getInstance().getMainFrame()) == WindowManager.WindowExtendedState.ICONIFIED;
            }
            case TRAY: {
                return !JDGui.getInstance().getMainFrame().isVisible();
            }
            case TRAY_OR_TASKBAR: {
                if (WindowManager.getInstance().getExtendedState((Frame)JDGui.getInstance().getMainFrame()) == WindowManager.WindowExtendedState.ICONIFIED) {
                    return true;
                }
                return !JDGui.getInstance().getMainFrame().isVisible();
            }
        }
        return false;
    }

    public void show(final AbstractNotifyWindow no) {
        if (this.ballooner == null) {
            return;
        }
        new EDTRunner(){

            protected void runInEDT() {
                boolean added = false;
                try {
                    if (BubbleNotify.this.isBubbleNotificationEnabled()) {
                        BubbleNotify.this.ballooner.add(no);
                        added = true;
                    }
                }
                finally {
                    if (!added) {
                        no.dispose();
                    }
                }
            }
        };
    }

    public void show(final AbstractNotifyWindowFactory factory) {
        if (this.ballooner == null) {
            return;
        }
        if (factory == null) {
            return;
        }
        new EDTRunner(){

            protected void runInEDT() {
                boolean added = false;
                AbstractNotifyWindow<?> notifyWindow = null;
                try {
                    if (!BubbleNotify.this.isBubbleNotificationEnabled()) {
                        return;
                    }
                    notifyWindow = factory.buildAbstractNotifyWindow();
                    if (notifyWindow != null) {
                        BubbleNotify.this.ballooner.add(notifyWindow);
                        added = true;
                    }
                }
                finally {
                    if (!added && notifyWindow != null) {
                        notifyWindow.dispose();
                    }
                }
            }
        };
    }

    public void hide(final AbstractNotifyWindow notify) {
        if (this.ballooner == null) {
            return;
        }
        if (notify == null) {
            return;
        }
        new EDTRunner(){

            protected void runInEDT() {
                BubbleNotify.this.ballooner.hide(notify);
            }
        };
    }

    public void relayout() {
        if (this.ballooner == null) {
            return;
        }
        this.ballooner.relayout();
    }

    public void unregisterTypes(AbstractBubbleSupport type) {
        if (this.ballooner == null) {
            return;
        }
        if (this.types.remove(type)) {
            new EDTRunner(){

                protected void runInEDT() {
                    if (BubbleNotify.this.configPanel != null) {
                        BubbleNotify.this.configPanel.updateTypes(BubbleNotify.this.getTypes());
                    }
                }
            };
        }
    }

    public void registerType(AbstractBubbleSupport type) {
        if (this.ballooner == null) {
            return;
        }
        this.types.add(type);
        new EDTRunner(){

            protected void runInEDT() {
                if (BubbleNotify.this.configPanel != null) {
                    BubbleNotify.this.configPanel.updateTypes(BubbleNotify.this.getTypes());
                }
            }
        };
    }

    public List<AbstractBubbleSupport> getTypes() {
        return this.types;
    }

    public BubbleNotifyConfigPanel getConfigPanel() {
        if (this.ballooner == null) {
            return null;
        }
        if (this.configPanel == null) {
            this.configPanel = new BubbleNotifyConfigPanel();
        }
        return this.configPanel;
    }

    public static interface AbstractNotifyWindowFactory {
        public AbstractNotifyWindow<?> buildAbstractNotifyWindow();
    }
}

