/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.gui;

import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultLongValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;

public interface BubbleNotifyConfig
extends ConfigInterface {
    @AboutConfig
    @DefaultEnumValue(value="SYSTEM_DEFAULT")
    @DescriptionForConfigEntry(value="Position Anchor for the First Bubble. TOP_RIGHT means, that the topright corner of the bubble is the reference anchor")
    public Anchor getFinalPositionAnchor();

    @AboutConfig
    @DefaultIntValue(value=-1)
    @DescriptionForConfigEntry(value="X Position of the first bubble. 0 is left screen edge -1 is right screen edge")
    public int getFinalPositionX();

    @AboutConfig
    @DefaultIntValue(value=-1)
    @DescriptionForConfigEntry(value="Y Position of the first bubble. 0 is top screen edge -1 is bottom screen edge")
    public int getFinalPositionY();

    @AboutConfig
    @DefaultEnumValue(value="SYSTEM_DEFAULT")
    @DescriptionForConfigEntry(value="Animation End Anchor. TOP_RIGHT means, that the topright corner of the bubble is the reference anchor")
    public Anchor getAnimationEndPositionAnchor();

    @AboutConfig
    @DefaultIntValue(value=-1)
    @DescriptionForConfigEntry(value="Animation End X Position. 0 is left screen edge -1 is right screen edge")
    public int getAnimationEndPositionX();

    @AboutConfig
    @DefaultIntValue(value=-1)
    @DescriptionForConfigEntry(value="Animation End Y Position. 0 is top screen edge -1 is bottom screen edge")
    public int getAnimationEndPositionY();

    @DefaultStringValue(value="\\Display9999")
    @AboutConfig
    @DescriptionForConfigEntry(value="The bubbles iuse the current active screen. That means the screen that is used by the Main Window. You can set a hardcoded screen ID here. Like \\Display0 for your main screen")
    public String getScreenID();

    @AboutConfig
    @DefaultEnumValue(value="SYSTEM_DEFAULT")
    @DescriptionForConfigEntry(value="Animation Start Anchor. TOP_RIGHT means, that the topright corner of the bubble is the reference anchor")
    public Anchor getAnimationStartPositionAnchor();

    @AboutConfig
    @DefaultIntValue(value=-1)
    @DescriptionForConfigEntry(value="Animation Start X Position. 0 is left screen edge -1 is right screen edge")
    public int getAnimationStartPositionX();

    @AboutConfig
    @DefaultIntValue(value=-1)
    @DescriptionForConfigEntry(value="Animation Start Y Position. 0 is top screen edge -1 is bottom screen edge")
    public int getAnimationStartPositionY();

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleNotifyOnNewLinkgrabberLinksEnabled();

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleNotifyOnReconnectStartEnabled();

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleNotifyOnUpdateAvailableEnabled();

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isBubbleNotifyOnContainerLoadedEnabled();

    public void setFinalPositionAnchor(Anchor var1);

    public void setFinalPositionX(int var1);

    public void setFinalPositionY(int var1);

    public void setBubbleNotifyOnNewLinkgrabberLinksEnabled(boolean var1);

    public void setBubbleNotifyOnReconnectStartEnabled(boolean var1);

    public void setBubbleNotifyOnUpdateAvailableEnabled(boolean var1);

    public void setBubbleNotifyOnContainerLoadedEnabled(boolean var1);

    public void setAnimationEndPositionAnchor(Anchor var1);

    public void setAnimationEndPositionX(int var1);

    public void setAnimationEndPositionY(int var1);

    public void setScreenID(String var1);

    public void setAnimationStartPositionAnchor(Anchor var1);

    public void setAnimationStartPositionX(int var1);

    public void setAnimationStartPositionY(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isBubbleNotifyEnabledDuringSilentMode();

    public void setBubbleNotifyEnabledDuringSilentMode(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="JD_NOT_ACTIVE")
    public BubbleNotifyEnabledState getBubbleNotifyEnabledState();

    public void setBubbleNotifyEnabledState(BubbleNotifyEnabledState var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadStartedBubbleContentSaveToVisible();

    public void setDownloadStartedBubbleContentSaveToVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isBubbleNotifyStartStopDownloadsEnabled();

    public void setBubbleNotifyStartStopDownloadsEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isBubbleNotifyStartPauseStopEnabled();

    public void setBubbleNotifyStartPauseStopEnabled(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=15000)
    public int getDefaultTimeout();

    public void setDefaultTimeout(int var1);

    @AboutConfig
    @DefaultIntValue(value=15000)
    public int getBubbleNotifyOnNewLinkgrabberLinksEndNotifyDelay();

    public void setBubbleNotifyOnNewLinkgrabberLinksEndNotifyDelay(int var1);

    @AboutConfig
    @DefaultEnumValue(value="LINK")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public LINKGRABBER_BUBBLE_NOTIFY_ON getBubbleNotifyOnNewLinkgrabberLinksOn();

    public void setBubbleNotifyOnNewLinkgrabberLinksOn(LINKGRABBER_BUBBLE_NOTIFY_ON var1);

    @AboutConfig
    @DefaultIntValue(value=900)
    public int getFadeAnimationDuration();

    public void setFadeAnimationDuration(int var1);

    @AboutConfig
    @DefaultLongValue(value=10000L)
    public long getDownloadStartEndNotifyDelay();

    public void setDownloadStartEndNotifyDelay(long var1);

    @AboutConfig
    @DefaultIntValue(value=100)
    @DescriptionForConfigEntry(value="Transparency of the Bubbles. 0 = invisible 100= no Transparency")
    @SpinnerValidator(min=1L, max=100L, step=1L)
    public int getTransparency();

    public void setTransparency(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isBubbleNotifyOnCaptchaInBackgroundEnabled();

    public void setBubbleNotifyOnCaptchaInBackgroundEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadStartedBubbleContentStatusVisible();

    public void setDownloadStartedBubbleContentStatusVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadStartedBubbleContentProxyVisible();

    public void setDownloadStartedBubbleContentProxyVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadStartedBubbleContentAccountVisible();

    public void setDownloadStartedBubbleContentAccountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadStartedBubbleContentHosterVisible();

    public void setDownloadStartedBubbleContentHosterVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentDurationVisible();

    public void setCrawlerBubbleContentDurationVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentLinkCountVisible();

    public void setCrawlerBubbleContentLinkCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentPackageCountVisible();

    public void setCrawlerBubbleContentPackageCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentOfflineCountVisible();

    public void setCrawlerBubbleContentOfflineCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentOnlineCountVisible();

    public void setCrawlerBubbleContentOnlineCountVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentStatusVisible();

    public void setCrawlerBubbleContentStatusVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentListQueueVisible();

    public void setCrawlerBubbleContentListQueueVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentCheckQueueVisible();

    public void setCrawlerBubbleContentCheckQueueVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCrawlerBubbleContentAnimatedIconVisible();

    public void setCrawlerBubbleContentAnimatedIconVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isDownloadStartedBubbleContentFilenameVisible();

    public void setDownloadStartedBubbleContentFilenameVisible(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="If enabled, all Anchor settings are relative to the JDownloader Window screen of JDownloader is visible on screen.")
    @DefaultBooleanValue(value=false)
    public boolean isBubbleAnchorRelativeToWindow();

    public void setBubbleAnchorRelativeToWindow(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCaptchaExchangeSolverBubbleImageVisible();

    public void setCaptchaExchangeSolverBubbleImageVisible(boolean var1);

    public static enum BubbleNotifyEnabledState {
        ALWAYS,
        NEVER,
        JD_NOT_ACTIVE,
        JD_ACTIVE,
        TRAY_OR_TASKBAR,
        TRAY,
        TASKBAR;

    }

    public static enum LINKGRABBER_BUBBLE_NOTIFY_ON {
        LINK,
        PLUGIN,
        ALWAYS;

    }

    public static enum Anchor {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT,
        SYSTEM_DEFAULT;

    }
}

