/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.linkcrawler;

import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import jd.controlling.TaskQueue;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfigPanel;
import org.jdownloader.gui.notify.linkcrawler.LinkCrawlerBubbleContent;
import org.jdownloader.gui.notify.linkcrawler.LinkCrawlerBubbleSupport;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class LinkCrawlerBubble
extends AbstractNotifyWindow<LinkCrawlerBubbleContent> {
    private final LinkCollector.JobLinkCrawler crawler;
    private final DelayedRunnable update = new DelayedRunnable(TaskQueue.TIMINGQUEUE, 500L, 1000L){

        public String getID() {
            return "LinkCrawlerBubble";
        }

        public void delayedrun() {
            LinkCrawlerBubble.this.delayedUpdate();
        }
    };

    @Override
    protected void onMouseClicked(MouseEvent m) {
        super.onMouseClicked(m);
        JDGui.getInstance().requestPanel(JDGui.Panels.LINKGRABBER);
        JDGui.getInstance().setFrameState(WindowManager.FrameState.TO_FRONT_FOCUSED);
    }

    protected void onSettings() {
        JDGui.getInstance().setFrameState(WindowManager.FrameState.TO_FRONT_FOCUSED);
        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
        JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
        ConfigurationView.getInstance().setSelectedSubPanel(BubbleNotifyConfigPanel.class);
    }

    private LinkCollector.JobLinkCrawler getCrawler() {
        return this.crawler;
    }

    public LinkCrawlerBubble(LinkCrawlerBubbleSupport linkCrawlerBubbleSupport, LinkCollector.JobLinkCrawler crawler) {
        super(linkCrawlerBubbleSupport, _GUI.T.balloon_new_links(), new LinkCrawlerBubbleContent(crawler));
        this.crawler = crawler;
    }

    @Override
    protected int getTimeout() {
        return 0;
    }

    public int getSuperTimeout() {
        return super.getTimeout();
    }

    private final void delayedUpdate() {
        LinkCollector.JobLinkCrawler jlc = this.getCrawler();
        LinkCollectingJob job = jlc.getJob();
        LinkOrigin src = job != null ? job.getOrigin().getOrigin() : null;
        if (src == null) {
            this.setHeaderText(_GUI.T.LinkCrawlerBubble_update_header());
        } else if (src == LinkOrigin.ADD_LINKS_DIALOG) {
            this.setHeaderText(_GUI.T.LinkCrawlerBubble_update_header());
        } else if (src == LinkOrigin.CLIPBOARD) {
            String sourceURL = job != null ? job.getCustomSourceUrl() : null;
            if (StringUtils.isNotEmpty((String)sourceURL)) {
                try {
                    URL url = new URL(sourceURL);
                    this.setHeaderText(_GUI.T.LinkCrawlerBubble_update_header_from_Clipboard_url(url.getHost()));
                }
                catch (MalformedURLException e) {
                    this.setHeaderText(_GUI.T.LinkCrawlerBubble_update_header_from_Clipboard());
                }
            } else {
                this.setHeaderText(_GUI.T.LinkCrawlerBubble_update_header_from_Clipboard());
            }
        } else {
            this.setHeaderText(_GUI.T.LinkCrawlerBubble_update_header());
        }
        ((LinkCrawlerBubbleContent)((Object)this.getContentComponent())).update(jlc);
        new EDTRunner(){

            protected void runInEDT() {
                LinkCrawlerBubble.this.pack();
                BubbleNotify.getInstance().relayout();
            }
        }.waitForEDT();
    }

    protected void requestUpdate() {
        this.update.resetAndStart();
    }
}

