/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.reconnect;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import jd.controlling.reconnect.Reconnecter;
import jd.controlling.reconnect.ReconnecterEvent;
import jd.controlling.reconnect.ReconnecterListener;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfigPanel;
import org.jdownloader.gui.notify.reconnect.ReconnectBubbleContent;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class ReconnectBubble
extends AbstractNotifyWindow<ReconnectBubbleContent>
implements ReconnecterListener {
    protected long createdTime;
    private Timer updateTimer;

    @Override
    protected void onMouseClicked(MouseEvent m) {
        super.onMouseClicked(m);
    }

    protected void onSettings() {
        JDGui.getInstance().setFrameState(WindowManager.FrameState.TO_FRONT_FOCUSED);
        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
        JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
        ConfigurationView.getInstance().setSelectedSubPanel(BubbleNotifyConfigPanel.class);
    }

    public ReconnectBubble() {
        super(_GUI.T.balloon_reconnect(), new ReconnectBubbleContent());
        Reconnecter.getInstance().getEventSender().addListener(this, true);
        this.updateTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ReconnectBubbleContent)((Object)ReconnectBubble.this.getContentComponent())).update();
            }
        });
        this.updateTimer.setRepeats(true);
        this.updateTimer.start();
    }

    @Override
    protected int getTimeout() {
        return 0;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.updateTimer.stop();
    }

    @Override
    public void onAfterReconnect(final ReconnecterEvent event) {
        new EDTRunner(){

            protected void runInEDT() {
                Reconnecter.ReconnectResult result = event.getResult();
                if (result == null) {
                    result = Reconnecter.ReconnectResult.FAILED;
                }
                ((ReconnectBubbleContent)((Object)ReconnectBubble.this.getContentComponent())).onResult(result);
                ReconnectBubble.this.pack();
                BubbleNotify.getInstance().relayout();
                ((ReconnectBubbleContent)((Object)ReconnectBubble.this.getContentComponent())).stop();
                ((ReconnectBubbleContent)((Object)ReconnectBubble.this.getContentComponent())).update();
                ReconnectBubble.this.startTimeout(ReconnectBubble.super.getTimeout());
                ReconnectBubble.this.updateTimer.stop();
            }
        };
    }

    @Override
    public void onBeforeReconnect(ReconnecterEvent event) {
    }
}

