/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.packagehistorycontroller;

import java.io.File;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Lists;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.EventSuppressor;
import org.jdownloader.gui.packagehistorycontroller.DownloadPath;
import org.jdownloader.gui.packagehistorycontroller.HistoryManager;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;

public class DownloadPathHistoryManager
extends HistoryManager<DownloadPath>
implements GenericConfigEventListener<Object> {
    private static final DownloadPathHistoryManager INSTANCE = new DownloadPathHistoryManager();

    public static DownloadPathHistoryManager getInstance() {
        return INSTANCE;
    }

    private DownloadPathHistoryManager() {
        super(CFG_LINKGRABBER.CFG.getDownloadDestinationHistory());
        CFG_LINKGRABBER.DOWNLOAD_DESTINATION_HISTORY.getEventSender().addListener((EventListener)((Object)this));
    }

    @Override
    protected int getMaxLength() {
        return CFG_GENERAL.CFG.getDownloadDestinationHistoryLength();
    }

    @Override
    public void add(String packageName) {
        if (this.isValid(packageName)) {
            CFG_LINKGRABBER.CFG.setLatestDownloadDestinationFolder(packageName);
            this.superadd(packageName);
        }
    }

    @Override
    protected boolean isValid(String input) {
        return !StringUtils.isEmpty((String)input) && new File(input).isAbsolute();
    }

    public synchronized boolean setLastIfExists(String packageName) {
        DownloadPath existing = (DownloadPath)this.get(packageName);
        if (existing != null) {
            existing.setTime(System.currentTimeMillis());
            Collections.sort(this.packageHistory);
            return true;
        }
        return false;
    }

    private void superadd(String packageName) {
        super.add(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void save(List<DownloadPath> list) {
        final Thread thread = Thread.currentThread();
        EventSuppressor<ConfigEvent> eventSuppressor = new EventSuppressor<ConfigEvent>(){

            public boolean suppressEvent(ConfigEvent eventType) {
                return Thread.currentThread() == thread;
            }
        };
        CFG_LINKGRABBER.DOWNLOAD_DESTINATION_HISTORY.getEventSender().addEventSuppressor((EventSuppressor)eventSuppressor);
        try {
            CFG_LINKGRABBER.CFG.setDownloadDestinationHistory(list);
        }
        finally {
            CFG_LINKGRABBER.DOWNLOAD_DESTINATION_HISTORY.getEventSender().removeEventSuppressor((EventSuppressor)eventSuppressor);
        }
    }

    @Override
    protected DownloadPath createNew(String name) {
        return new DownloadPath(name);
    }

    public List<String> listPaths(String ... strings) {
        return this.listPaths(false, strings);
    }

    public List<String> listPaths(boolean atTop, String ... strings) {
        List l = this.list();
        LinkedHashSet<String> dupe = new LinkedHashSet<String>();
        if (atTop && strings != null) {
            for (String s : strings) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                dupe.add(s);
            }
        }
        for (DownloadPath p : l) {
            if (p == null || !StringUtils.isNotEmpty((String)p.getName())) continue;
            dupe.add(p.getName());
        }
        if (!atTop && strings != null) {
            for (String s : strings) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                dupe.add(s);
            }
        }
        return Lists.unique(dupe);
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        if (newValue == null) {
            this.clear();
        } else if (newValue instanceof List) {
            List list = (List)newValue;
            if (list.size() == 0) {
                this.clear();
            } else {
                DownloadPathHistoryManager downloadPathHistoryManager = this;
                synchronized (downloadPathHistoryManager) {
                    this.clear();
                    for (int i = list.size() - 1; i >= 0; --i) {
                        Object item = list.get(i);
                        if (item == null || !(item instanceof DownloadPath)) continue;
                        this.superadd(((DownloadPath)item).getName());
                    }
                }
            }
        }
    }
}

