/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.toolbar.action;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.images.NewTheme;
import org.jdownloader.translate._JDT;

public abstract class AbstractToolBarAction
extends CustomizableAppAction
implements ActionContext,
GUIListener {
    public static final String ITEM_VISIBLE_FOR_SELECTIONS = "itemVisibleForSelections";
    private boolean visibleInDownloadTab = true;
    private boolean visibleInLinkgrabberTab = true;
    private boolean visibleInAllTabs = true;

    @Override
    public void onKeyModifier(int parameter) {
    }

    public AbstractToolBarAction() {
        GUIEventSender.getInstance().addListener(this, true);
        this.onGuiMainTabSwitch(null, MainTabbedPane.getInstance().getSelectedView());
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, View newView) {
        if (this.isVisibleInAllTabs()) {
            this.setVisible(true);
            return;
        }
        if (this.isVisibleInDownloadTab() && newView instanceof DownloadsView) {
            this.setVisible(true);
            return;
        }
        if (this.isVisibleInLinkgrabberTab() && newView instanceof LinkGrabberView) {
            this.setVisible(true);
            return;
        }
        this.setVisible(false);
    }

    public static String getTranslationForVisibleInDownloadTab() {
        return _JDT.T.ToolbarContext_getTranslationForVisibleInDownloadTab();
    }

    public static String getTranslationForVisibleInLinkgrabberTab() {
        return _JDT.T.ToolbarContext_getTranslationForVisibleInLinkgrabberTab();
    }

    public static String getTranslationForVisibleInAllTabs() {
        return _JDT.T.ToolbarContext_getTranslationForVisibleInAllTabs();
    }

    @Customizer(link="#getTranslationForVisibleInDownloadTab")
    public boolean isVisibleInDownloadTab() {
        return this.visibleInDownloadTab;
    }

    public void setVisibleInDownloadTab(boolean visibleInDownloadTab) {
        this.visibleInDownloadTab = visibleInDownloadTab;
    }

    @Customizer(link="#getTranslationForVisibleInLinkgrabberTab")
    public boolean isVisibleInLinkgrabberTab() {
        return this.visibleInLinkgrabberTab;
    }

    public void setVisibleInLinkgrabberTab(boolean visibleInDownloadTab) {
        this.visibleInLinkgrabberTab = visibleInDownloadTab;
    }

    @Customizer(link="#getTranslationForVisibleInAllTabs")
    public boolean isVisibleInAllTabs() {
        return this.visibleInAllTabs;
    }

    public void setVisibleInAllTabs(boolean visibleInDownloadTab) {
        this.visibleInAllTabs = visibleInDownloadTab;
    }

    protected String createMnemonic() {
        return "-";
    }

    @Override
    public String getIconKey() {
        String iconKey = super.getIconKey();
        if (StringUtils.isEmpty((String)iconKey)) {
            return "question";
        }
        if (MenuItemData.isEmptyValue(iconKey)) {
            return "question";
        }
        return iconKey;
    }

    @Override
    public Object getValue(String key) {
        if ("SwingLargeIconKey" == key) {
            return this.getLargeIconForToolbar();
        }
        if ("SmallIcon" == key) {
            return this.getSmallIconForToolbar();
        }
        if ("MnemonicKey" == key || "SwingDisplayedMnemonicIndexKey" == key) {
            Object ret = super.getValue(key);
            if (ret == null) {
                if (this.getName() == null) {
                    this.setName(this.createTooltip());
                }
                this.setMnemonic(this.createMnemonic());
            }
            return super.getValue(key);
        }
        if ("ShortDescription" == key) {
            return this.createTooltip();
        }
        return super.getValue(key);
    }

    protected Icon getSmallIconForToolbar() {
        return NewTheme.I().getIcon(this.getIconKey(), 18);
    }

    protected Icon getLargeIconForToolbar() {
        return NewTheme.I().getIcon(this.getIconKey(), 24);
    }

    protected abstract String createTooltip();

    public AbstractButton createButton() {
        return null;
    }
}

