/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.toolbar.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.jdownloader.gui.toolbar.action.SelectionBasedToolbarAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;

public class CollapseExpandAllAction
extends SelectionBasedToolbarAction {
    public CollapseExpandAllAction() {
        this.setIconKey("list");
    }

    public void actionPerformed(ActionEvent e) {
        final PackageControllerTable<?, ?> table = this.getTable();
        if (table != null) {
            table.getSelectionInfo(new PackageControllerTable.EDTSelectionInfoCallback(){

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public void onSelectionInfo(SelectionInfo selectionInfo) {
                    boolean allexpaned = true;
                    ArrayList list = new ArrayList();
                    for (SelectionInfo.PackageView p : selectionInfo.getPackageViews()) {
                        SelectionInfo.PackageView pv = p;
                        if (!pv.isExpanded()) {
                            allexpaned = false;
                        }
                        list.add(pv.getPackage());
                    }
                    table.getModel().setFilePackageExpand(!allexpaned, list.toArray(new AbstractPackageNode[0]));
                }
            }, PackageControllerTable.SelectionType.ALL);
        }
    }

    @Override
    protected String createTooltip() {
        return _GUI.T.CollapseExpandAllAction_CollapseExpandAllAction();
    }

    @Override
    public void onKeyModifier(int parameter) {
    }

    @Override
    protected void onSelectionUpdate(PackageControllerTable<?, ?> table) {
        if (table == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

