/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.toolbar.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.KeyStroke;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.gui.KeyObserver;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.action.ByPassDialogSetup;
import org.jdownloader.gui.views.downloads.action.DownloadTabActionUtils;
import org.jdownloader.gui.views.downloads.action.Modifier;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.translate._JDT;

public class GenericDeleteFromTableToolbarAction
extends AbstractToolBarAction
implements ExtTableListener,
GUIListener,
ExtTableModelListener,
ActionContext,
DownloadControllerListener,
LinkCollectorListener {
    public static final String ONLY_SELECTED_ITEMS = "OnlySelectedItems";
    public static final String DELETE_ALL = "deleteAll";
    public static final String DELETE_DISABLED = "deleteDisabled";
    public static final String DELETE_FAILED = "deleteFailed";
    public static final String DELETE_FINISHED = "deleteFinished";
    public static final String DELETE_OFFLINE = "deleteOffline";
    private static final long serialVersionUID = 1L;
    private DelayedRunnable delayer;
    private boolean deleteAll = false;
    private boolean deleteDisabled = false;
    private boolean deleteFailed = false;
    private boolean deleteFinished = false;
    private boolean deleteOffline = false;
    private boolean ignoreFiltered = true;
    private WeakReference<CrawledLink> lastCrawledLink = new WeakReference<Object>(null);
    private WeakReference<DownloadLink> lastDownloadLink = new WeakReference<Object>(null);
    private boolean onlySelectedItems = false;
    private WeakReference<SelectionInfo<?, ?>> selection = new WeakReference<Object>(null);
    private ByPassDialogSetup byPass = new ByPassDialogSetup();
    private Modifier deleteFilesToggleModifier = null;
    private GraphicalUserInterfaceSettings.DeleteFileOptions deleteMode;

    public GenericDeleteFromTableToolbarAction() {
        this.addContextSetup(this.byPass);
        this.setIconKey("delete");
        this.delayer = new DelayedRunnable(500L, 1500L){

            public void delayedrun() {
                GenericDeleteFromTableToolbarAction.this.update();
            }
        };
        GUIEventSender.getInstance().addListener(this, true);
        this.onGuiMainTabSwitch(null, MainTabbedPane.getInstance().getSelectedView());
        this.update();
    }

    public static String getTranslationForDeleteFilesToggleModifier() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForDeleteFilesToggleModifier();
    }

    public static String getTranslationForDeleteMode() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForDeleteMode();
    }

    public static String getTranslationForDeleteAll() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForDeleteAll();
    }

    public static String getTranslationForDeleteDisabled() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForDeleteDisabled();
    }

    public static String getTranslationForDeleteFailed() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForDeleteFailed();
    }

    public static String getTranslationForDeleteFinished() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForDeleteFinished();
    }

    public static String getTranslationForDeleteOffline() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForDeleteOffline();
    }

    public static String getTranslationForIgnoreFiltered() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForIgnoreFiltered();
    }

    public static String getTranslationForOnlySelectedItems() {
        return _JDT.T.GenericDeleteFromTableToolbarAction_getTranslationForOnlySelectedItems();
    }

    @Customizer(link="#getTranslationForDeleteFilesToggleModifier")
    public Modifier getDeleteFilesToggleModifier() {
        return this.deleteFilesToggleModifier;
    }

    public void setDeleteFilesToggleModifier(Modifier deleteFilesToggleModifier) {
        this.deleteFilesToggleModifier = deleteFilesToggleModifier;
    }

    @Override
    public List<KeyStroke> getAdditionalShortcuts(KeyStroke keystroke) {
        if (keystroke == null) {
            return null;
        }
        ArrayList<KeyStroke> ret = new ArrayList<KeyStroke>();
        Modifier mod = this.byPass.getByPassDialogToggleModifier();
        if (mod != null) {
            ret.add(KeyStroke.getKeyStroke(keystroke.getKeyCode(), keystroke.getModifiers() | mod.getModifier()));
        }
        if ((mod = this.getDeleteFilesToggleModifier()) != null) {
            ret.add(KeyStroke.getKeyStroke(keystroke.getKeyCode(), keystroke.getModifiers() | mod.getModifier()));
        }
        return ret;
    }

    @Customizer(link="#getTranslationForDeleteMode")
    public GraphicalUserInterfaceSettings.DeleteFileOptions getDeleteMode() {
        Modifier deletToggle = this.getDeleteFilesToggleModifier();
        if (this.deleteMode == null) {
            this.deleteMode = GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_ONLY;
        }
        if (deletToggle != null && KeyObserver.getInstance().isModifierPressed(deletToggle.getModifier(), false)) {
            switch (this.deleteMode) {
                case REMOVE_LINKS_ONLY: {
                    return GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_AND_RECYCLE_FILES;
                }
                case REMOVE_LINKS_AND_DELETE_FILES: 
                case REMOVE_LINKS_AND_RECYCLE_FILES: {
                    return GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_ONLY;
                }
            }
        }
        return this.deleteMode;
    }

    public void setDeleteMode(GraphicalUserInterfaceSettings.DeleteFileOptions deleteMode) {
        this.deleteMode = deleteMode;
    }

    public void actionPerformed(ActionEvent e) {
        final SelectionInfo lselection = (SelectionInfo)this.selection.get();
        if (lselection == null || lselection.isEmpty()) {
            return;
        }
        if (lselection.getController() instanceof DownloadController) {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    SelectionInfo<FilePackage, DownloadLink> si;
                    ArrayList<DownloadLink> nodesToDelete = new ArrayList<DownloadLink>();
                    boolean createNewSelectionInfo = false;
                    for (Object dl : lselection.getChildren()) {
                        if (GenericDeleteFromTableToolbarAction.this.checkDownloadLink((DownloadLink)dl)) {
                            nodesToDelete.add((DownloadLink)dl);
                            continue;
                        }
                        createNewSelectionInfo = true;
                    }
                    if (nodesToDelete.size() > 0 && (si = createNewSelectionInfo ? new SelectionInfo<FilePackage, DownloadLink>(null, nodesToDelete) : lselection).getChildren().size() > 0) {
                        DownloadTabActionUtils.deleteLinksRequest(si, _GUI.T.GenericDeleteFromDownloadlistAction_actionPerformed_ask_(GenericDeleteFromTableToolbarAction.this.createName()), GenericDeleteFromTableToolbarAction.this.getDeleteMode(), GenericDeleteFromTableToolbarAction.this.byPass.isBypassDialog());
                        return null;
                    }
                    new EDTHelper<Void>(){

                        public Void edtRun() {
                            Toolkit.getDefaultToolkit().beep();
                            Dialog.getInstance().showErrorDialog(_GUI.T.GenericDeleteSelectedToolbarAction_actionPerformed_nothing_to_delete_());
                            return null;
                        }
                    }.start(true);
                    return null;
                }
            });
        } else if (lselection.getController() instanceof LinkCollector) {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    ArrayList<CrawledLink> nodesToDelete = new ArrayList<CrawledLink>();
                    boolean containsOnline = false;
                    for (Object l : lselection.getChildren()) {
                        CrawledLink dl = (CrawledLink)l;
                        CrawledPackage parentNode = dl.getParentNode();
                        if (parentNode == null || !GenericDeleteFromTableToolbarAction.this.checkCrawledLink(dl)) continue;
                        nodesToDelete.add(dl);
                        if (CrawledPackage.TYPE.OFFLINE == parentNode.getType() || CrawledPackage.TYPE.POFFLINE == parentNode.getType() || dl.getDownloadLink().getAvailableStatus() == DownloadLink.AvailableStatus.FALSE) continue;
                        containsOnline = true;
                    }
                    if (nodesToDelete.size() > 0) {
                        LinkCollector.requestDeleteLinks(nodesToDelete, containsOnline, GenericDeleteFromTableToolbarAction.this.createName(), GenericDeleteFromTableToolbarAction.this.byPass.isBypassDialog(), false, false, false, false);
                    }
                    return null;
                }
            });
        }
    }

    public boolean checkCrawledLink(CrawledLink cl) {
        if (this.isDeleteAll()) {
            return true;
        }
        if (this.isDeleteDisabled() && !cl.isEnabled()) {
            return true;
        }
        return this.isDeleteOffline() && cl.getDownloadLink().isAvailabilityStatusChecked() && cl.getDownloadLink().getAvailableStatus() == DownloadLink.AvailableStatus.FALSE;
    }

    public boolean checkDownloadLink(DownloadLink link) {
        if (this.isDeleteAll()) {
            return true;
        }
        if (this.isDeleteDisabled() && !link.isEnabled()) {
            return true;
        }
        if (this.isDeleteFailed() && FinalLinkState.CheckFailed(link.getFinalLinkState())) {
            return true;
        }
        if (this.isDeleteFinished() && FinalLinkState.CheckFinished(link.getFinalLinkState())) {
            return true;
        }
        return this.isDeleteOffline() && link.getFinalLinkState() == FinalLinkState.OFFLINE;
    }

    private String createName() {
        StringBuilder sb = new StringBuilder();
        if (this.isDeleteAll()) {
            if (this.isOnlySelectedItems()) {
                sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_selected_all());
            } else {
                sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_all());
            }
        } else {
            if (this.isOnlySelectedItems()) {
                sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_selected());
            } else {
                sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object());
            }
            boolean first = true;
            if (this.isDeleteDisabled()) {
                if (!first) {
                    sb.append(" & ");
                }
                sb.append(_GUI.T.lit_disabled());
                first = false;
            }
            if (this.isDeleteFailed()) {
                if (!first) {
                    sb.append(" & ");
                }
                first = false;
                sb.append(_GUI.T.lit_failed());
            }
            if (this.isDeleteFinished()) {
                if (!first) {
                    sb.append(" & ");
                }
                first = false;
                sb.append(_GUI.T.lit_finished());
            }
            if (this.isDeleteOffline()) {
                if (!first) {
                    sb.append(" & ");
                }
                first = false;
                sb.append(_GUI.T.lit_offline());
            }
        }
        return sb.toString();
    }

    @Override
    protected String createTooltip() {
        return this.getName();
    }

    @Customizer(link="#getTranslationForDeleteAll")
    public boolean isDeleteAll() {
        return this.deleteAll;
    }

    @Customizer(link="#getTranslationForDeleteDisabled")
    public boolean isDeleteDisabled() {
        return this.deleteDisabled;
    }

    @Customizer(link="#getTranslationForDeleteFailed")
    public boolean isDeleteFailed() {
        return this.deleteFailed;
    }

    @Customizer(link="#getTranslationForDeleteFinished")
    public boolean isDeleteFinished() {
        return this.deleteFinished;
    }

    @Customizer(link="#getTranslationForDeleteOffline")
    public boolean isDeleteOffline() {
        return this.deleteOffline;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Customizer(link="#getTranslationForIgnoreFiltered")
    public boolean isIgnoreFiltered() {
        return this.ignoreFiltered;
    }

    @Customizer(link="#getTranslationForOnlySelectedItems")
    public boolean isOnlySelectedItems() {
        return this.onlySelectedItems;
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
        if (event.getType() == ExtTableEvent.Types.SELECTION_CHANGED) {
            this.update();
        }
    }

    public void onExtTableModelEvent(ExtTableModelEventWrapper listener) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, View newView) {
        this.update();
    }

    @Override
    public void onKeyModifier(int parameter) {
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.update();
    }

    public void setDeleteAll(boolean deleteIdle) {
        this.deleteAll = deleteIdle;
        this.update();
        this.updateName();
        this.delayer.resetAndStart();
    }

    public void setDeleteDisabled(boolean deleteDisabled) {
        this.deleteDisabled = deleteDisabled;
        this.update();
        this.updateName();
        this.delayer.resetAndStart();
    }

    public void setDeleteFailed(boolean deleteFailed) {
        this.deleteFailed = deleteFailed;
        this.update();
        this.updateName();
        this.delayer.resetAndStart();
    }

    public void setDeleteFinished(boolean deleteFinished) {
        this.deleteFinished = deleteFinished;
        this.update();
        this.updateName();
        this.delayer.resetAndStart();
    }

    public void setDeleteOffline(boolean deleteOffline) {
        this.deleteOffline = deleteOffline;
        this.update();
        this.updateName();
        this.delayer.resetAndStart();
    }

    public void setIgnoreFiltered(boolean ignoreFiltered) {
        this.ignoreFiltered = ignoreFiltered;
        this.updateName();
        this.delayer.resetAndStart();
    }

    public void setOnlySelectedItems(boolean onlySelectedItems) {
        this.onlySelectedItems = onlySelectedItems;
        this.update();
        this.updateName();
        this.delayer.resetAndStart();
    }

    protected SelectionInfo<?, ?> fetchSelectionInfo(PackageControllerTable table) {
        if (table == null) {
            return null;
        }
        if (this.isOnlySelectedItems()) {
            return table.getSelectionInfo(true, true);
        }
        if (this.isIgnoreFiltered()) {
            return table.getSelectionInfo(false, true);
        }
        return table.getSelectionInfo(false, false);
    }

    protected void update() {
        if (this.lastDownloadLink != null && this.lastCrawledLink != null) {
            new EDTRunner(){

                protected void runInEDT() {
                    View newView = MainTabbedPane.getInstance().getSelectedView();
                    if (newView instanceof LinkGrabberView) {
                        GenericDeleteFromTableToolbarAction.this.addListener(LinkGrabberTable.getInstance());
                        GenericDeleteFromTableToolbarAction.this.removeListener(DownloadsTable.getInstance());
                        CrawledLink lastCl = (CrawledLink)GenericDeleteFromTableToolbarAction.this.lastCrawledLink.get();
                        SelectionInfo<CrawledPackage, CrawledPackage> selectionInfo = GenericDeleteFromTableToolbarAction.this.fetchSelectionInfo(LinkGrabberTable.getInstance());
                        GenericDeleteFromTableToolbarAction.this.selection = new WeakReference(selectionInfo);
                        if (lastCl != null && selectionInfo.contains(lastCl) && GenericDeleteFromTableToolbarAction.this.checkCrawledLink(lastCl)) {
                            GenericDeleteFromTableToolbarAction.this.setEnabled(true);
                            return;
                        }
                        for (Object link : selectionInfo.getChildren()) {
                            if (!GenericDeleteFromTableToolbarAction.this.checkCrawledLink((CrawledLink)link)) continue;
                            GenericDeleteFromTableToolbarAction.this.setEnabled(true);
                            GenericDeleteFromTableToolbarAction.this.lastCrawledLink = new WeakReference<CrawledLink>((CrawledLink)link);
                            return;
                        }
                        GenericDeleteFromTableToolbarAction.this.setEnabled(false);
                    } else if (newView instanceof DownloadsView) {
                        GenericDeleteFromTableToolbarAction.this.addListener(DownloadsTable.getInstance());
                        GenericDeleteFromTableToolbarAction.this.removeListener(LinkGrabberTable.getInstance());
                        SelectionInfo<FilePackage, FilePackage> selectionInfo = GenericDeleteFromTableToolbarAction.this.fetchSelectionInfo(DownloadsTable.getInstance());
                        GenericDeleteFromTableToolbarAction.this.selection = new WeakReference(selectionInfo);
                        if (GenericDeleteFromTableToolbarAction.this.isDeleteAll() && !selectionInfo.isEmpty()) {
                            GenericDeleteFromTableToolbarAction.this.setEnabled(true);
                            return;
                        }
                        DownloadLink lastDl = (DownloadLink)GenericDeleteFromTableToolbarAction.this.lastDownloadLink.get();
                        if (lastDl != null && selectionInfo.contains(lastDl) && GenericDeleteFromTableToolbarAction.this.checkDownloadLink(lastDl)) {
                            GenericDeleteFromTableToolbarAction.this.setEnabled(true);
                            return;
                        }
                        for (Object link : selectionInfo.getChildren()) {
                            if (!GenericDeleteFromTableToolbarAction.this.checkDownloadLink((DownloadLink)link)) continue;
                            GenericDeleteFromTableToolbarAction.this.lastDownloadLink = new WeakReference<DownloadLink>((DownloadLink)link);
                            GenericDeleteFromTableToolbarAction.this.setEnabled(true);
                            return;
                        }
                        GenericDeleteFromTableToolbarAction.this.setEnabled(false);
                    } else {
                        GenericDeleteFromTableToolbarAction.this.selection = new WeakReference<Object>(null);
                        GenericDeleteFromTableToolbarAction.this.removeListener(LinkGrabberTable.getInstance());
                        GenericDeleteFromTableToolbarAction.this.removeListener(DownloadsTable.getInstance());
                        GenericDeleteFromTableToolbarAction.this.setEnabled(false);
                    }
                }
            };
        }
    }

    private void addListener(PackageControllerTable<?, ?> table) {
        table.getEventSender().addListener((EventListener)this, true);
        table.getModel().getEventSender().addListener((EventListener)this, true);
        if (table.getController() instanceof DownloadController) {
            DownloadController.getInstance().addListener(this, true);
        } else if (table.getController() instanceof LinkCollector) {
            LinkCollector.getInstance().getEventsender().addListener(this, true);
        }
    }

    private void removeListener(PackageControllerTable<?, ?> table) {
        table.getEventSender().removeListener((EventListener)this);
        table.getModel().getEventSender().removeListener((EventListener)this);
        if (table.getController() instanceof DownloadController) {
            DownloadController.getInstance().removeListener(this);
        } else if (table.getController() instanceof LinkCollector) {
            LinkCollector.getInstance().getEventsender().removeListener(this);
        }
    }

    private void updateName() {
        new EDTRunner(){

            protected void runInEDT() {
                GenericDeleteFromTableToolbarAction.this.setName(GenericDeleteFromTableToolbarAction.this.createName());
            }
        };
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink link) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink link) {
    }

    @Override
    public void onLinkCrawlerAdded(LinkCollectorCrawler crawler) {
    }

    @Override
    public void onLinkCrawlerStarted(LinkCollectorCrawler crawler) {
    }

    @Override
    public void onLinkCrawlerStopped(LinkCollectorCrawler crawler) {
    }

    @Override
    public void onLinkCrawlerFinished() {
    }

    @Override
    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
    }
}

