/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.util.List;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.utils.event.queue.Queue;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;

public class PackageControllerTableModelSelectionInfo<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends SelectionInfo<PackageType, ChildrenType> {
    private final PackageControllerTableModelData<PackageType, ChildrenType> tableModelData;
    private final AbstractNode rawContext;

    protected PackageControllerTableModelSelectionInfo(AbstractNode contextObject, PackageControllerTableModel<PackageType, ChildrenType> tableModel) {
        super(tableModel.getController());
        this.rawContext = contextObject;
        this.tableModelData = tableModel.getTableData();
        this.aggregate();
    }

    @Override
    public AbstractNode getRawContext() {
        return this.rawContext;
    }

    @Override
    public List<AbstractNode> getRawSelection() {
        return this.tableModelData;
    }

    @Override
    protected void aggregate(Queue queue) {
        super.aggregate(null);
    }

    @Override
    protected void aggregate() {
        for (final PackageControllerTableModelData.PackageControllerTableModelDataPackage<PackageType, ChildrenType> modelDataPackage : this.tableModelData.getModelDataPackages()) {
            final AbstractPackageNode pkg = (AbstractPackageNode)modelDataPackage.getPackage();
            final int index = this.children.size();
            List<ChildrenType> visible = modelDataPackage.getVisibleChildren();
            for (AbstractNode node : visible) {
                this.children.add((AbstractPackageChildrenNode)node);
            }
            final int size = visible.size();
            SelectionInfo.PackageView packageView = new SelectionInfo.PackageView<PackageType, ChildrenType>(){

                @Override
                public List<ChildrenType> getChildren() {
                    return PackageControllerTableModelSelectionInfo.this.children.subList(index, index + size);
                }

                @Override
                public PackageType getPackage() {
                    return pkg;
                }

                @Override
                public boolean isPackageSelected() {
                    return true;
                }

                @Override
                public boolean isExpanded() {
                    return modelDataPackage.isExpanded();
                }

                @Override
                public List<ChildrenType> getSelectedChildren() {
                    return PackageControllerTableModelSelectionInfo.this.children.subList(index, index + size);
                }
            };
            this.addPackageView(packageView, pkg);
        }
    }
}

