/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.event.queue.Queue;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;

public class PackageControllerTableModelSelectionOnlySelectionInfo<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends SelectionInfo<PackageType, ChildrenType> {
    private final PackageControllerTableModel<PackageType, ChildrenType> tableModel;
    private final PackageControllerTableModelData<PackageType, ChildrenType> tableModelData;
    private ListSelectionModel selectionModel = null;
    private volatile AbstractNode rawContext = null;
    private final AtomicBoolean unselectedChildrenInitialized = new AtomicBoolean(false);
    private final ArrayList<ChildrenType> unselectedChildren = new ArrayList();

    protected void setRawContext(AbstractNode rawContext) {
        this.rawContext = rawContext;
    }

    protected PackageControllerTableModelSelectionOnlySelectionInfo(AbstractNode contextObject, PackageControllerTableModel<PackageType, ChildrenType> tableModel) {
        super(tableModel.getController());
        this.rawContext = contextObject;
        this.tableModel = tableModel;
        this.tableModelData = tableModel.getTableData();
        this.aggregate();
    }

    protected PackageControllerTableModelSelectionOnlySelectionInfo(AbstractNode contextObject, PackageControllerTableModelSelectionOnlySelectionInfo<PackageType, ChildrenType> selectionInfo) {
        super(selectionInfo.getController());
        this.rawContext = contextObject;
        this.tableModel = selectionInfo.tableModel;
        this.tableModelData = selectionInfo.tableModelData;
        this.selectionModel = selectionInfo.selectionModel;
        this.rawSelection.addAll(selectionInfo.rawSelection);
        this.children.addAll(selectionInfo.children);
        if (selectionInfo.unselectedChildrenInitialized.get()) {
            this.unselectedChildrenInitialized.set(true);
            this.unselectedChildren.addAll(selectionInfo.getUnselectedChildren());
        }
        this.packageViewList.addAll(selectionInfo.packageViewList);
        this.packageViews.putAll(selectionInfo.packageViews);
        if (selectionInfo.pluginViewsInitiated.get()) {
            this.pluginViewsInitiated.set(true);
            this.pluginViews.putAll(selectionInfo.pluginViews);
        }
    }

    @Override
    public AbstractNode getRawContext() {
        return this.rawContext;
    }

    @Override
    protected void aggregate(Queue queue) {
        super.aggregate(null);
    }

    @Override
    protected void aggregate() {
        ListSelectionModel selectionModel = this.tableModel.getTable().getSelectionModel();
        if (selectionModel == null || this.tableModel.isTableSelectionClearing() || selectionModel.isSelectionEmpty()) {
            return;
        }
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return;
        }
        if (iMin >= this.tableModelData.size() || iMax >= this.tableModelData.size()) {
            throw new IllegalStateException("SelectionModel and TableData missmatch! IMin:" + iMin + "|IMax:" + iMax + "|TableSize:" + this.tableModelData.size());
        }
        if (selectionModel instanceof DefaultListSelectionModel) {
            try {
                this.selectionModel = (ListSelectionModel)((DefaultListSelectionModel)selectionModel).clone();
            }
            catch (CloneNotSupportedException e) {
                this.selectionModel = selectionModel;
            }
        } else {
            this.selectionModel = selectionModel;
        }
        if (this.rawSelection instanceof ArrayList) {
            ((ArrayList)this.rawSelection).ensureCapacity(Math.max(1, iMax - iMin));
        }
        ArrayList<AbstractPackageChildrenNode> lastPackageSelectedChildren = new ArrayList<AbstractPackageChildrenNode>();
        PackageControllerTableModelData.PackageControllerTableModelDataPackage lastPackage = null;
        boolean lastPackageSelected = false;
        AtomicInteger lastPackageIndex = new AtomicInteger(0);
        for (int selectionIndex = iMin; selectionIndex <= iMax; ++selectionIndex) {
            PackageType pkg;
            AbstractPackageNode pkg2;
            AbstractNode node = (AbstractNode)this.tableModelData.get(selectionIndex);
            if (node instanceof AbstractPackageNode) {
                pkg2 = (AbstractPackageNode)node;
                if (lastPackage != null) {
                    this.aggregatePackagePackageView(lastPackage, lastPackageSelected, lastPackageSelectedChildren);
                    lastPackage = null;
                    lastPackageSelected = false;
                    lastPackageSelectedChildren.clear();
                }
            }
            if (!selectionModel.isSelectedIndex(selectionIndex)) continue;
            this.rawSelection.add(node);
            if (node instanceof AbstractPackageNode) {
                pkg2 = (AbstractPackageNode)node;
                this.aggregatePackagePackageView(lastPackage, lastPackageSelected, lastPackageSelectedChildren);
                lastPackage = this.getPackageData(lastPackageIndex, pkg2);
                lastPackageSelected = true;
                lastPackageSelectedChildren.clear();
                continue;
            }
            if (!(node instanceof AbstractPackageChildrenNode)) continue;
            AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)node;
            if (this.tableModelData.isHiddenPackageSingleChildIndex(selectionIndex)) {
                if (lastPackage != null) {
                    this.aggregatePackagePackageView(lastPackage, lastPackageSelected, lastPackageSelectedChildren);
                    lastPackage = null;
                    lastPackageSelected = false;
                    lastPackageSelectedChildren.clear();
                }
                pkg = this.getPackage(lastPackageIndex.get(), child);
                lastPackage = this.getPackageData(lastPackageIndex, pkg);
                lastPackageSelected = true;
                lastPackageSelectedChildren.add(child);
                continue;
            }
            if (lastPackage == null) {
                pkg = this.getPreviousPackage(selectionIndex, child);
                lastPackage = this.getPackageData(lastPackageIndex, pkg);
                lastPackageSelected = false;
            }
            lastPackageSelectedChildren.add(child);
        }
        this.aggregatePackagePackageView(lastPackage, lastPackageSelected, lastPackageSelectedChildren);
    }

    @Override
    public synchronized List<ChildrenType> getUnselectedChildren() {
        if (!this.unselectedChildrenInitialized.get() && this.selectionModel != null) {
            this.unselectedChildrenInitialized.set(true);
            AtomicInteger lastPackageIndex = new AtomicInteger(0);
            int maxSize = this.tableModelData.size();
            ArrayList<AbstractPackageChildrenNode> unselected = new ArrayList<AbstractPackageChildrenNode>();
            for (int selectionIndex = 0; selectionIndex < maxSize; ++selectionIndex) {
                AbstractNode node = (AbstractNode)this.tableModelData.get(selectionIndex);
                boolean isSelected = this.selectionModel.isSelectedIndex(selectionIndex);
                if (node instanceof AbstractPackageNode) {
                    this.unselectedChildren.addAll(unselected);
                    unselected.clear();
                    AbstractPackageNode pkg = (AbstractPackageNode)node;
                    PackageControllerTableModelData.PackageControllerTableModelDataPackage<AbstractPackageNode, ChildrenType> pkgData = this.getPackageData(lastPackageIndex, pkg);
                    if (!pkgData.isExpanded()) {
                        if (isSelected) continue;
                        for (AbstractPackageChildrenNode child : pkgData.getVisibleChildren()) {
                            this.unselectedChildren.add(child);
                        }
                        continue;
                    }
                    if (isSelected) continue;
                    for (AbstractPackageChildrenNode child : pkgData.getVisibleChildren()) {
                        unselected.add(child);
                    }
                    continue;
                }
                if (!(node instanceof AbstractPackageChildrenNode)) continue;
                boolean hidden = this.tableModelData.isHiddenPackageSingleChildIndex(selectionIndex);
                if (hidden) {
                    this.unselectedChildren.addAll(unselected);
                    unselected.clear();
                    if (isSelected) continue;
                    this.unselectedChildren.add((AbstractPackageChildrenNode)node);
                    continue;
                }
                if (!isSelected) continue;
                unselected.remove(node);
            }
            this.unselectedChildren.addAll(unselected);
        }
        return this.unselectedChildren;
    }

    private PackageType getPackage(int lastPackageIndex, ChildrenType childrenType) {
        int size = this.tableModelData.getModelDataPackages().size();
        for (int index = lastPackageIndex; index < size; ++index) {
            PackageControllerTableModelData.PackageControllerTableModelDataPackage<PackageType, ChildrenType> next = this.tableModelData.getModelDataPackages().get(index);
            if (!next.getVisibleChildren().contains(childrenType)) continue;
            return (PackageType)((AbstractPackageNode)next.getPackage());
        }
        throw new WTFException("No PreviousPackage?!");
    }

    private PackageType getPreviousPackage(int currentIndex, ChildrenType childrenType) {
        for (int index = currentIndex; index >= 0; --index) {
            AbstractNode node = (AbstractNode)this.tableModelData.get(index);
            if (!(node instanceof AbstractPackageNode)) continue;
            return (PackageType)((AbstractPackageNode)node);
        }
        throw new WTFException("No PreviousPackage?!");
    }

    private PackageControllerTableModelData.PackageControllerTableModelDataPackage<PackageType, ChildrenType> getPackageData(AtomicInteger lastPackageIndex, PackageType currentPackage) {
        int size = this.tableModelData.getModelDataPackages().size();
        for (int index = lastPackageIndex.get(); index < size; ++index) {
            PackageControllerTableModelData.PackageControllerTableModelDataPackage<PackageType, ChildrenType> next = this.tableModelData.getModelDataPackages().get(index);
            if (next.getPackage() != currentPackage) continue;
            lastPackageIndex.set(index);
            return next;
        }
        throw new WTFException("MissMatch between Selection and TableData detected");
    }

    private void aggregatePackagePackageView(final PackageControllerTableModelData.PackageControllerTableModelDataPackage<PackageType, ChildrenType> pkgData, final boolean packageSelected, List<ChildrenType> selectedChildren) {
        if (pkgData != null) {
            List<ChildrenType> visible;
            AbstractPackageNode pkg = (AbstractPackageNode)pkgData.getPackage();
            final int index = this.children.size();
            if (!pkgData.isExpanded()) {
                List<ChildrenType> visible2 = pkgData.getVisibleChildren();
                for (AbstractNode node : visible2) {
                    this.children.add((AbstractPackageChildrenNode)node);
                }
                final int size = visible2.size();
                SelectionOnlyPackageView packageView = new SelectionOnlyPackageView<PackageType, ChildrenType>(){

                    @Override
                    public List<ChildrenType> getChildren() {
                        return PackageControllerTableModelSelectionOnlySelectionInfo.this.children.subList(index, index + size);
                    }

                    @Override
                    public PackageType getPackage() {
                        return (AbstractPackageNode)pkgData.getPackage();
                    }

                    @Override
                    public boolean isPackageSelected() {
                        return packageSelected;
                    }

                    @Override
                    public List<ChildrenType> getVisibleChildren() {
                        return pkgData.getVisibleChildren();
                    }

                    @Override
                    public List<ChildrenType> getInvisibleChildren() {
                        return pkgData.getVisibleChildren();
                    }

                    @Override
                    public boolean isExpanded() {
                        return pkgData.isExpanded();
                    }

                    @Override
                    public List<ChildrenType> getSelectedChildren() {
                        return PackageControllerTableModelSelectionOnlySelectionInfo.this.children.subList(index, index + size);
                    }
                };
                this.addPackageView(packageView, pkg);
                return;
            }
            if (selectedChildren.size() == 0) {
                List<ChildrenType> visible3 = pkgData.getVisibleChildren();
                for (AbstractNode node : visible3) {
                    this.children.add((AbstractPackageChildrenNode)node);
                }
                final int size = visible3.size();
                SelectionOnlyPackageView packageView = new SelectionOnlyPackageView<PackageType, ChildrenType>(){

                    @Override
                    public List<ChildrenType> getChildren() {
                        return PackageControllerTableModelSelectionOnlySelectionInfo.this.children.subList(index, index + size);
                    }

                    @Override
                    public List<ChildrenType> getVisibleChildren() {
                        return pkgData.getVisibleChildren();
                    }

                    @Override
                    public List<ChildrenType> getInvisibleChildren() {
                        return pkgData.getVisibleChildren();
                    }

                    @Override
                    public PackageType getPackage() {
                        return (AbstractPackageNode)pkgData.getPackage();
                    }

                    @Override
                    public boolean isPackageSelected() {
                        return packageSelected;
                    }

                    @Override
                    public boolean isExpanded() {
                        return pkgData.isExpanded();
                    }

                    @Override
                    public List<ChildrenType> getSelectedChildren() {
                        return new ArrayList(0);
                    }
                };
                this.addPackageView(packageView, pkg);
                return;
            }
            if (selectedChildren.size() == 1 && pkgData.isExpanded() && this.tableModelData.isHideSingleChildPackages() && (visible = pkgData.getVisibleChildren()).size() == 1) {
                for (AbstractNode node : visible) {
                    this.children.add((AbstractPackageChildrenNode)node);
                }
                final int size = visible.size();
                SelectionOnlyPackageView packageView = new SelectionOnlyPackageView<PackageType, ChildrenType>(){

                    @Override
                    public List<ChildrenType> getChildren() {
                        return PackageControllerTableModelSelectionOnlySelectionInfo.this.children.subList(index, index + size);
                    }

                    @Override
                    public List<ChildrenType> getVisibleChildren() {
                        return pkgData.getVisibleChildren();
                    }

                    @Override
                    public List<ChildrenType> getInvisibleChildren() {
                        return pkgData.getVisibleChildren();
                    }

                    @Override
                    public PackageType getPackage() {
                        return (AbstractPackageNode)pkgData.getPackage();
                    }

                    @Override
                    public boolean isPackageSelected() {
                        return true;
                    }

                    @Override
                    public boolean isExpanded() {
                        return true;
                    }

                    @Override
                    public List<ChildrenType> getSelectedChildren() {
                        return new ArrayList(0);
                    }
                };
                this.addPackageView(packageView, pkg);
                return;
            }
            this.children.addAll(selectedChildren);
            final int size = selectedChildren.size();
            SelectionOnlyPackageView packageView = new SelectionOnlyPackageView<PackageType, ChildrenType>(){

                @Override
                public List<ChildrenType> getChildren() {
                    return PackageControllerTableModelSelectionOnlySelectionInfo.this.children.subList(index, index + size);
                }

                @Override
                public PackageType getPackage() {
                    return (AbstractPackageNode)pkgData.getPackage();
                }

                @Override
                public boolean isPackageSelected() {
                    return packageSelected;
                }

                @Override
                public boolean isExpanded() {
                    return pkgData.isExpanded();
                }

                @Override
                public List<ChildrenType> getSelectedChildren() {
                    return PackageControllerTableModelSelectionOnlySelectionInfo.this.children.subList(index, index + size);
                }

                @Override
                public List<ChildrenType> getVisibleChildren() {
                    return pkgData.getVisibleChildren();
                }

                @Override
                public List<ChildrenType> getInvisibleChildren() {
                    return pkgData.getVisibleChildren();
                }
            };
            this.addPackageView(packageView, pkg);
            return;
        }
    }

    public static interface SelectionOnlyPackageView<PackageType, ChildrenType>
    extends SelectionInfo.PackageView {
        public List<ChildrenType> getVisibleChildren();

        public List<ChildrenType> getInvisibleChildren();
    }
}

