/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.context.rename;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.swing.components.ExtTextField;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberAbsoluteDialogLocator;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.context.rename.Result;
import org.jdownloader.gui.views.components.packagetable.context.rename.TestWaitDialog;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class RenameDialog
extends AbstractDialog<Object> {
    private ExtTextField txtSearch;
    private ExtTextField txtReplace;
    private ExtCheckBox cbRegex;
    private final List<AbstractNode> nodes = new ArrayList<AbstractNode>();
    private Boolean allSameExtension = null;

    public RenameDialog(SelectionInfo<? extends AbstractPackageNode, ? extends AbstractPackageChildrenNode> selection) {
        super(0, "", (Icon)new AbstractIcon("edit", 32), _GUI.T.lit_continue(), null);
        this.setLocator((DialogLocator)new RememberAbsoluteDialogLocator(((Object)((Object)this)).getClass().getName()));
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension(((Object)((Object)this)).getClass().getName()));
        if (selection.isPackageContext()) {
            this.setTitle(_GUI.T.RenameDialog_RenameDialog_Packages(selection.getPackageViews().size()));
            for (SelectionInfo.PackageView<? extends AbstractPackageNode, ? extends AbstractPackageChildrenNode> packageView : selection.getPackageViews()) {
                this.nodes.add(packageView.getPackage());
            }
        } else {
            this.setTitle(_GUI.T.RenameDialog_RenameDialog(selection.getChildren().size()));
            this.nodes.addAll(selection.getChildren());
        }
        this.setLeftActions(new AbstractAction[]{new AppAction(){
            {
                this.setName(_GUI.T.lit_preview());
            }

            public void actionPerformed(ActionEvent e1) {
                try {
                    boolean regex = RenameDialog.this.cbRegex.isSelected();
                    CFG_GUI.CFG.setRenameActionRegexEnabled(regex);
                    Pattern pattern = RenameDialog.createPattern(RenameDialog.this.txtSearch.getText(), regex);
                    String rep = RenameDialog.this.txtReplace.getText();
                    ArrayList<Result> list = new ArrayList<Result>();
                    for (AbstractNode node : RenameDialog.this.nodes) {
                        String newName;
                        String oldName;
                        if (node instanceof CrawledLink) {
                            oldName = node.getName();
                            newName = RenameDialog.this.replace((CrawledLink)node, pattern, rep, true);
                            list.add(new Result(oldName, newName, node));
                            continue;
                        }
                        if (node instanceof DownloadLink) {
                            oldName = node.getName();
                            newName = RenameDialog.this.replace((DownloadLink)node, pattern, rep, true);
                            list.add(new Result(oldName, newName, node));
                            continue;
                        }
                        if (node instanceof FilePackage) {
                            oldName = node.getName();
                            newName = RenameDialog.this.replace((FilePackage)node, pattern, rep, true);
                            list.add(new Result(oldName, newName, node));
                            continue;
                        }
                        if (!(node instanceof CrawledPackage)) continue;
                        oldName = node.getName();
                        newName = RenameDialog.this.replace((CrawledPackage)node, pattern, rep, true);
                        list.add(new Result(oldName, newName, node));
                    }
                    TestWaitDialog d = new TestWaitDialog(regex, pattern, rep, list);
                    UIOManager.I().show(null, (UserIODefinition)d);
                }
                catch (Throwable e) {
                    Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e.getMessage(), e);
                }
            }
        }});
    }

    private String replace(CrawledPackage node, Pattern pattern, String rep, boolean preview) {
        CrawledPackage pkg = node;
        String oldName = pkg.getName();
        String newName = pattern.matcher(oldName).replaceAll(rep);
        newName = PackagizerController.replaceDynamicTags(newName, oldName, node);
        return newName;
    }

    private String replace(FilePackage node, Pattern pattern, String rep, boolean preview) {
        FilePackage pkg = node;
        String oldName = pkg.getName();
        String newName = pattern.matcher(oldName).replaceAll(rep);
        newName = PackagizerController.replaceDynamicTags(newName, oldName, node);
        return newName;
    }

    private String replace(DownloadLink node, Pattern pattern, String rep, boolean preview) {
        DownloadLink link = node;
        String oldName = link.getName();
        String fpName = link.getFilePackage().getName();
        String newName = pattern.matcher(oldName).replaceAll(rep);
        newName = PackagizerController.replaceDynamicTags(newName, fpName, node);
        return newName;
    }

    private String replace(CrawledLink node, Pattern pattern, String rep, boolean preview) {
        CrawledLink link = node;
        String oldName = link.getName();
        String pkgName = link.getParentNode().getName();
        String newName = pattern.matcher(oldName).replaceAll(rep);
        newName = PackagizerController.replaceDynamicTags(newName, pkgName, node);
        return newName;
    }

    protected Object createReturnValue() {
        return null;
    }

    public static Pattern createPattern(String regex, boolean useRegex) {
        if (useRegex) {
            return Pattern.compile(regex, 34);
        }
        regex = regex.replaceAll("\\*+", "*").trim();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)regex)) {
            sb.append("^(.*)");
        } else if (regex.equals("*")) {
            sb.append("^(.*)");
        } else {
            if (regex.startsWith("*")) {
                sb.append("^(.*)");
            }
            String[] parts = regex.split("\\*+");
            int actualParts = 0;
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].length() == 0) continue;
                if (actualParts > 0) {
                    sb.append("(.*)");
                }
                sb.append(Pattern.quote(parts[i]));
                ++actualParts;
            }
            if (sb.length() == 0) {
                sb.append("^(.*)");
            } else if (regex.endsWith("*")) {
                sb.append("(.*)");
            }
        }
        return Pattern.compile(sb.toString(), 34);
    }

    protected void setReturnmask(boolean b) {
        super.setReturnmask(b);
        if (b) {
            try {
                boolean regex = this.cbRegex.isSelected();
                CFG_GUI.CFG.setRenameActionRegexEnabled(regex);
                Pattern pattern = RenameDialog.createPattern(this.txtSearch.getText(), regex);
                String rep = this.txtReplace.getText();
                for (AbstractNode node : this.nodes) {
                    String newName;
                    if (node instanceof CrawledLink) {
                        newName = this.replace((CrawledLink)node, pattern, rep, false);
                        ((CrawledLink)node).setName(newName);
                        continue;
                    }
                    if (node instanceof DownloadLink) {
                        newName = this.replace((DownloadLink)node, pattern, rep, false);
                        DownloadWatchDog.getInstance().renameLink((DownloadLink)node, newName);
                        continue;
                    }
                    if (node instanceof FilePackage) {
                        newName = this.replace((FilePackage)node, pattern, rep, false);
                        ((FilePackage)node).setName(newName);
                        continue;
                    }
                    if (!(node instanceof CrawledPackage)) continue;
                    newName = this.replace((CrawledPackage)node, pattern, rep, false);
                    ((CrawledPackage)node).setName(newName);
                }
            }
            catch (Exception e) {
                Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated
    public static String removeArchiveExtension(AbstractNode node, String name) {
        return RenameDialog.removeArchiveExtension(node, name, null);
    }

    public static String removeArchiveExtension(AbstractNode node, String name, List<Object> types) {
        if (node == null || node instanceof AbstractPackageChildrenNode) {
            String ret = name;
            boolean again = true;
            block6: while (again) {
                again = false;
                block7: for (ArchiveType archiveType : ArchiveType.values()) {
                    switch (archiveType) {
                        case RAR_MULTI: 
                        case RAR_MULTI2: 
                        case RAR_MULTI3: 
                        case RAR_MULTI4: 
                        case SEVENZIP_PARTS: 
                        case ZIP_MULTI: 
                        case ZIP_MULTI2: {
                            if (!archiveType.matches(ret)) continue block7;
                            if (types != null) {
                                types.add(archiveType);
                            }
                            ret = archiveType.getMatches(ret)[0];
                            again = true;
                            continue block6;
                        }
                    }
                }
                block8: for (ArchiveType archiveType : SplitType.values()) {
                    switch (2.$SwitchMap$org$jdownloader$extensions$extraction$split$SplitType[archiveType.ordinal()]) {
                        case 1: {
                            if (!archiveType.matches(ret)) continue block8;
                            if (types != null) {
                                types.add(archiveType);
                            }
                            ret = archiveType.getMatches(ret)[0];
                            again = true;
                            continue block6;
                        }
                    }
                }
            }
            return ret;
        }
        return name;
    }

    public JComponent layoutDialogContent() {
        String allRegex = null;
        String allReplace = null;
        int length = 0;
        int lastRegexLength = -1;
        ArrayList<Object> lastExtensionTypes = null;
        for (AbstractNode node : this.nodes) {
            if (!(node instanceof AbstractNode)) continue;
            String nodeName = node.getName();
            ArrayList<Object> extensionTypes = Boolean.FALSE.equals(this.allSameExtension) ? null : new ArrayList<Object>();
            String name = RenameDialog.removeArchiveExtension(node, nodeName, extensionTypes);
            if (extensionTypes != null) {
                if (lastExtensionTypes == null) {
                    lastExtensionTypes = extensionTypes;
                } else if (!lastExtensionTypes.equals(extensionTypes)) {
                    this.allSameExtension = Boolean.FALSE;
                    lastExtensionTypes = null;
                }
            }
            if (name == null) continue;
            allRegex = this.merge(name, allRegex);
            length = nodeName.length();
            if (lastRegexLength == -1) {
                lastRegexLength = allRegex.length();
                continue;
            }
            if (lastRegexLength == allRegex.length()) continue;
            this.allSameExtension = Boolean.FALSE;
            lastExtensionTypes = null;
        }
        this.allSameExtension = lastExtensionTypes != null && lastExtensionTypes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        boolean regex = CFG_GUI.CFG.isRenameActionRegexEnabled();
        if (StringUtils.isEmpty(allRegex)) {
            allRegex = regex ? "^(.*)" : "*";
            allReplace = "$1";
        } else if (length == allRegex.length()) {
            allReplace = allRegex;
            allRegex = (regex ? "^" : "") + this.quote(allRegex, regex);
        } else {
            allReplace = Matcher.quoteReplacement(allRegex) + "$1";
            allRegex = (regex ? "^" : "") + this.quote(allRegex, regex) + (regex ? "(.*)" : "*");
        }
        this.txtSearch = new ExtTextField();
        this.txtSearch.setText(allRegex);
        this.txtReplace = new ExtTextField();
        this.cbRegex = new ExtCheckBox(new JComponent[0]);
        this.txtReplace.setText(allReplace);
        this.cbRegex.setSelected(regex);
        MigPanel p = new MigPanel("ins 0,wrap 2", "[right][grow,fill]", "[][]");
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.RenameDialog_layoutDialogContent_search())));
        p.add((Component)this.txtSearch);
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.RenameDialog_layoutDialogContent_replace())));
        p.add((Component)this.txtReplace);
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.RenameDialog_layoutDialogContent_regex())));
        p.add((Component)this.cbRegex);
        return p;
    }

    protected void initFocus(JComponent focus) {
        if (Boolean.FALSE.equals(this.allSameExtension)) {
            this.txtReplace.selectAll();
        } else {
            int matchIndex;
            int n = matchIndex = Boolean.TRUE.equals(this.allSameExtension) ? this.txtReplace.getText().indexOf("$1") : -1;
            if (matchIndex != -1 && matchIndex > 0) {
                this.txtReplace.select(0, matchIndex);
            } else {
                this.txtReplace.selectAll();
            }
        }
        this.txtReplace.requestFocusInWindow();
    }

    protected int getPreferredWidth() {
        return 500;
    }

    private String quote(String allRegex, boolean regex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < allRegex.length(); ++i) {
            char c = allRegex.charAt(i);
            if (regex) {
                switch (c) {
                    case '$': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        sb.append("\\");
                    }
                }
            } else {
                switch (c) {
                    case '\\': {
                        sb.append("\\");
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String merge(String name, String allRegex) {
        if (allRegex == null) {
            return name;
        }
        return StringUtils.getCommonalities((String)name, (String)allRegex);
    }
}

