/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.dragdrop;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.dragdrop.MergePosition;
import org.jdownloader.gui.views.components.packagetable.dragdrop.PackageControllerTableTransferable;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;

public abstract class PackageControllerTableTransferHandler<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends TransferHandler {
    private static final long serialVersionUID = 4546100125368290556L;
    protected final PackageControllerTable<PackageType, ChildrenType> table;
    private final AtomicReference<String> transferableStringContent = new AtomicReference<Object>(null);
    protected final WeakHashMap<Transferable, Map<Object, Object>> transferableCache = new WeakHashMap();
    protected final DelayedRunnable transferableCacheCleanup = new DelayedRunnable(10000L){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delayedrun() {
            WeakHashMap<Transferable, Map<Object, Object>> weakHashMap = PackageControllerTableTransferHandler.this.transferableCache;
            synchronized (weakHashMap) {
                PackageControllerTableTransferHandler.this.transferableCache.size();
            }
        }
    };

    public PackageControllerTableTransferHandler(PackageControllerTable<PackageType, ChildrenType> table) {
        this.table = table;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    public void setTransferableStringContent(String content) {
        this.transferableStringContent.set(content);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        SelectionInfo<PackageType, ChildrenType> selectionInfo = this.table.getSelectionInfo(true, true);
        String transferableStringContent = this.transferableStringContent.getAndSet(null);
        if (selectionInfo.getPackageViews().size() > 0) {
            PackageControllerTableTransferable<PackageType, ChildrenType> ret2 = new PackageControllerTableTransferable<PackageType, ChildrenType>(selectionInfo, this.table, transferableStringContent);
            return this.customizeTransferable(ret2);
        }
        return null;
    }

    protected Transferable customizeTransferable(PackageControllerTableTransferable<PackageType, ChildrenType> ret2) {
        return ret2;
    }

    protected boolean allowImport(SelectionInfo<PackageType, ChildrenType> selectionInfo) {
        return true;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        super.exportAsDrag(comp, e, 2);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        super.exportToClipboard(comp, clip, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean isDataFlavorSupported(TransferHandler.TransferSupport support, DataFlavor flavor) {
        Map<Object, Object> cache;
        block7: {
            boolean bl;
            try {
                WeakHashMap<Transferable, Map<Object, Object>> weakHashMap = this.transferableCache;
                // MONITORENTER : weakHashMap
                Transferable transferable = support.getTransferable();
                cache = this.transferableCache.get(transferable);
                if (cache == null) {
                    cache = new HashMap<Object, Object>();
                    this.transferableCache.put(transferable, cache);
                }
                if (!cache.containsKey(flavor)) break block7;
                bl = Boolean.TRUE.equals(cache.get(flavor));
                // MONITOREXIT : weakHashMap
            }
            catch (Throwable throwable) {
                this.transferableCacheCleanup.resetAndStart();
                throw throwable;
            }
            this.transferableCacheCleanup.resetAndStart();
            return bl;
        }
        boolean ret = support.isDataFlavorSupported(flavor);
        cache.put(flavor, ret);
        boolean bl = ret;
        // MONITOREXIT : weakHashMap
        this.transferableCacheCleanup.resetAndStart();
        return bl;
    }

    protected SelectionInfo<PackageType, ChildrenType> getSelectionInfo(TransferHandler.TransferSupport support) {
        if (!this.isDataFlavorSupported(support, PackageControllerTableTransferable.FLAVOR)) {
            return null;
        }
        try {
            SelectionInfo content = (SelectionInfo)support.getTransferable().getTransferData(PackageControllerTableTransferable.FLAVOR);
            if (content.getController() != this.table.getController()) {
                return null;
            }
            return content;
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
            return null;
        }
    }

    protected boolean canImportPackageControllerTransferable(TransferHandler.TransferSupport support) {
        boolean packagesAvailable;
        if (!this.table.isOriginalOrder() || this.table.getModel().isFilteredView()) {
            return false;
        }
        SelectionInfo<PackageType, ChildrenType> selectionInfo = this.getSelectionInfo(support);
        if (selectionInfo == null || selectionInfo.isEmpty()) {
            return false;
        }
        if (!this.allowImport(selectionInfo)) {
            return false;
        }
        Object onElement = null;
        List<ChildrenType> links = this.getSelectedChildren(selectionInfo);
        List<PackageType> packages = this.getSelectedPackages(selectionInfo);
        boolean linksAvailable = links != null && links.size() > 0;
        boolean bl = packagesAvailable = packages != null && packages.size() > 0;
        if (support.isDrop()) {
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            boolean isInsert = dl.isInsertRow();
            int dropRow = dl.getRow();
            if (isInsert) {
                Object beforeElement = this.table.getModel().getObjectbyRow(dropRow - 1);
                Object afterElement = this.table.getModel().getObjectbyRow(dropRow);
                if (beforeElement == null && afterElement == null) {
                    return true;
                }
                if (linksAvailable && packagesAvailable) {
                    return false;
                }
                if (linksAvailable || packagesAvailable) {
                    AbstractPackageNode fp = null;
                    if (beforeElement != null) {
                        if (beforeElement instanceof AbstractPackageChildrenNode) {
                            fp = (AbstractPackageNode)((AbstractPackageChildrenNode)beforeElement).getParentNode();
                        } else if (afterElement != null && afterElement instanceof AbstractPackageChildrenNode) {
                            fp = (AbstractPackageNode)((AbstractPackageChildrenNode)afterElement).getParentNode();
                        }
                    }
                    if (fp == null && !packagesAvailable) {
                        return false;
                    }
                    if (packagesAvailable) {
                        if (afterElement != null && !(afterElement instanceof AbstractPackageNode)) {
                            return false;
                        }
                        fp = null;
                        for (AbstractPackageNode p : packages) {
                            if (p != fp) continue;
                            return false;
                        }
                    }
                }
            } else {
                onElement = this.table.getModel().getObjectbyRow(dropRow);
            }
        } else {
            List firstSelected = this.table.getModel().getSelectedObjects(1);
            if (firstSelected.size() > 0) {
                onElement = firstSelected.get(0);
            }
        }
        if (onElement != null) {
            if (packagesAvailable) {
                if (onElement instanceof AbstractPackageNode) {
                    for (AbstractPackageNode p : packages) {
                        if (p != onElement) continue;
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (linksAvailable) {
                if (onElement instanceof AbstractPackageChildrenNode) {
                    return false;
                }
                if (onElement instanceof AbstractPackageNode) {
                    for (AbstractPackageChildrenNode link : links) {
                        if (link.getParentNode() != onElement) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected abstract boolean importTransferable(TransferHandler.TransferSupport var1);

    protected abstract boolean canImportTransferable(TransferHandler.TransferSupport var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean ret = this.canImportPackageControllerTransferable(support);
        if (ret) return ret;
        if (this.isDataFlavorSupported(support, PackageControllerTableTransferable.FLAVOR)) return ret;
        try {
            Map<Object, Object> cache;
            Transferable transferable;
            WeakHashMap<Transferable, Map<Object, Object>> weakHashMap = this.transferableCache;
            synchronized (weakHashMap) {
                transferable = support.getTransferable();
                cache = this.transferableCache.get(transferable);
                if (cache != null && cache.containsKey(this)) {
                    boolean bl = Boolean.TRUE.equals(cache.get(this));
                    return bl;
                }
            }
            ret = this.canImportTransferable(support);
            weakHashMap = this.transferableCache;
            synchronized (weakHashMap) {
                transferable = support.getTransferable();
                cache = this.transferableCache.get(transferable);
                if (cache == null) {
                    cache = new HashMap<Object, Object>();
                    this.transferableCache.put(transferable, cache);
                }
                cache.put(this, ret);
                return ret;
            }
        }
        finally {
            this.transferableCacheCleanup.resetAndStart();
        }
    }

    private List<ChildrenType> getSelectedChildren(SelectionInfo<PackageType, ChildrenType> selectionInfo) {
        ArrayList<ChildrenType> ret = new ArrayList<ChildrenType>();
        for (SelectionInfo.PackageView<PackageType, ChildrenType> packageView : selectionInfo.getPackageViews()) {
            if (!packageView.isExpanded()) continue;
            ret.addAll(packageView.getSelectedChildren());
        }
        return ret;
    }

    private List<PackageType> getSelectedPackages(SelectionInfo<PackageType, ChildrenType> selectionInfo) {
        List<SelectionInfo.PackageView<PackageType, ChildrenType>> packageViews = selectionInfo.getPackageViews();
        ArrayList<PackageType> ret = new ArrayList<PackageType>(packageViews.size());
        for (SelectionInfo.PackageView<PackageType, ChildrenType> packageView : packageViews) {
            if (!packageView.isPackageSelected()) continue;
            ret.add(packageView.getPackage());
        }
        return ret;
    }

    protected boolean importPackageControllerTransferable(TransferHandler.TransferSupport support) {
        if (!this.canImportPackageControllerTransferable(support)) {
            return false;
        }
        Queue.QueuePriority prio = Queue.QueuePriority.HIGH;
        SelectionInfo<PackageType, ChildrenType> selectionInfo = this.getSelectionInfo(support);
        List<ChildrenType> tmpLinks = null;
        List<PackageType> tmpPackages = null;
        if (selectionInfo != null) {
            tmpLinks = this.getSelectedChildren(selectionInfo);
            tmpPackages = this.getSelectedPackages(selectionInfo);
            if (tmpLinks != null && tmpLinks.size() == 0) {
                tmpLinks = null;
            }
            if (tmpPackages != null && tmpPackages.size() == 0) {
                tmpPackages = null;
            }
        }
        if (tmpLinks == null && tmpPackages == null) {
            return false;
        }
        final List<ChildrenType> links = tmpLinks;
        final List<PackageType> packages = tmpPackages;
        boolean isInsert = false;
        Object afterElement = null;
        Object beforeElement = null;
        if (support.isDrop()) {
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            isInsert = dl.isInsertRow();
            int dropRow = dl.getRow();
            afterElement = this.table.getModel().getObjectbyRow(dropRow);
            if (isInsert) {
                beforeElement = this.table.getModel().getObjectbyRow(dropRow - 1);
            }
        } else {
            List firstSelected = this.table.getModel().getSelectedObjects(1);
            if (firstSelected.size() > 0 && (afterElement = (Object)firstSelected.get(0)) instanceof AbstractPackageChildrenNode) {
                afterElement = ((AbstractPackageChildrenNode)afterElement).getParentNode();
            }
        }
        if (!isInsert || !support.isDrop()) {
            if (afterElement != null && afterElement instanceof AbstractPackageNode) {
                final Object element = afterElement;
                this.table.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(prio){

                    protected Void run() throws RuntimeException {
                        PackageController.MergePackageSettings mergesettings = new PackageController.MergePackageSettings();
                        if (((AbstractPackageNode)element).getCurrentSorter() == null) {
                            if (CFG_LINKCOLLECTOR.DO_MERGE_TOP_BOTTOM.isEnabled()) {
                                mergesettings.setMergePosition(MergePosition.BOTTOM);
                            } else {
                                mergesettings.setMergePosition(MergePosition.TOP);
                            }
                        } else {
                            mergesettings.setMergePosition(MergePosition.SORTED);
                        }
                        PackageControllerTableTransferHandler.this.table.getController().merge((AbstractPackageNode)element, links, packages, mergesettings);
                        return null;
                    }
                });
            } else {
                LoggerFactory.getDefaultLogger().log((Throwable)new WTFException("this should not happen!"));
            }
        } else if (packages != null) {
            final AbstractPackageNode dest = beforeElement == null ? null : (beforeElement instanceof AbstractPackageNode ? (AbstractPackageNode)beforeElement : (beforeElement instanceof AbstractPackageChildrenNode ? (AbstractPackageNode)((AbstractPackageChildrenNode)beforeElement).getParentNode() : null));
            this.table.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(prio){

                protected Void run() throws RuntimeException {
                    PackageControllerTableTransferHandler.this.table.getController().move(packages, dest);
                    return null;
                }
            });
        } else if (links != null) {
            AbstractPackageNode destP;
            AbstractPackageChildrenNode afterL;
            if (beforeElement != null) {
                if (beforeElement instanceof AbstractPackageChildrenNode) {
                    afterL = (AbstractPackageChildrenNode)beforeElement;
                    destP = (AbstractPackageNode)afterL.getParentNode();
                } else if (beforeElement instanceof AbstractPackageNode) {
                    afterL = null;
                    destP = (AbstractPackageNode)beforeElement;
                } else {
                    afterL = null;
                    destP = null;
                }
            } else {
                afterL = null;
                destP = null;
            }
            this.table.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(prio){

                protected Void run() throws RuntimeException {
                    PackageControllerTableTransferHandler.this.table.getController().move(links, destP, afterL);
                    return null;
                }
            });
        }
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean ret = this.importPackageControllerTransferable(support);
        if (!ret && !support.isDataFlavorSupported(PackageControllerTableTransferable.FLAVOR)) {
            ret = this.importTransferable(support);
        }
        return ret;
    }
}

