/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.MainTabbedPane;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.translate._JDT;

public class CollapseExpandContextAction
extends CustomizableTableContextAppAction
implements ActionContext {
    private boolean selectionOnly = false;

    public CollapseExpandContextAction() {
        super(true, true);
        this.setIconKey("list");
        this.setTooltipText(_GUI.T.CollapseExpandAllAction_CollapseExpandAllAction());
        this.updateLabelAndIcon();
    }

    private void updateLabelAndIcon() {
        if (this.isSelectionOnly()) {
            this.setName(_GUI.T.CollapseExpandAllAction_CollapseExpandAllAction_selectiononly());
        } else {
            this.setName(_GUI.T.CollapseExpandAllAction_CollapseExpandAllAction_());
        }
    }

    @Override
    public void initContextDefaults() {
        super.initContextDefaults();
        this.setSelectionOnly(false);
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.updateLabelAndIcon();
    }

    public static String getTranslationForSelectionOnly() {
        return _JDT.T.CollapseExpandContextAction_getTranslationForSelectionOnly();
    }

    @Customizer(link="#getTranslationForSelectionOnly")
    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public void setSelectionOnly(boolean selectionOnly) {
        this.selectionOnly = selectionOnly;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final PackageControllerTable<?, ?> table = this.getTable();
        if (table != null) {
            table.getSelectionInfo(new PackageControllerTable.EDTSelectionInfoCallback(){

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public void onSelectionInfo(SelectionInfo selectionInfo) {
                    boolean allexpaned = true;
                    ArrayList list = new ArrayList();
                    for (SelectionInfo.PackageView p : selectionInfo.getPackageViews()) {
                        SelectionInfo.PackageView pv = p;
                        if (!pv.isExpanded()) {
                            allexpaned = false;
                        }
                        list.add(pv.getPackage());
                    }
                    table.getModel().setFilePackageExpand(!allexpaned, list.toArray(new AbstractPackageNode[0]));
                }
            }, this.isSelectionOnly() ? PackageControllerTable.SelectionType.SELECTED : PackageControllerTable.SelectionType.ALL);
        }
    }

    private PackageControllerTable<?, ?> getTable() {
        if (MainTabbedPane.getInstance().isDownloadView()) {
            return DownloadsTable.getInstance();
        }
        if (MainTabbedPane.getInstance().isLinkgrabberView()) {
            return LinkGrabberTable.getInstance();
        }
        return null;
    }
}

