/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.io.File;
import jd.controlling.TaskQueue;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.HashInfo;
import jd.plugins.download.HashResult;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;

public class RunCheckSumAction
extends CustomizableTableContextAppAction<FilePackage, DownloadLink> {
    private static final long serialVersionUID = 1L;

    public RunCheckSumAction() {
        this.setIconKey("hashsum");
        this.setName(_GUI.T.gui_table_contextmenu_runchecksum());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (final DownloadLink downloadLink : this.getSelection().getChildren()) {
            final DownloadLinkDownloadable downloadable = new DownloadLinkDownloadable(downloadLink){
                private LogInterface logger;
                {
                    this.logger = null;
                }

                @Override
                public LogInterface getLogger() {
                    if (this.logger == null) {
                        this.logger = LogController.CL();
                    }
                    return this.logger;
                }
            };
            if (!downloadable.isHashCheckEnabled()) continue;
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    HashInfo hashInfo;
                    HashResult result;
                    File file = new File(downloadable.getFileOutput());
                    if (file.exists() && (result = downloadable.getHashResult(hashInfo = downloadable.getHashInfo(), file)) != null) {
                        if (result.match()) {
                            long fileSize = file.length();
                            downloadLink.setVerifiedFileSize(fileSize);
                            downloadLink.setDownloadCurrent(fileSize);
                        }
                        downloadLink.setFinalLinkState(result.getFinalLinkState());
                    }
                    return null;
                }
            });
        }
    }
}

