/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.LocationInList;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.gui.views.linkgrabber.contextmenu.NewPackageDialog;
import org.jdownloader.translate._JDT;

public class SplitPackagesByHost
extends CustomizableTableContextAppAction<FilePackage, DownloadLink>
implements ActionContext {
    private static final long serialVersionUID = 2636706677433058054L;
    private boolean mergePackages = false;
    private static final String NAME = _GUI.T.SplitPackagesByHost_SplitPackagesByHost_object_();
    private boolean askForNewDownloadFolderAndPackageName = true;
    private LocationInList location = LocationInList.AFTER_SELECTION;

    public SplitPackagesByHost() {
        this.setName(NAME);
        this.setIconKey("split_packages");
    }

    public static String getTranslationForMergePackages() {
        return _JDT.T.SplitPackagesByHost_getTranslationForMergePackages();
    }

    @Customizer(link="#getTranslationForMergePackages")
    public boolean isMergePackages() {
        return this.mergePackages;
    }

    public void setMergePackages(boolean mergePackages) {
        this.mergePackages = mergePackages;
    }

    public static String getTranslationForAskForNewDownloadFolderAndPackageName() {
        return _JDT.T.SplitPackagesByHost_getTranslationForAskForNewDownloadFolderAndPackageName();
    }

    @Customizer(link="#getTranslationForAskForNewDownloadFolderAndPackageName")
    public boolean isAskForNewDownloadFolderAndPackageName() {
        return this.askForNewDownloadFolderAndPackageName;
    }

    public void setAskForNewDownloadFolderAndPackageName(boolean askForNewDownloadFolderIfMerging) {
        this.askForNewDownloadFolderAndPackageName = askForNewDownloadFolderIfMerging;
    }

    public static String getTranslationForLocation() {
        return _JDT.T.SplitPackagesByHost_getTranslationForLocation();
    }

    @Customizer(link="#getTranslationForLocation")
    public LocationInList getLocation() {
        return this.location;
    }

    public void setLocation(LocationInList location) {
        this.location = location;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newDownloadFolder;
        String newName;
        SelectionInfo finalSelection;
        block6: {
            finalSelection = this.getSelection();
            if (this.isMergePackages() && finalSelection.getPackageViews().size() > 1) {
                if (this.isAskForNewDownloadFolderAndPackageName()) {
                    try {
                        NewPackageDialog d = new NewPackageDialog(finalSelection){

                            public String getDontShowAgainKey() {
                                return "ABSTRACTDIALOG_DONT_SHOW_AGAIN_" + SplitPackagesByHost.this.getClass().getSimpleName();
                            }
                        };
                        Dialog.getInstance().showDialog((AbstractDialog)d);
                        newName = d.getName();
                        newDownloadFolder = d.getDownloadFolder();
                        if (StringUtils.isEmpty((String)newName)) {
                            return;
                        }
                        break block6;
                    }
                    catch (Throwable ignore) {
                        return;
                    }
                }
                newName = "";
                newDownloadFolder = ((FilePackage)finalSelection.getFirstPackage()).getDownloadDirectory();
            } else {
                newName = null;
                newDownloadFolder = null;
            }
        }
        DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                HashMap splitMap = new HashMap();
                int insertAt = -1;
                switch (SplitPackagesByHost.this.getLocation()) {
                    case BEFORE_SELECTION: {
                        insertAt = Integer.MAX_VALUE;
                    }
                }
                for (AbstractNode child : finalSelection.getChildren()) {
                    String host;
                    ArrayList<DownloadLink> hostList;
                    if (!(child instanceof DownloadLink)) continue;
                    DownloadLink cL = (DownloadLink)child;
                    FilePackage parent = SplitPackagesByHost.this.isMergePackages() ? null : cL.getParentNode();
                    HashMap<String, ArrayList<DownloadLink>> parentMap = (HashMap<String, ArrayList<DownloadLink>>)splitMap.get(parent);
                    if (parentMap == null) {
                        parentMap = new HashMap<String, ArrayList<DownloadLink>>();
                        splitMap.put(parent, parentMap);
                    }
                    if ((hostList = (ArrayList<DownloadLink>)parentMap.get(host = cL.getDomainInfo().getTld())) == null) {
                        hostList = new ArrayList<DownloadLink>();
                        parentMap.put(host, hostList);
                    }
                    hostList.add(cL);
                    switch (SplitPackagesByHost.this.getLocation()) {
                        case AFTER_SELECTION: {
                            insertAt = Math.max(insertAt, DownloadController.getInstance().indexOf(((DownloadLink)child).getParentNode()) + 1);
                            break;
                        }
                        case BEFORE_SELECTION: {
                            insertAt = Math.min(insertAt, DownloadController.getInstance().indexOf(((DownloadLink)child).getParentNode()));
                            break;
                        }
                        case END_OF_LIST: {
                            insertAt = -1;
                            break;
                        }
                        case TOP_OF_LIST: {
                            insertAt = 0;
                        }
                    }
                }
                if (insertAt == Integer.MAX_VALUE) {
                    insertAt = 0;
                }
                String nameFactory = ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).getSplitPackageNameFactoryPattern();
                boolean merge = ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).isSplitPackageMergeEnabled();
                HashMap<String, FilePackage> mergedPackages = new HashMap<String, FilePackage>();
                for (Map.Entry next : splitMap.entrySet()) {
                    FilePackage sourcePackage = (FilePackage)next.getKey();
                    HashMap items = (HashMap)next.getValue();
                    for (Map.Entry next2 : items.entrySet()) {
                        FilePackage newPkg;
                        String host = (String)next2.getKey();
                        String newPackageName = SplitPackagesByHost.this.getNewPackageName(nameFactory, sourcePackage == null ? newName : sourcePackage.getName(), host);
                        if (merge) {
                            FilePackage destPackage = (FilePackage)mergedPackages.get(newPackageName);
                            if (destPackage == null) {
                                destPackage = FilePackage.getInstance();
                                if (sourcePackage != null) {
                                    sourcePackage.copyPropertiesTo(destPackage);
                                } else {
                                    String downloadFolder = PackagizerController.replaceDynamicTags(newDownloadFolder, newPackageName, destPackage);
                                    destPackage.setDownloadDirectory(downloadFolder);
                                }
                                destPackage.setName(newPackageName);
                                mergedPackages.put(newPackageName, destPackage);
                            }
                            newPkg = destPackage;
                        } else {
                            newPkg = FilePackage.getInstance();
                            if (sourcePackage != null) {
                                sourcePackage.copyPropertiesTo(newPkg);
                            } else {
                                String downloadFolder = PackagizerController.replaceDynamicTags(newDownloadFolder, newPackageName, newPkg);
                                newPkg.setDownloadDirectory(downloadFolder);
                            }
                            newPkg.setName(newPackageName);
                        }
                        DownloadController.getInstance().moveOrAddAt(newPkg, (List<DownloadLink>)((List)next2.getValue()), 0, insertAt);
                        ++insertAt;
                    }
                }
                return null;
            }
        });
    }

    public String getNewPackageName(String nameFactory, String oldPackageName, String host) {
        if (StringUtils.isEmpty((String)nameFactory)) {
            if (!StringUtils.isEmpty((String)oldPackageName)) {
                return oldPackageName;
            }
            return host;
        }
        nameFactory = !StringUtils.isEmpty((String)oldPackageName) ? nameFactory.replaceAll("\\{PACKAGENAME\\}", oldPackageName) : nameFactory.replaceAll("\\{PACKAGENAME\\}", _JDT.T.LinkCollector_addCrawledLink_variouspackage());
        nameFactory = nameFactory.replaceAll("\\{HOSTNAME\\}", host);
        return nameFactory;
    }
}

