/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;

public class EnabledFileCountColumn
extends ExtColumn<AbstractNode> {
    private final RenderLabel countRenderer = new RenderLabel();
    private NumberFormat formatter;

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup(this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public EnabledFileCountColumn() {
        super(_GUI.T.EnabledFileCountColumn_EnabledFileCountColumn(), null);
        this.countRenderer.setHorizontalAlignment(2);
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                int s2;
                int s1 = EnabledFileCountColumn.this.getNumberOfItems(o1);
                if (s1 == (s2 = EnabledFileCountColumn.this.getNumberOfItems(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return s1 > s2 ? -1 : 1;
                }
                return s1 < s2 ? -1 : 1;
            }
        });
        this.formatter = this.updateNumberFormat();
    }

    protected NumberFormat updateNumberFormat() {
        this.formatter = super.updateNumberFormat();
        return this.formatter;
    }

    public void configureEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.countRenderer.setText(StringUtils.toString((NumberFormat)this.formatter, (long)this.getNumberOfItems(value)));
    }

    public Object getCellEditorValue() {
        return null;
    }

    public JComponent getEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
        return null;
    }

    public JComponent getRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.countRenderer;
    }

    protected String getTooltipText(AbstractNode value) {
        return StringUtils.toString((NumberFormat)this.formatter, (long)this.getNumberOfItems(value));
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    public void resetEditor() {
    }

    public void resetRenderer() {
        this.countRenderer.setEnabled(true);
        this.countRenderer.setOpaque(false);
        this.countRenderer.setBorder(ExtColumn.DEFAULT_BORDER);
    }

    public void setValue(Object value, AbstractNode object) {
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public int getDefaultWidth() {
        return 70;
    }

    public int getMinWidth() {
        return this.getDefaultWidth();
    }

    protected int getNumberOfItems(AbstractNode o) {
        if (o instanceof AbstractPackageNode) {
            return ((AbstractPackageNode)o).getView().getEnabledCount();
        }
        if (o.isEnabled()) {
            return 1;
        }
        return 0;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }
}

