/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.util.Locale;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.translate._GUI;

public class IndexColumn
extends ExtTextColumn<AbstractNode> {
    private final PackageController controller;
    private final Locale locale;

    public IndexColumn(PackageController controller) {
        super(_GUI.T.IndexColumn_IndexColumn());
        this.controller = controller;
        this.locale = Locale.getDefault();
    }

    public boolean isDefaultVisible() {
        return false;
    }

    protected boolean isEditable(AbstractNode obj, boolean enabled) {
        return false;
    }

    public int getMaxWidth() {
        return 100;
    }

    public int getMinWidth() {
        return 12;
    }

    public int getDefaultWidth() {
        return 22;
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        return true;
    }

    public boolean isSortable(AbstractNode obj) {
        return false;
    }

    public String getStringValue(AbstractNode value) {
        int childIndex;
        if (value instanceof AbstractPackageNode) {
            int index = this.controller.indexOf((AbstractPackageNode)value);
            if (index == -1) {
                return "?";
            }
            return StringUtils.formatByPadLength((Locale)this.locale, (int)StringUtils.getPadLength((int)Math.max(index + 1, this.controller.size())), (int)(index + 1));
        }
        AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)value;
        AbstractPackageNode parent = (AbstractPackageNode)child.getParentNode();
        int pkgIndex = parent == null ? -1 : this.controller.indexOf(parent);
        int n = childIndex = parent == null ? -1 : parent.indexOf(child);
        if (pkgIndex != -1 && childIndex != -1) {
            return StringUtils.formatByPadLength((Locale)this.locale, (int)StringUtils.getPadLength((int)Math.max(pkgIndex + 1, this.controller.size())), (int)(pkgIndex + 1)) + "-" + StringUtils.formatByPadLength((Locale)this.locale, (int)StringUtils.getPadLength((int)Math.max(childIndex + 1, parent.size())), (int)(childIndex + 1));
        }
        if (childIndex != -1) {
            return "?-" + StringUtils.formatByPadLength((Locale)this.locale, (int)StringUtils.getPadLength((int)Math.max(childIndex + 1, this.controller.size())), (int)(childIndex + 1));
        }
        return "?";
    }
}

