/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class SizeColumn
extends ExtColumn<AbstractNode> {
    private final RenderLabel sizeRenderer = new RenderLabel();
    private NumberFormat formatter;
    private final RenderLabel countRenderer;
    private final RendererMigPanel renderer;
    private final boolean fileCountVisible;
    private final String zeroString;
    private final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit;

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup(this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public SizeColumn() {
        super(_GUI.T.SizeColumn_SizeColumn(), null);
        this.sizeRenderer.setHorizontalAlignment(4);
        this.countRenderer = new RenderLabel();
        this.zeroString = _GUI.T.SizeColumn_getSizeString_zero();
        this.countRenderer.setHorizontalAlignment(2);
        this.fileCountVisible = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isFileCountInSizeColumnVisible();
        this.maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
        this.renderer = new RendererMigPanel("ins 0", "[]0[grow,fill]", "[grow,fill]");
        if (this.fileCountVisible) {
            this.renderer.add((Component)this.countRenderer);
            this.renderer.add((Component)this.sizeRenderer);
        } else {
            this.renderer.add((Component)this.sizeRenderer, (Object)"spanx,pushx,growx");
        }
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                long s2;
                long s1 = SizeColumn.this.getBytes(o1);
                if (s1 == (s2 = SizeColumn.this.getBytes(o2))) {
                    return this.compare2(o1, o2);
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return s1 > s2 ? -1 : 1;
                }
                return s1 < s2 ? -1 : 1;
            }

            public int compare2(AbstractNode o1, AbstractNode o2) {
                int s2;
                int s1 = SizeColumn.this.getNumberOfItems(o1);
                if (s1 == (s2 = SizeColumn.this.getNumberOfItems(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return s1 > s2 ? -1 : 1;
                }
                return s1 < s2 ? -1 : 1;
            }
        });
        this.formatter = this.updateNumberFormat();
    }

    protected NumberFormat updateNumberFormat() {
        this.formatter = super.updateNumberFormat();
        return this.formatter;
    }

    public void configureEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.sizeRenderer.setText(this.getSizeString(this.getBytes(value)));
        if (this.fileCountVisible) {
            if (value instanceof AbstractPackageNode) {
                this.countRenderer.setText("[" + StringUtils.toString((NumberFormat)this.formatter, (long)((AbstractPackageNode)value).getView().size()) + "]");
            } else {
                this.countRenderer.setText("");
            }
        }
    }

    public Object getCellEditorValue() {
        return null;
    }

    public JComponent getEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
        return null;
    }

    public JComponent getRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.fileCountVisible) {
            return this.renderer;
        }
        return this.sizeRenderer;
    }

    private final String getSizeString(long fileSize) {
        if (fileSize < 0L) {
            return this.zeroString;
        }
        return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(this.maxSizeUnit, this.formatter, fileSize);
    }

    protected String getTooltipText(AbstractNode value) {
        long sizeValue = this.getBytes(value);
        if (sizeValue < 0L) {
            return _GUI.T.SizeColumn_getSizeString_zero_tt();
        }
        return this.getSizeString(sizeValue);
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    public void resetEditor() {
    }

    public void resetRenderer() {
        if (this.fileCountVisible) {
            this.renderer.setEnabled(true);
            this.renderer.setOpaque(false);
            this.sizeRenderer.setOpaque(false);
            this.sizeRenderer.setBorder(ExtColumn.DEFAULT_BORDER);
        } else {
            this.sizeRenderer.setEnabled(true);
            this.sizeRenderer.setOpaque(false);
            this.sizeRenderer.setBorder(ExtColumn.DEFAULT_BORDER);
        }
    }

    public void setValue(Object value, AbstractNode object) {
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public int getDefaultWidth() {
        return this.fileCountVisible ? 90 : 70;
    }

    public int getMinWidth() {
        return this.getDefaultWidth();
    }

    protected long getBytes(AbstractNode o2) {
        if (o2 instanceof CrawledPackage) {
            return ((CrawledPackage)o2).getView().getFileSize();
        }
        if (o2 instanceof CrawledLink) {
            return ((CrawledLink)o2).getSize();
        }
        if (o2 instanceof DownloadLink) {
            return ((DownloadLink)o2).getView().getBytesTotal();
        }
        if (o2 instanceof FilePackage) {
            return ((FilePackage)o2).getView().getSize();
        }
        return -1L;
    }

    protected int getNumberOfItems(AbstractNode o) {
        if (o instanceof AbstractPackageNode) {
            return ((AbstractPackageNode)o).getView().size();
        }
        return 1;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }
}

