/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns.candidatetooltip;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import org.appwork.swing.components.tooltips.PanelToolTip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.jdownloader.gui.views.downloads.columns.candidatetooltip.CandidateTooltipTable;
import org.jdownloader.gui.views.downloads.columns.candidatetooltip.CandidateTooltipTableModel;
import org.jdownloader.updatev2.gui.LAFOptions;

public class CandidateTooltip
extends PanelToolTip {
    private Color color;
    private CandidateTooltipTable table;
    private CandidateTooltipTableModel model;
    private Point position;

    public static CandidateTooltip create(Point position, AbstractNode obj) {
        List<HistoryEntry> his;
        if (obj instanceof DownloadLink && (his = ((DownloadLink)obj).getHistory()) != null) {
            return new CandidateTooltip(position, (DownloadLink)obj, his);
        }
        return null;
    }

    public Point getDesiredLocation(JComponent activeComponent, Point ttPosition) {
        Point mouseLocation = ToolTipController.getMouseLocation();
        if (mouseLocation != null) {
            return mouseLocation;
        }
        return ttPosition;
    }

    public void onShow() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                CandidateTooltip.this.invalidate();
            }
        });
    }

    public CandidateTooltip(Point position, DownloadLink obj, List<HistoryEntry> history) {
        super(new TooltipPanel("ins 0,wrap 1", "[]", "[grow,fill]"){

            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                System.out.println(pref);
                return pref;
            }
        });
        this.position = position;
        this.color = LAFOptions.getInstance().getColorForTooltipForeground();
        LinkedList domains = new LinkedList();
        this.model = new CandidateTooltipTableModel(history);
        this.table = new CandidateTooltipTable(this, this.model);
        this.update();
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CandidateTooltip.this.table.getTableHeader().repaint();
            }
        });
        this.table.getTableHeader().setOpaque(false);
        this.panel.add((Component)this.table.getTableHeader());
        this.panel.add((Component)((Object)this.table));
    }

    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        return ret;
    }

    public void update() {
        this.table.getModel().fireTableStructureChanged();
        this.panel.repaint();
    }
}

