/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns.candidatetooltip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.gui.swing.jdgui.BasicJDTable;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.jdownloader.gui.views.downloads.columns.candidatetooltip.CandidateTooltip;
import org.jdownloader.gui.views.downloads.columns.candidatetooltip.CandidateTooltipTableModel;
import org.jdownloader.updatev2.gui.LAFOptions;

public class CandidateTooltipTable
extends BasicJDTable<HistoryEntry> {
    private static final long serialVersionUID = -2166408567306279016L;
    private boolean repaintBecauseOfSizeChanged = false;
    private int preferredWidth;
    private CandidateTooltip owner;

    public void setRepaintBecauseOfSizeChanged(boolean repaintBecauseOfSizeChanged) {
        this.repaintBecauseOfSizeChanged = repaintBecauseOfSizeChanged;
    }

    public CandidateTooltipTable(CandidateTooltip candidateTooltip, CandidateTooltipTableModel accountListTableModel) {
        super((ExtTableModel)accountListTableModel);
        Color color = UIManager.getColor("Appwork.Tooltip.Foreground");
        if (color != null) {
            this.setForeground(color);
        }
        this.owner = candidateTooltip;
        ToolTipController.getInstance().unregister((ToolTipHandler)this);
        this.setBackground(null);
        this.setOpaque(false);
        this.setAutoResizeMode(0);
        this.resetColumnDimensions();
    }

    public void paintComponent(Graphics g) {
        boolean init = false;
        for (ExtColumn col : this.getModel().getColumns()) {
            int pref;
            if (!(col instanceof CandidateTooltipTableModel.MaxWidthProvider) || (pref = ((CandidateTooltipTableModel.MaxWidthProvider)col).getMaxPreferredWitdh()) <= 0) continue;
            init = true;
            if (col.getMinWidth() > 0) {
                pref = Math.max(col.getMinWidth(), pref);
            }
            if (col.getMaxWidth() > 0) {
                pref = Math.min(col.getMaxWidth(), pref);
            }
            col.getTableColumn().setPreferredWidth(pref);
            col.getTableColumn().setMaxWidth(pref);
            col.getTableColumn().setMinWidth(pref);
        }
        super.paintComponent(g);
        if (!init) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolTipController.getInstance().show((ExtTooltip)CandidateTooltipTable.this.owner);
                }
            });
        }
    }

    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        int prefWidth = 0;
        for (ExtColumn col : this.getModel().getColumns()) {
            int pref;
            if (!(col instanceof CandidateTooltipTableModel.MaxWidthProvider) || (pref = ((CandidateTooltipTableModel.MaxWidthProvider)col).getMaxPreferredWitdh()) <= 0) continue;
            prefWidth += pref + 14;
        }
        if (prefWidth != ret.width) {
            ret.width = prefWidth;
        }
        return ret;
    }

    protected void initAlternateRowHighlighter() {
    }

    protected ExtTableHeaderRenderer createDefaultHeaderRenderer(ExtColumn<HistoryEntry> column) {
        ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer(column, this.getTableHeader());
        CandidateTooltipTable.setHeaderRendererColors(ret);
        return ret;
    }

    protected void addSelectionHighlighter() {
    }

    public static void setHeaderRendererColors(ExtTableHeaderRenderer ret) {
        ret.setFocusBackground(new Color(255, 255, 255, 80));
        ret.setBackgroundC(new Color(255, 255, 255, 80));
        ret.setFocusForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        ret.setForegroundC(LAFOptions.getInstance().getColorForTooltipForeground());
    }

    protected void initMouseOverRowHighlighter() {
        Color f = LAFOptions.getInstance().getColorForTableMouseOverRowForeground();
        Color b = LAFOptions.getInstance().getColorForTableMouseOverRowBackground();
        f = Color.black;
        this.getModel().addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<HistoryEntry>(f, b, null){

            public int getPriority() {
                return 0x7FFFFFFE;
            }

            protected Color getBackground(Color current) {
                return super.getBackground(current);
            }

            public boolean accept(ExtColumn<HistoryEntry> column, HistoryEntry value, boolean selected, boolean focus, int row) {
                return CandidateTooltipTable.this.mouseOverRow == row;
            }
        });
    }

    protected boolean onShortcutDelete(List<HistoryEntry> selectedObjects, KeyEvent evt, boolean direct) {
        return false;
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, HistoryEntry contextObject, List<HistoryEntry> selection, ExtColumn<HistoryEntry> column, MouseEvent ev) {
        return null;
    }
}

