/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.overviewpanel;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public abstract class DataEntry<T> {
    private JLabel total;
    private JLabel filtered;
    private JLabel selected;
    private final String label;
    protected String id = this.id.substring(this.id.lastIndexOf(".") + 1);
    protected final NumberFormat numberFormat;

    public JLabel getTotal() {
        return this.total;
    }

    public JLabel getFiltered() {
        return this.filtered;
    }

    public JLabel getSelected() {
        return this.selected;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public DataEntry(String label) {
        this.label = label;
        this.total = new JLabel("-1");
        this.filtered = new JLabel("-1");
        this.selected = new JLabel("-1");
        this.total.setToolTipText(_GUI.T.DownloadOverview_DownloadOverview_tooltip1());
        this.filtered.setToolTipText(_GUI.T.DownloadOverview_DownloadOverview_tooltip2());
        this.selected.setToolTipText(_GUI.T.DownloadOverview_DownloadOverview_tooltip3());
        this.updateVisibility(false);
        this.numberFormat = this.getNumberFormat();
    }

    protected NumberFormat getNumberFormat() {
        return NumberFormat.getInstance();
    }

    public String getPopupLabel() {
        return this.getLabel().replace(":", "");
    }

    private JComponent createHeaderLabel(String label) {
        JLabel lbl = new JLabel(label);
        SwingUtils.toBold((JLabel)lbl);
        lbl.setEnabled(false);
        return lbl;
    }

    public void addTo(MigPanel info) {
        this.addTo(info, null);
    }

    public void addTo(MigPanel info, String constrains) {
        info.add((Component)this.createHeaderLabel(this.label), (Object)("alignx right" + (constrains == null ? "" : constrains)));
        info.add((Component)this.total, (Object)"hidemode 3");
        info.add((Component)this.filtered, (Object)"hidemode 3");
        info.add((Component)this.selected, (Object)"hidemode 3");
    }

    public void setTotal(Object value) {
        this.total.setText(this.toString(value));
    }

    private String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return StringUtils.toString((NumberFormat)this.numberFormat, (long)((Number)value).longValue());
        }
        return value.toString();
    }

    public void setSelected(Object value) {
        this.selected.setText(this.toString(value));
    }

    public void setFiltered(Object value) {
        this.filtered.setText(this.toString(value));
    }

    public void updateVisibility(boolean hasSelectedObjects) {
        boolean smart = CFG_GUI.OVERVIEW_PANEL_SMART_INFO_VISIBLE.isEnabled();
        boolean visibleOnly = CFG_GUI.OVERVIEW_PANEL_VISIBLE_ONLY_INFO_VISIBLE.isEnabled();
        boolean selectedOnly = CFG_GUI.OVERVIEW_PANEL_SELECTED_INFO_VISIBLE.isEnabled();
        boolean totalVisible = CFG_GUI.OVERVIEW_PANEL_TOTAL_INFO_VISIBLE.isEnabled();
        if (smart || !visibleOnly && !totalVisible && !selectedOnly) {
            if (hasSelectedObjects) {
                this.filtered.setVisible(false);
                this.total.setVisible(false);
                this.selected.setVisible(true);
            } else {
                this.filtered.setVisible(true);
                this.total.setVisible(false);
                this.selected.setVisible(false);
            }
        } else {
            this.filtered.setVisible(visibleOnly);
            this.total.setVisible(totalVisible);
            this.selected.setVisible(selectedOnly);
        }
    }

    public abstract void setData(T var1, T var2, T var3);

    public abstract BooleanKeyHandler getVisibleKeyHandler();
}

