/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.properties;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.VariableAction;
import jd.plugins.download.HashInfo;
import net.miginfocom.swing.MigLayout;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.pathchooser.PathChooser;
import org.appwork.swing.components.searchcombo.SearchComboBox;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.packagehistorycontroller.PackageHistoryEntry;
import org.jdownloader.gui.packagehistorycontroller.PackageHistoryManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.DownloadFolderChooserDialog;
import org.jdownloader.gui.views.components.PseudoCombo;
import org.jdownloader.gui.views.downloads.properties.AbstractNodeProperties;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class AbstractNodePropertiesPanel<E extends AbstractNodeProperties>
extends MigPanel
implements ActionListener,
GenericConfigEventListener<Boolean> {
    protected final PseudoCombo<BooleanStatus> autoExtract;
    protected final ExtTextField checksum;
    protected final ExtTextArea comment;
    protected final LinkgrabberSettings config;
    protected final PathChooser destination;
    protected final ExtTextField downloadFrom;
    protected final ExtTextField downloadpassword;
    protected final ExtTextField filename;
    protected final SearchComboBox<PackageHistoryEntry> packagename;
    protected final ExtTextField password;
    protected final PseudoCombo<Priority> priority;
    private final DelayedRunnable saveDelayer;
    protected final AtomicInteger savingLock = new AtomicInteger(0);
    protected final AtomicInteger settingLock = new AtomicInteger(0);
    private final DelayedRunnable updateDelayer;
    private static final ScheduledExecutorService SERVICE = DelayedRunnable.getNewScheduledExecutorService();
    protected volatile E abstractNodeProperties = null;
    private final AtomicLong refreshRequested = new AtomicLong(0L);
    private final AtomicLong refreshDone = new AtomicLong(0L);

    protected E getAbstractNodeProperties() {
        return this.abstractNodeProperties;
    }

    public void removeAbstractNodeProperties() {
        new EDTRunner(){

            protected void runInEDT() {
                Object current = AbstractNodePropertiesPanel.this.abstractNodeProperties;
                if (current != null) {
                    AbstractNodePropertiesPanel.this.onHidden();
                }
            }
        };
    }

    protected void setAbstractNodeProperties(E abstractNodeProperties) {
        new EDTRunner((AbstractNodeProperties)abstractNodeProperties){
            final /* synthetic */ AbstractNodeProperties val$abstractNodeProperties;
            {
                this.val$abstractNodeProperties = abstractNodeProperties;
            }

            protected void runInEDT() {
                AbstractNodePropertiesPanel.this.save();
                Object before = AbstractNodePropertiesPanel.this.abstractNodeProperties;
                AbstractNodePropertiesPanel.this.abstractNodeProperties = this.val$abstractNodeProperties;
                if (before != null && this.val$abstractNodeProperties == null) {
                    AbstractNodePropertiesPanel.this.onHidden();
                } else if (before == null && this.val$abstractNodeProperties != null) {
                    AbstractNodePropertiesPanel.this.onShowing();
                } else if (this.val$abstractNodeProperties != null) {
                    AbstractNodePropertiesPanel.this.loadInEDT(true, this.val$abstractNodeProperties);
                }
            }
        };
    }

    public AbstractNodePropertiesPanel() {
        super("ins 0", "[grow,fill]", "[grow,fill]");
        LAFOptions.getInstance().applyPanelBackground((JComponent)((Object)this));
        this.config = (LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class);
        this.saveDelayer = new DelayedRunnable(SERVICE, 500L, 2000L){

            public void delayedrun() {
                new EDTRunner(){

                    protected void runInEDT() {
                        AbstractNodePropertiesPanel.this.save();
                    }
                };
            }

            public String getID() {
                return "PropertiesSaver";
            }
        };
        this.updateDelayer = new DelayedRunnable(SERVICE, 100L, 2000L){

            public void delayedrun() {
                AbstractNodePropertiesPanel.this.refresh(false);
            }

            public String getID() {
                return "updateDelayer";
            }
        };
        this.destination = new PathChooser("ADDLinks", true){

            public File doFileChooser() {
                try {
                    return DownloadFolderChooserDialog.open(this.getFile(), true, this.getDialogTitle());
                }
                catch (DialogClosedException e) {
                    e.printStackTrace();
                }
                catch (DialogCanceledException e) {
                    e.printStackTrace();
                }
                return null;
            }

            protected String getHelpText() {
                return _GUI.T.AddLinksDialog_layoutDialogContent_help_destination();
            }

            public JPopupMenu getPopupMenu(ExtTextField txt, AbstractAction cutAction, AbstractAction copyAction, AbstractAction pasteAction, AbstractAction deleteAction, AbstractAction selectAction) {
                JPopupMenu menu = new JPopupMenu();
                menu.add((Action)new VariableAction((JTextComponent)txt, _GUI.T.PackagizerFilterRuleDialog_createVariablesMenu_date(), "<jd:simpledate:dd.MM.yyyy>"));
                menu.add((Action)new VariableAction((JTextComponent)txt, _GUI.T.PackagizerFilterRuleDialog_createVariablesMenu_packagename(), "<jd:packagename>"));
                return menu;
            }

            protected void onChanged(ExtTextField txt2) {
            }

            public void setFile(File file) {
                super.setFile(file);
                AbstractNodePropertiesPanel.this.save();
            }
        };
        this.setListeners((JTextComponent)this.destination.getTxt());
        this.packagename = new SearchComboBox<PackageHistoryEntry>(){

            protected boolean isSearchCaseSensitive() {
                return true;
            }

            protected Icon getIconForValue(PackageHistoryEntry value) {
                return null;
            }

            protected String getTextForValue(PackageHistoryEntry value) {
                return value == null ? null : value.getName();
            }

            public void onChanged() {
            }

            protected void sortFound(String search, List<PackageHistoryEntry> found) {
                Collections.sort(found, new Comparator<PackageHistoryEntry>(){

                    @Override
                    public int compare(PackageHistoryEntry o1, PackageHistoryEntry o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
        };
        this.packagename.setBadColor(null);
        this.packagename.setUnkownTextInputAllowed(true);
        this.packagename.setHelpText(_GUI.T.AddLinksDialog_layoutDialogContent_packagename_help());
        this.packagename.setSelectedItem(null);
        this.setListeners(this.packagename.getTextField());
        this.comment = new ExtTextArea(){

            public void onChanged() {
            }
        };
        this.comment.setHelpText(_GUI.T.AddLinksDialog_layoutDialogContent_comment_help());
        this.comment.setBorder((Border)BorderFactory.createCompoundBorder(this.comment.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.setListeners((JTextComponent)this.comment);
        this.filename = this.createFileNameTextField();
        this.setListeners((JTextComponent)this.filename);
        this.filename.setBorder((Border)BorderFactory.createCompoundBorder(this.filename.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.downloadpassword = new ExtTextField(){

            public void onChanged() {
            }
        };
        this.addSelectAllFocusListener(this.downloadpassword);
        this.downloadpassword.setHelpText(_GUI.T.AddLinksDialog_layoutDialogContent_password_tt());
        this.setListeners((JTextComponent)this.downloadpassword);
        this.downloadpassword.setBorder((Border)BorderFactory.createCompoundBorder(this.downloadpassword.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.downloadFrom = new ExtTextField(){

            public void onChanged() {
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                InputMap map = this.getInputMap(condition);
                ActionMap am = this.getActionMap();
                if (map != null && am != null && this.isEnabled()) {
                    Action action;
                    Object binding = map.get(ks);
                    Action action2 = action = binding == null ? null : am.get(binding);
                    if (action != null) {
                        if (action instanceof DefaultEditorKit.CopyAction) {
                            return super.processKeyBinding(ks, e, condition, pressed);
                        }
                        if ("select-all".equals(binding)) {
                            return super.processKeyBinding(ks, e, condition, pressed);
                        }
                        if (action instanceof TextAction) {
                            return false;
                        }
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.addSelectAllFocusListener(this.downloadFrom);
        this.downloadFrom.setBorder((Border)BorderFactory.createCompoundBorder(this.downloadFrom.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.checksum = new ExtTextField(){

            public void onChanged() {
            }
        };
        this.addSelectAllFocusListener(this.checksum);
        this.checksum.setHelpText(_GUI.T.AddLinksDialog_layoutDialogContent_checksum_tt());
        this.setListeners((JTextComponent)this.checksum);
        this.checksum.setBorder((Border)BorderFactory.createCompoundBorder(this.checksum.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.password = new ExtTextField(){

            public void onChanged() {
            }
        };
        this.addSelectAllFocusListener(this.password);
        this.setListeners((JTextComponent)this.password);
        this.password.setHelpText(_GUI.T.AddLinksDialog_createExtracOptionsPanel_password());
        this.password.setBorder((Border)BorderFactory.createCompoundBorder(this.password.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.priority = new PseudoCombo<Priority>(Priority.values()){

            @Override
            protected Icon getIcon(Priority v, boolean closed) {
                return v.loadIcon(18);
            }

            @Override
            protected String getLabel(Priority v, boolean closed) {
                return v.T();
            }

            @Override
            protected Icon getPopIcon(boolean closed) {
                if (closed) {
                    return NewTheme.I().getIcon("popDownLarge", -1);
                }
                return NewTheme.I().getIcon("popUpLarge", -1);
            }

            @Override
            public void onChanged(Priority newValue) {
                super.onChanged(newValue);
                AbstractNodePropertiesPanel.this.save();
            }
        };
        this.priority.setPopDown(true);
        this.autoExtract = new PseudoCombo<BooleanStatus>(BooleanStatus.values()){

            @Override
            protected Icon getIcon(BooleanStatus v, boolean closed) {
                if (closed) {
                    switch (v) {
                        case FALSE: {
                            return NewTheme.I().getIcon("false", 18);
                        }
                        case TRUE: {
                            return NewTheme.I().getIcon("true", 18);
                        }
                        case UNSET: {
                            if (CFG_LINKGRABBER.AUTO_EXTRACTION_ENABLED.isEnabled()) {
                                return NewTheme.I().getIcon("true-orange", 18);
                            }
                            return NewTheme.I().getIcon("false-orange", 18);
                        }
                    }
                } else {
                    switch (v) {
                        case FALSE: {
                            return NewTheme.I().getIcon("false", 18);
                        }
                        case TRUE: {
                            return NewTheme.I().getIcon("true", 18);
                        }
                        case UNSET: {
                            if (CFG_LINKGRABBER.AUTO_EXTRACTION_ENABLED.isEnabled()) {
                                return NewTheme.I().getIcon("true-orange", 18);
                            }
                            return NewTheme.I().getIcon("false-orange", 18);
                        }
                    }
                }
                return null;
            }

            @Override
            protected String getLabel(BooleanStatus v, boolean closed) {
                if (closed) {
                    switch (v) {
                        case FALSE: {
                            return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextractdisabled_closed();
                        }
                        case TRUE: {
                            return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextractenabled_closed();
                        }
                        case UNSET: {
                            if (CFG_LINKGRABBER.AUTO_EXTRACTION_ENABLED.isEnabled()) {
                                return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextract_default_true_closed();
                            }
                            return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextract_default_false_closed();
                        }
                    }
                } else {
                    switch (v) {
                        case FALSE: {
                            return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextractdisabled();
                        }
                        case TRUE: {
                            return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextractenabled();
                        }
                        case UNSET: {
                            if (CFG_LINKGRABBER.AUTO_EXTRACTION_ENABLED.isEnabled()) {
                                return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextract_default_true();
                            }
                            return _GUI.T.PackagePropertiesPanel_getListCellRendererComponent_autoextract_default_false();
                        }
                    }
                }
                return "";
            }

            @Override
            protected Icon getPopIcon(boolean closed) {
                if (closed) {
                    return NewTheme.I().getIcon("popDownLarge", -1);
                }
                return NewTheme.I().getIcon("popUpLarge", -1);
            }

            @Override
            public void onChanged(BooleanStatus newValue) {
                super.onChanged(newValue);
                AbstractNodePropertiesPanel.this.save();
            }
        };
        this.autoExtract.setPopDown(true);
        this.layoutComponents();
        this.autoExtract.setEnabled(false);
        this.password.setEnabled(false);
        this.onHidden();
    }

    protected void addSelectAllFocusListener(final ExtTextField textField) {
        textField.addFocusListener(new FocusListener(){
            boolean focusLost = true;

            @Override
            public void focusGained(FocusEvent e) {
                if (this.focusLost) {
                    this.focusLost = false;
                    textField.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() || e.getOppositeComponent() == null) {
                    this.focusLost = true;
                }
            }
        });
    }

    protected void onHidden() {
        this.setAbstractNodeProperties(null);
    }

    protected void onShowing() {
        this.refresh(true);
    }

    protected ExtTextField createFileNameTextField() {
        return new ExtTextField(){

            public void onChanged() {
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refresh();
    }

    protected void addArchiveLine(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_archivepassword(), _GUI.T.AddLinksDialog_layoutDialogContent_downloadpassword_tt()), (Object)("aligny center,alignx right,height " + height + "!"));
        p.add((Component)this.password, (Object)("pushx,growx,height " + height + "!,growx,width 10:10:n"));
        p.add(this.autoExtract, (Object)("sg right,height " + height + "!,aligny top"));
    }

    protected void addChecksum(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_checksum(), _GUI.T.AddLinksDialog_layoutDialogContent_checksum_tt()), (Object)("aligny center,alignx right,height " + height + "!"));
        p.add((Component)this.checksum, (Object)("spanx,height " + height + "!,growx,width 10:10:n"));
    }

    protected void addCommentLine(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_comment(), _GUI.T.AddLinksDialog_layoutDialogContent_comment_tt()), (Object)("alignx right,aligny center,height " + height + "!"));
        p.add((Component)this.comment, (Object)("height " + height + "!,growx,width 10:10:n"));
        p.add(this.priority, (Object)("sg right,height " + height + "!,aligny top"));
    }

    protected void addDownloadFrom(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_downloadfrom(), _GUI.T.AddLinksDialog_layoutDialogContent_downloadfrom_tt()), (Object)("aligny center,alignx right,height " + height + "!"));
        p.add((Component)this.downloadFrom, (Object)("spanx,height " + height + "!,growx,width 10:10:n"));
    }

    protected void addDownloadPassword(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_passwod(), _GUI.T.AddLinksDialog_layoutDialogContent_password_tt()), (Object)("aligny center,alignx right,height " + height + "!"));
        p.add((Component)this.downloadpassword, (Object)("spanx,height " + height + "!,growx,width 10:10:n"));
    }

    protected void addFilename(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_filename(), _GUI.T.AddLinksDialog_layoutDialogContent_filename_tt()), (Object)("aligny center,alignx right,height " + height + "!"));
        p.add((Component)this.filename, (Object)("spanx,height " + height + "!,growx,width 10:10:n"));
    }

    protected void addPackagename(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_packagename(), _GUI.T.AddLinksDialog_layoutDialogContent_package_tt()), (Object)("aligny center,alignx right,height " + height + "!"));
        p.add(this.packagename, (Object)("spanx,height " + height + "!,growx,width 10:10:n"));
    }

    protected void addSaveTo(int height, MigPanel p) {
        p.add(this.createIconLabel(_GUI.T.propertiespanel_downloadpath(), _GUI.T.AddLinksDialog_layoutDialogContent_save_tt()), (Object)("aligny center,alignx right,height " + height + "!"));
        p.add((Component)this.destination.getDestination(), (Object)("height " + height + "!,growx,width 10:10:n"));
        p.add((Component)this.destination.getButton(), (Object)("sg right,height " + height + "! "));
    }

    private Component createIconLabel(String label, String tooltip) {
        JLabel ret = new JLabel();
        ret.setText(label);
        ret.setToolTipText(tooltip);
        SwingUtils.toBold((JLabel)ret);
        ret.setEnabled(false);
        return ret;
    }

    protected void delayedSave() {
        if (this.settingLock.get() == 0) {
            this.saveDelayer.resetAndStart();
        }
    }

    protected abstract boolean isArchiveLineEnabled();

    protected abstract boolean isCheckSumEnabled();

    protected abstract boolean isCommentAndPriorityEnabled();

    protected abstract boolean isDownloadFromEnabled();

    protected abstract boolean isDownloadPasswordEnabled();

    protected abstract boolean isFileNameEnabled();

    protected abstract boolean isPackagenameEnabled();

    protected abstract boolean isSaveToEnabled();

    private void layoutComponents() {
        int height = Math.max(24, (int)((double)this.comment.getPreferredSize().height * 0.9));
        AbstractNodePropertiesPanel p = this;
        p.removeAll();
        p.setLayout((LayoutManager)new MigLayout("ins 0,wrap 3, gap " + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap(), "[][grow,fill][]", "[]"));
        if (this.isPackagenameEnabled()) {
            this.addPackagename(height, p);
        }
        if (this.isFileNameEnabled()) {
            this.addFilename(height, p);
        }
        if (this.isSaveToEnabled()) {
            this.addSaveTo(height, p);
        }
        if (this.isDownloadFromEnabled()) {
            this.addDownloadFrom(height, p);
        }
        if (this.isDownloadPasswordEnabled()) {
            this.addDownloadPassword(height, p);
        }
        if (this.isCheckSumEnabled()) {
            this.addChecksum(height, p);
        }
        if (this.isCommentAndPriorityEnabled()) {
            this.addCommentLine(height, p);
        }
        if (this.isArchiveLineEnabled()) {
            this.addArchiveLine(height, p);
        }
        this.refresh(true);
        this.revalidate();
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                AbstractNodePropertiesPanel.this.layoutComponents();
            }
        };
    }

    public void refresh() {
        this.refreshRequested.incrementAndGet();
        this.updateDelayer.resetAndStart();
    }

    protected void refresh(final boolean forceRefresh) {
        new EDTRunner(){

            protected void runInEDT() {
                Object lAbstractNodeProperties = AbstractNodePropertiesPanel.this.getAbstractNodeProperties();
                if (lAbstractNodeProperties == null || !AbstractNodePropertiesPanel.this.isShowing() || AbstractNodePropertiesPanel.this.savingLock.get() > 0) {
                    return;
                }
                AbstractNodePropertiesPanel.this.loadInEDT(forceRefresh, (AbstractNodeProperties)lAbstractNodeProperties);
            }
        };
    }

    public void setSelectedItem(final AbstractNode abstractNode) {
        new EDTRunner(){

            protected void runInEDT() {
                if (AbstractNodePropertiesPanel.this.isDifferent(abstractNode)) {
                    if (abstractNode == null) {
                        AbstractNodePropertiesPanel.this.setAbstractNodeProperties(null);
                    } else {
                        AbstractNodePropertiesPanel.this.setAbstractNodeProperties(AbstractNodePropertiesPanel.this.createAbstractNodeProperties(abstractNode));
                    }
                }
            }
        };
    }

    protected abstract E createAbstractNodeProperties(AbstractNode var1);

    protected boolean isDifferent(AbstractNode abstractNode) {
        E lAbstractNodeProperties = this.getAbstractNodeProperties();
        if (lAbstractNodeProperties == null && abstractNode == null) {
            return false;
        }
        if (lAbstractNodeProperties == null && abstractNode != null) {
            return true;
        }
        if (lAbstractNodeProperties != null && abstractNode == null) {
            return true;
        }
        return lAbstractNodeProperties != null && abstractNode != null && ((AbstractNodeProperties)lAbstractNodeProperties).isDifferent(abstractNode);
    }

    protected boolean isSame(AbstractNode abstractNode) {
        E lAbstractNodeProperties = this.getAbstractNodeProperties();
        return lAbstractNodeProperties != null && !((AbstractNodeProperties)lAbstractNodeProperties).isDifferent(abstractNode);
    }

    public void save() {
        new EDTRunner(){

            protected void runInEDT() {
                Object lAbstractNodeProperties = AbstractNodePropertiesPanel.this.getAbstractNodeProperties();
                if (lAbstractNodeProperties == null || AbstractNodePropertiesPanel.this.settingLock.get() > 0) {
                    return;
                }
                if (AbstractNodePropertiesPanel.this.refreshDone.get() != AbstractNodePropertiesPanel.this.refreshRequested.get()) {
                    AbstractNodePropertiesPanel.this.loadInEDT(false, (AbstractNodeProperties)lAbstractNodeProperties);
                }
                AbstractNodePropertiesPanel.this.saveInEDT((AbstractNodeProperties)lAbstractNodeProperties);
            }
        };
    }

    private String emptyAsNull(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveInEDT(AbstractNodeProperties abstractNodes) {
        try {
            String path;
            String saveTo;
            List<Archive> archives;
            String oldName;
            String newName;
            this.savingLock.incrementAndGet();
            if (this.priority.getParent() != null) {
                abstractNodes.savePriority(this.priority.getSelectedItem());
            }
            if (this.comment.getParent() != null) {
                abstractNodes.saveComment(this.emptyAsNull(this.comment.getText()));
            }
            if (this.filename.getParent() != null) {
                abstractNodes.saveFilename(this.filename.getText());
            }
            if (this.downloadpassword.getParent() != null) {
                abstractNodes.saveDownloadPassword(this.emptyAsNull(this.downloadpassword.getText()));
            }
            if (this.checksum.getParent() != null) {
                String cs = this.checksum.getText();
                HashInfo hashInfo = HashInfo.parse(cs, true, false);
                if (hashInfo == null) {
                    hashInfo = new HashInfo("", HashInfo.TYPE.NONE, true, true);
                }
                abstractNodes.saveHashInfo(hashInfo);
            }
            if (this.packagename.getParent() != null && !StringUtils.equals((String)(newName = this.packagename.getText()), (String)(oldName = abstractNodes.loadPackageName()))) {
                abstractNodes.savePackageName(newName);
                PackageHistoryManager.getInstance().add(newName);
            }
            if (abstractNodes.hasLoadedArchives() && (archives = abstractNodes.loadArchives()) != null && archives.size() == 1) {
                if (this.password.getParent() != null) {
                    ArrayList passwords = null;
                    String txt = this.password.getText().trim();
                    if (txt.startsWith("[") && txt.endsWith("]")) {
                        passwords = (ArrayList)JSonStorage.restoreFromString((String)txt, (TypeRef)new TypeRef<ArrayList<String>>(){}, null);
                    }
                    if (passwords != null && passwords.size() > 0) {
                        abstractNodes.saveArchivePasswords(new ArrayList<String>(new LinkedHashSet(passwords)));
                    } else {
                        ArrayList<String> passwordsList = new ArrayList<String>();
                        if (StringUtils.isNotEmpty((String)txt)) {
                            passwordsList.add(txt);
                        }
                        abstractNodes.saveArchivePasswords(passwordsList);
                    }
                }
                if (this.autoExtract.getParent() != null) {
                    abstractNodes.saveAutoExtract(this.autoExtract.getSelectedItem());
                }
            }
            if (this.destination.getDestination().getParent() != null && !StringUtils.equals((String)(saveTo = abstractNodes.loadSaveTo()), (String)(path = this.destination.getPath()))) {
                abstractNodes.saveSaveTo(PackagizerController.replaceDynamicTags(path, abstractNodes.loadPackageName(), abstractNodes.getCurrentNode()));
                DownloadPathHistoryManager.getInstance().add(path);
            }
        }
        finally {
            this.savingLock.decrementAndGet();
        }
    }

    protected void setListeners(JTextComponent component) {
        final Listener list = new Listener(component);
        if (component instanceof JTextField) {
            ((JTextField)component).addActionListener(list);
        } else if (component instanceof JTextArea) {
            ((JTextArea)component).addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    list.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "focusLost"));
                }
            });
        }
        component.addKeyListener(list);
        component.addFocusListener(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInEDT(final boolean newData, final AbstractNodeProperties abstractNodes) {
        try {
            this.settingLock.incrementAndGet();
            if (this.downloadFrom.getParent() != null && (newData || !this.downloadFrom.hasFocus())) {
                this.downloadFrom.setText(abstractNodes.loadDownloadFrom());
            }
            if (this.filename.getParent() != null && (newData || !this.filename.hasFocus())) {
                this.filename.setText(abstractNodes.loadFilename());
            }
            if (this.comment.getParent() != null && (newData || !this.comment.hasFocus())) {
                this.comment.setText(abstractNodes.loadComment());
            }
            if (this.destination.getDestination().getParent() != null && (newData || !this.destination.getDestination().hasFocus())) {
                String saveTo = abstractNodes.loadSaveTo();
                List<String> pathlist = DownloadPathHistoryManager.getInstance().listPaths(saveTo, ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder());
                this.destination.setQuickSelectionList(pathlist);
                this.destination.setFile(new File(saveTo));
            }
            if (this.checksum.getParent() != null && (newData || !this.checksum.hasFocus())) {
                HashInfo hashInfo = abstractNodes.loadHashInfo();
                if (hashInfo != null) {
                    this.checksum.setText("[" + (Object)((Object)hashInfo.getType()) + "] " + hashInfo.getHash());
                } else {
                    this.checksum.setText(null);
                }
            }
            if (this.downloadpassword.getParent() != null && (newData || !this.downloadpassword.hasFocus())) {
                this.downloadpassword.setText(abstractNodes.loadDownloadPassword());
            }
            if (this.packagename.getParent() != null && (newData || !this.packagename.hasFocus())) {
                String packageName = abstractNodes.loadPackageName();
                this.packagename.setList(PackageHistoryManager.getInstance().list(new PackageHistoryEntry(packageName)));
                this.packagename.setSelectedItem((Object)new PackageHistoryEntry(packageName));
            }
            if (this.password.getParent() != null && (newData || !this.password.hasFocus())) {
                this.password.setText("");
            }
            if (this.priority.getParent() != null && (newData || !this.priority.hasFocus())) {
                this.priority.setSelectedItem(abstractNodes.loadPriority());
            }
            if (abstractNodes.hasLoadedArchives()) {
                this.updateArchiveInEDT(newData, abstractNodes);
            } else {
                SERVICE.execute(new Runnable(){

                    @Override
                    public void run() {
                        Object current = AbstractNodePropertiesPanel.this.getAbstractNodeProperties();
                        if (current == abstractNodes) {
                            abstractNodes.loadArchives();
                            new EDTRunner(){

                                protected void runInEDT() {
                                    Object current = AbstractNodePropertiesPanel.this.getAbstractNodeProperties();
                                    if (current == abstractNodes) {
                                        AbstractNodePropertiesPanel.this.updateArchiveInEDT(newData, abstractNodes);
                                    }
                                }
                            };
                        }
                    }
                });
            }
        }
        finally {
            this.settingLock.decrementAndGet();
            this.refreshDone.set(this.refreshRequested.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateArchiveInEDT(boolean newData, AbstractNodeProperties abstractNodes) {
        try {
            this.settingLock.incrementAndGet();
            List<Archive> archives = abstractNodes.loadArchives();
            boolean validArchiveSelection = archives != null && archives.size() == 1;
            this.autoExtract.setEnabled(validArchiveSelection);
            this.password.setEnabled(validArchiveSelection);
            if (validArchiveSelection) {
                Archive archive = archives.get(0);
                if (this.password.getParent() != null && (newData || !this.password.hasFocus())) {
                    String finalPassword = archive.getFinalPassword();
                    if (StringUtils.isNotEmpty((String)finalPassword)) {
                        this.password.setText(finalPassword);
                    } else {
                        List passwords = archive.getSettings().getPasswords();
                        if (passwords == null || passwords.size() == 0) {
                            this.password.setText(null);
                        } else if (passwords.size() == 1) {
                            this.password.setText((String)passwords.get(0));
                        } else {
                            this.password.setText(JSonStorage.toString((Object)passwords));
                        }
                    }
                }
                if (this.autoExtract.getParent() != null && (newData || !this.autoExtract.hasFocus())) {
                    this.autoExtract.setSelectedItem(archive.getSettings().getAutoExtract());
                }
            }
        }
        finally {
            this.settingLock.decrementAndGet();
        }
    }

    class Listener
    implements ActionListener,
    KeyListener,
    FocusListener {
        private final JTextComponent field;
        private boolean saveOnFocusLost = true;
        private String oldText;

        public Listener(JTextComponent filename) {
            this.field = filename;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractNodePropertiesPanel.this.save();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                this.field.setText(this.oldText);
                this.field.selectAll();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.oldText = this.field.getText();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.saveOnFocusLost) {
                AbstractNodePropertiesPanel.this.save();
            } else {
                AbstractNodePropertiesPanel.this.refresh();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

