/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.properties;

import java.io.File;
import java.util.List;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.FilePackage;
import jd.plugins.download.HashInfo;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.downloads.action.SetDownloadFolderInDownloadTableAction;
import org.jdownloader.gui.views.downloads.properties.AbstractNodeProperties;

public class FilePackageNodeProperties
extends AbstractNodeProperties<FilePackage> {
    private final FilePackage currentPackage;
    private List<Archive> archives = null;

    public FilePackageNodeProperties(FilePackage filePackage) {
        this.currentPackage = filePackage;
    }

    @Override
    protected String loadDownloadFrom() {
        return null;
    }

    @Override
    protected String loadDownloadPassword() {
        return null;
    }

    @Override
    protected List<Archive> loadArchives() {
        if (this.archives == null) {
            FilePackage pkg = this.currentPackage;
            boolean readL2 = pkg.getModifyLock().readLock();
            try {
                this.archives = ArchiveValidator.getArchivesFromPackageChildren(pkg.getChildren(), (int)2);
            }
            finally {
                pkg.getModifyLock().readUnlock(readL2);
            }
        }
        return this.archives;
    }

    @Override
    protected String loadFilename() {
        return null;
    }

    @Override
    protected String loadComment() {
        return this.currentPackage.getComment();
    }

    @Override
    protected Priority loadPriority() {
        return this.currentPackage.getPriorityEnum();
    }

    @Override
    protected String loadSaveTo() {
        return LinkTreeUtils.getRawDownloadDirectory(this.currentPackage).getAbsolutePath();
    }

    @Override
    protected void savePackageName(String text) {
        this.currentPackage.setName(text);
    }

    @Override
    protected void saveArchivePasswords(List<String> hashSet) {
        List<Archive> archives = this.archives;
        if (archives != null && archives.size() == 1) {
            archives.get(0).getSettings().setPasswords(hashSet);
        }
    }

    @Override
    protected void saveAutoExtract(BooleanStatus selectedItem) {
        List<Archive> archives = this.archives;
        if (archives != null && archives.size() == 1) {
            archives.get(0).getSettings().setAutoExtract(selectedItem);
        }
    }

    @Override
    protected void saveDownloadPassword(String text) {
    }

    @Override
    protected void saveFilename(String text) {
    }

    @Override
    protected void savePriority(Priority priop) {
        if (priop != null) {
            this.currentPackage.setPriorityEnum(priop);
        }
    }

    @Override
    protected void saveComment(String text) {
        this.currentPackage.setComment(text);
    }

    @Override
    protected void saveSaveTo(final String stringpath) {
        new SetDownloadFolderInDownloadTableAction(new SelectionInfo(this.currentPackage)){
            private static final long serialVersionUID = 395350065855311575L;

            @Override
            protected File dialog(File path) throws DialogClosedException, DialogCanceledException {
                return new File(stringpath);
            }
        }.actionPerformed(null);
    }

    @Override
    protected String loadPackageName() {
        return this.currentPackage.getName();
    }

    @Override
    protected boolean samePackage(AbstractPackageNode pkg) {
        return this.currentPackage == pkg;
    }

    @Override
    protected boolean isDifferent(AbstractNode node) {
        if (node != null && node instanceof AbstractPackageNode) {
            AbstractPackageNode parent = (AbstractPackageNode)node;
            return this.currentPackage != parent;
        }
        return true;
    }

    @Override
    protected boolean hasLoadedArchives() {
        return this.archives != null;
    }

    @Override
    protected HashInfo loadHashInfo() {
        return null;
    }

    @Override
    protected void saveHashInfo(HashInfo hashInfo) {
    }

    @Override
    protected FilePackage getCurrentNode() {
        return this.currentPackage;
    }
}

