/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.table;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import jd.controlling.TaskQueue;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.exttable.DropHighlighter;
import org.appwork.swing.exttable.ExtCheckBoxMenuItem;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtOverlayRowHighlighter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.helpdialogs.MessageConfig;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.MenuManagerDownloadTabBottomBar;
import org.jdownloader.gui.views.downloads.action.DownloadTabActionUtils;
import org.jdownloader.gui.views.downloads.contextmenumanager.MenuManagerDownloadTableContext;
import org.jdownloader.gui.views.downloads.table.DownloadTableContextMenuFactory;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.gui.views.downloads.table.DownloadsTableTransferHandler;
import org.jdownloader.gui.views.downloads.table.HorizontalScrollbarAction;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class DownloadsTable
extends PackageControllerTable<FilePackage, DownloadLink> {
    private static final long serialVersionUID = 8843600834248098174L;
    private HashMap<KeyStroke, Action> shortCutActions;
    private final LogSource logger;
    private static DownloadsTable INSTANCE = null;

    public DownloadsTable(DownloadsTableModel tableModel) {
        super(tableModel);
        INSTANCE = this;
        this.addRowHighlighter((ExtOverlayRowHighlighter)new DropHighlighter(null, new Color(27, 164, 191, 75)));
        this.setTransferHandler(new DownloadsTableTransferHandler(this));
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.logger = LogController.getInstance().getLogger(DownloadsTable.class.getName());
        this.setAutoResizeMode(3);
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow]", "[grow]"));
    }

    protected void fireColumnModelUpdate() {
        super.fireColumnModelUpdate();
        new EDTRunner(){

            protected void runInEDT() {
                boolean alllocked = true;
                for (ExtColumn c : DownloadsTable.this.getModel().getColumns()) {
                    if (!c.isResizable()) continue;
                    alllocked = false;
                    break;
                }
                if (alllocked) {
                    JScrollPane sp = (JScrollPane)DownloadsTable.this.getParent().getParent();
                    CFG_GUI.HORIZONTAL_SCROLLBARS_IN_DOWNLOAD_TABLE_ENABLED.setValue((Object)true);
                    DownloadsTable.this.setColumnSaveID("hBAR");
                    DownloadsTable.this.setAutoResizeMode(0);
                    sp.setVerticalScrollBarPolicy(22);
                    sp.setHorizontalScrollBarPolicy(30);
                }
            }
        };
    }

    protected JPopupMenu columnControlMenu(ExtColumn<AbstractNode> extColumn) {
        JPopupMenu popup = super.columnControlMenu(extColumn);
        popup.add(new JSeparator());
        popup.add((JMenuItem)new ExtCheckBoxMenuItem((AbstractAction)((Object)new HorizontalScrollbarAction((ExtTable)this, CFG_GUI.HORIZONTAL_SCROLLBARS_IN_DOWNLOAD_TABLE_ENABLED))));
        return popup;
    }

    protected boolean onDoubleClick(MouseEvent e, AbstractNode obj) {
        return false;
    }

    public boolean isSearchEnabled() {
        return false;
    }

    protected boolean onShortcutDelete(List<AbstractNode> selectedObjects, final KeyEvent evt, boolean direct) {
        this.getSelectionInfo(new PackageControllerTable.QueueSelectionInfoCallback<FilePackage, DownloadLink>(){

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void onSelectionInfo(SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
                DownloadTabActionUtils.deleteLinksRequest(selectionInfo, _GUI.T.RemoveSelectionAction_actionPerformed_(), GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_ONLY, evt.isControlDown());
            }

            @Override
            public Queue getQueue() {
                return TaskQueue.getQueue();
            }
        }, PackageControllerTable.SelectionType.SELECTED);
        return true;
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, AbstractNode contextObject, List<AbstractNode> selection, ExtColumn<AbstractNode> column, MouseEvent ev) {
        return DownloadTableContextMenuFactory.getInstance().create(this, popup, contextObject, selection, column, ev);
    }

    protected boolean onHeaderSortClick(final MouseEvent e1, final ExtColumn<AbstractNode> oldSortColumn, String oldSortId, ExtColumn<AbstractNode> newColumn) {
        new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Timer t = (Timer)e.getSource();
                t.stop();
                if (oldSortColumn == DownloadsTable.this.getModel().getSortColumn()) {
                    return;
                }
                if (DownloadsTable.this.getModel().getSortColumn() != null) {
                    HelpDialog.showIfAllowed(new MessageConfig(e1.getLocationOnScreen(), "downloadtabe_sortwarner", 32, _GUI.T.DownloadsTable_actionPerformed_sortwarner_title(DownloadsTable.this.getModel().getSortColumn().getName()), _GUI.T.DownloadsTable_actionPerformed_sortwarner_text(), new AbstractIcon("sort", 32)));
                }
            }
        }).start();
        return false;
    }

    protected boolean onShortcutCopy(List<AbstractNode> selectedObjects, KeyEvent evt) {
        if (evt.isAltDown() || evt.isMetaDown() || evt.isAltGraphDown() || evt.isShiftDown()) {
            return false;
        }
        TransferHandler.getCopyAction().actionPerformed(new ActionEvent((Object)this, 1001, "copy"));
        return true;
    }

    protected boolean onShortcutCut(List<AbstractNode> selectedObjects, KeyEvent evt) {
        if (evt.isAltDown() || evt.isMetaDown() || evt.isAltGraphDown() || evt.isShiftDown()) {
            return false;
        }
        TransferHandler.getCutAction().actionPerformed(new ActionEvent((Object)this, 1001, "cut"));
        return true;
    }

    protected boolean onShortcutPaste(List<AbstractNode> selectedObjects, KeyEvent evt) {
        if (evt.isAltDown() || evt.isMetaDown() || evt.isAltGraphDown() || evt.isShiftDown()) {
            return false;
        }
        TransferHandler.getPasteAction().actionPerformed(new ActionEvent((Object)this, 1001, "paste"));
        return true;
    }

    protected boolean isDeleteFinalSelectionTrigger(KeyStroke ks) {
        if (super.isDeleteFinalSelectionTrigger(ks)) {
            return true;
        }
        if (CrossSystem.isMac() && ks == KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 2 | 1)) {
            return true;
        }
        return ks == KeyStroke.getKeyStroke(127, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1);
    }

    protected boolean isDeleteSelectionTrigger(KeyStroke ks) {
        if (super.isDeleteSelectionTrigger(ks)) {
            return true;
        }
        if (CrossSystem.isMac() && ks == KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 2)) {
            return true;
        }
        return ks == KeyStroke.getKeyStroke(127, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
        boolean actionNotified = false;
        try {
            InputMap map = this.getInputMap(condition);
            ActionMap am = this.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(stroke);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    if (action instanceof CustomizableAppAction) {
                        ((CustomizableAppAction)((Object)action)).requestUpdate((Object)this);
                    }
                    if (!action.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        actionNotified = SwingUtilities.notifyAction(action, stroke, evt, (Object)this, evt.getModifiers());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionNotified || super.processKeyBinding(stroke, evt, condition, pressed);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int rowCount;
        if (e.getID() == 501 && SwingUtilities.isLeftMouseButton(e) && !this.isExpandToggleEvent(e) && this.getSelectionModel().getValueIsAdjusting() && this.rowAtPoint(e.getPoint()) < 0 && (rowCount = this.getRowCount()) > 0) {
            this.getSelectionModel().setAnchorSelectionIndex(rowCount - 1);
        }
        super.processMouseEvent(e);
    }

    @Override
    public ExtColumn<AbstractNode> getExpandCollapseColumn() {
        return DownloadsTableModel.getInstance().expandCollapse;
    }

    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        return new HashSet<AWTKeyStroke>();
    }

    public void updateContextShortcuts() {
        InputMap input = this.getInputMap(1);
        InputMap input2 = this.getInputMap(0);
        InputMap input3 = this.getInputMap(2);
        ActionMap actions = this.getActionMap();
        if (this.shortCutActions != null) {
            for (Map.Entry<KeyStroke, Action> ks : this.shortCutActions.entrySet()) {
                Object binding = input.get(ks.getKey());
                input.remove(ks.getKey());
                input2.remove(ks.getKey());
                input3.remove(ks.getKey());
                actions.remove(binding);
            }
        }
        this.shortCutActions = new HashMap();
        this.fillActions(MenuManagerDownloadTableContext.getInstance().getMenuData());
        this.fillActions(MenuManagerDownloadTabBottomBar.getInstance().getMenuData());
    }

    private void fillActions(MenuContainer menuData) {
        if (!menuData._isValidated()) {
            return;
        }
        InputMap input = this.getInputMap(1);
        InputMap input2 = this.getInputMap(0);
        InputMap input3 = this.getInputMap(2);
        ActionMap actions = this.getActionMap();
        for (MenuItemData mi : menuData.getItems()) {
            if (!mi._isValidated()) {
                return;
            }
            if (mi instanceof MenuContainer) {
                this.fillActions((MenuContainer)mi);
                continue;
            }
            if (mi instanceof SeparatorData) continue;
            if (mi instanceof MenuLink) {
                List<AppAction> actionsList = ((MenuLink)((Object)mi)).createActionsToLink();
                if (actionsList == null) continue;
                for (AppAction action : actionsList) {
                    KeyStroke keystroke = (KeyStroke)action.getValue("AcceleratorKey");
                    if (keystroke == null) continue;
                    this.linkAction(input, input2, input3, actions, action, keystroke);
                }
                continue;
            }
            try {
                List<KeyStroke> moreShortCuts;
                KeyStroke keystroke;
                if (mi.getActionData() == null || !mi.getActionData()._isValidDataForCreatingAnAction()) continue;
                CustomizableAppAction action = mi.createAction();
                if (StringUtils.isNotEmpty((String)mi.getShortcut())) {
                    keystroke = KeyStroke.getKeyStroke(mi.getShortcut());
                    if (keystroke != null) {
                        action.setAccelerator(keystroke);
                    }
                } else if (MenuItemData.isEmptyValue(mi.getShortcut())) {
                    action.setAccelerator(null);
                }
                keystroke = (KeyStroke)((AppAction)action).getValue("AcceleratorKey");
                this.linkAction(input, input2, input3, actions, action, keystroke);
                if (!(action instanceof CustomizableAppAction) || (moreShortCuts = action.getAdditionalShortcuts(keystroke)) == null) continue;
                for (KeyStroke ks : moreShortCuts) {
                    if (ks == null) continue;
                    this.linkAction(input, input2, input3, actions, action, ks);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void linkAction(InputMap input, InputMap input2, InputMap input3, ActionMap actions, AppAction action, KeyStroke keystroke) {
        if (action != null && keystroke != null) {
            Object old;
            String key = "CONTEXT_ACTION_" + keystroke;
            try {
                old = input.get(keystroke);
                if (old != null && ((Object)((Object)action)).getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + (Object)((Object)action) + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            try {
                old = input2.get(keystroke);
                if (old != null && ((Object)((Object)action)).getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + (Object)((Object)action) + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            try {
                old = input3.get(keystroke);
                if (old != null && ((Object)((Object)action)).getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + (Object)((Object)action) + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            this.logger.info(keystroke + " -> " + (Object)((Object)action));
            input.put(keystroke, key);
            input2.put(keystroke, key);
            input3.put(keystroke, key);
            actions.put(key, (Action)((Object)action));
            this.shortCutActions.put(keystroke, (Action)((Object)action));
        }
    }

    public static DownloadsTable getInstance() {
        return INSTANCE;
    }
}

