/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.table;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.JScrollPane;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtTable;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;

public class HorizontalScrollbarAction
extends AppAction
implements GenericConfigEventListener<Boolean> {
    private ExtTable table;
    private BooleanKeyHandler keyHandler;

    public HorizontalScrollbarAction(ExtTable downloadsTable, BooleanKeyHandler horizontalScrollbarsInDownloadTableEnabled) {
        this.table = downloadsTable;
        this.keyHandler = horizontalScrollbarsInDownloadTableEnabled;
        this.setName(_GUI.T.HorizontalScrollbarAction_columnControlMenu_scrollbar_());
        this.setSelected(this.keyHandler.isEnabled());
        this.keyHandler.getEventSender().addListener((EventListener)((Object)this), true);
    }

    public void actionPerformed(ActionEvent e) {
        this.keyHandler.toggle();
        HorizontalScrollbarAction.setup(this.keyHandler, this.table);
        this.table.updateColumns();
    }

    public static void setup(BooleanKeyHandler keyHandler, ExtTable table) {
        try {
            JScrollPane sp = (JScrollPane)table.getParent().getParent();
            if (keyHandler.isEnabled()) {
                table.setColumnSaveID("hBAR");
                table.setAutoResizeMode(0);
                sp.setVerticalScrollBarPolicy(22);
                sp.setHorizontalScrollBarPolicy(30);
            } else {
                table.setColumnSaveID(null);
                table.setAutoResizeMode(3);
                sp.setVerticalScrollBarPolicy(22);
                sp.setHorizontalScrollBarPolicy(31);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        this.setSelected(this.keyHandler.isEnabled());
    }
}

