/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.table.linkproperties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.TaskQueue;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.BasicJDTable;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.components.packagetable.columns.CommentColumn;
import org.jdownloader.gui.views.downloads.columns.AvailabilityColumn;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.gui.views.downloads.columns.FileSizeColumn;
import org.jdownloader.gui.views.linkgrabber.columns.UrlColumn;
import org.jdownloader.images.AbstractIcon;

public class LinkURLEditor<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends MigPanel {
    private final SelectionInfo<PackageType, ChildrenType> si;

    public LinkURLEditor(SelectionInfo<PackageType, ChildrenType> selectionInfo) {
        super("ins 2,wrap 2", "[grow,fill][]", "[][grow,fill]");
        this.setOpaque(false);
        this.si = selectionInfo;
        JLabel lbl = this.getLbl(_GUI.T.LinkURLEditor(), new AbstractIcon("url", 18));
        this.add(SwingUtils.toBold((JLabel)lbl), "spanx");
        ExtTableModel<AbstractNode> model = new ExtTableModel<AbstractNode>("linkurleditor"){
            {
                this.getTableData().addAll(LinkURLEditor.this.si.getChildren());
            }

            protected void initColumns() {
                this.addColumn((ExtColumn)new FileColumn(){
                    {
                        this.leftGapBorder = this.normalBorder;
                    }

                    @Override
                    public int getDefaultWidth() {
                        return 150;
                    }

                    @Override
                    public boolean isEnabled(AbstractNode obj) {
                        return true;
                    }

                    @Override
                    public boolean isEditable(AbstractNode obj) {
                        return false;
                    }

                    public boolean isDefaultVisible() {
                        return true;
                    }

                    @Override
                    public boolean isHidable() {
                        return false;
                    }
                });
                this.addColumn((ExtColumn)new UrlColumn(){

                    public int getDefaultWidth() {
                        return 350;
                    }

                    @Override
                    public boolean isEnabled(AbstractNode obj) {
                        return true;
                    }

                    @Override
                    public boolean isDefaultVisible() {
                        return true;
                    }

                    public boolean isHidable() {
                        return false;
                    }
                });
                this.addColumn(new FileSizeColumn(){

                    @Override
                    public boolean isEnabled(AbstractNode obj) {
                        return true;
                    }

                    @Override
                    public boolean isDefaultVisible() {
                        return false;
                    }
                });
                this.addColumn((ExtColumn)new AvailabilityColumn(){

                    @Override
                    public boolean isEnabled(AbstractNode obj) {
                        return true;
                    }

                    @Override
                    public boolean isDefaultVisible() {
                        return false;
                    }
                });
                this.addColumn((ExtColumn)new CommentColumn(){

                    @Override
                    public boolean isEnabled(AbstractNode obj) {
                        return true;
                    }

                    public boolean isDefaultVisible() {
                        return false;
                    }

                    @Override
                    public boolean isEditable(AbstractNode obj) {
                        return false;
                    }
                });
            }
        };
        BasicJDTable<AbstractNode> table = new BasicJDTable<AbstractNode>((ExtTableModel)model, (ExtTableModel)model){
            final /* synthetic */ ExtTableModel val$model;
            {
                this.val$model = extTableModel;
                super(tableModel);
            }

            protected JPopupMenu onContextMenu(JPopupMenu popup, AbstractNode contextObject, List<AbstractNode> selection, ExtColumn<AbstractNode> column, MouseEvent mouseEvent) {
                popup.add((Action)((Object)new AppAction(){
                    {
                        this.setName(_GUI.T.LinkURLEditor_onContextMenu_copy_());
                        this.setSmallIcon(new AbstractIcon("copy", 20));
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.onShortcutCopy(val$model.getSelectedObjects(), null);
                    }
                }));
                return popup;
            }

            protected boolean onShortcutCopy(final List<AbstractNode> selectedObjects, KeyEvent evt) {
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        Set<String> urls = selectedObjects.size() == 0 ? LinkTreeUtils.getURLs(LinkURLEditor.this.si, false) : LinkTreeUtils.getURLs(new SelectionInfo(null, selectedObjects), false);
                        StringBuilder sb = new StringBuilder();
                        for (String url : urls) {
                            if (sb.length() > 0) {
                                sb.append("\r\n");
                            }
                            sb.append(url);
                        }
                        ClipboardMonitoring.getINSTANCE().setCurrentContent(sb.toString());
                        return null;
                    }
                });
                return true;
            }
        };
        table.setPreferredScrollableViewportSize(new Dimension(650, 250));
        JScrollPane sp = new JScrollPane((Component)table);
        this.add(sp, "spanx");
    }

    private JLabel getLbl(String linkURLEditor, Icon icon) {
        JLabel ret = new JLabel(linkURLEditor);
        ret.setIcon(icon);
        return ret;
    }
}

