/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorHighlightListener;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.HeaderScrollPane;
import org.jdownloader.gui.views.downloads.bottombar.CustomizeableActionBar;
import org.jdownloader.gui.views.downloads.table.HorizontalScrollbarAction;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberSideBarHeader;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberSidebar;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.gui.views.linkgrabber.LinkgrabberWidgetContainer;
import org.jdownloader.gui.views.linkgrabber.bottombar.LeftRightDividerItem;
import org.jdownloader.gui.views.linkgrabber.bottombar.MenuManagerLinkgrabberTabBottombar;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class LinkGrabberPanel
extends SwitchPanel
implements LinkCollectorListener,
GenericConfigEventListener<Boolean> {
    private static final long serialVersionUID = 1L;
    private LinkGrabberTableModel tableModel = LinkGrabberTableModel.getInstance();
    private LinkGrabberTable table = new LinkGrabberTable(this, this.tableModel);
    private final JScrollPane tableScrollPane = new JScrollPane((Component)((Object)this.table));
    private LinkGrabberSidebar sidebar;
    private HeaderScrollPane sidebarScrollPane;
    private CustomizeableActionBar rightBar;
    private CustomizeableActionBar leftBar;
    private JComponent sidebarContainer;
    private LinkgrabberWidgetContainer widgetContainer;

    public LinkGrabberTable getTable() {
        return this.table;
    }

    public LinkGrabberPanel() {
        super((LayoutManager)new MigLayout("ins 0, wrap 2", "[grow,fill]2[]2[fill]", "[grow, fill]2[]"));
        this.tableScrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                LinkGrabberPanel.this.table.scrollToSelection(-1);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        LAFOptions.getInstance().getExtension().customizeLinksTable((JComponent)((Object)this.table), this.tableScrollPane);
        HorizontalScrollbarAction.setup(CFG_GUI.HORIZONTAL_SCROLLBARS_IN_LINKGRABBER_TABLE_ENABLED, (ExtTable)this.table);
        LinkCollector.getInstance().getEventsender().addListener(new LinkCollectorHighlightListener(){

            @Override
            public void onHighLight(CrawledLink parameter) {
                new EDTRunner(){

                    protected void runInEDT() {
                        try {
                            switch (CFG_GUI.CFG.getNewLinksActionV2()) {
                                case SWITCH: {
                                    JDGui.getInstance().requestPanel(JDGui.Panels.LINKGRABBER);
                                    break;
                                }
                                case FOCUS: {
                                    JDGui.getInstance().requestPanel(JDGui.Panels.LINKGRABBER);
                                    JDGui.getInstance().setFrameState(WindowManager.FrameState.TO_FRONT_FOCUSED);
                                    break;
                                }
                                case NOTHING: {
                                    JDGui.getInstance().flashTaskbar();
                                    break;
                                }
                                case TO_FRONT: {
                                    JDGui.getInstance().requestPanel(JDGui.Panels.LINKGRABBER);
                                    JDGui.getInstance().setFrameState(WindowManager.FrameState.TO_FRONT);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                };
            }

            @Override
            public boolean isThisListenerEnabled() {
                return CFG_GUI.CFG.getNewLinksActionV2() != GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction.NOTHING;
            }

            @Override
            public void onLinkCrawlerAdded(LinkCollectorCrawler parameter) {
            }

            @Override
            public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
            }

            @Override
            public void onLinkCrawlerStopped(LinkCollectorCrawler parameter) {
            }

            @Override
            public void onLinkCrawlerNewJob(LinkCollectingJob job) {
            }

            @Override
            public void onLinkCrawlerFinished() {
            }
        });
        this.rightBar = new CustomizeableActionBar(MenuManagerLinkgrabberTabBottombar.getInstance()){

            @Override
            protected MenuContainerRoot prepare(MenuContainerRoot menuData) {
                MenuContainerRoot ret = new MenuContainerRoot();
                menuData._setOwner(MenuManagerLinkgrabberTabBottombar.getInstance());
                boolean foundSeparator = false;
                for (MenuItemData mi : menuData.getItems()) {
                    if (mi instanceof LeftRightDividerItem) {
                        foundSeparator = true;
                        continue;
                    }
                    if (!foundSeparator) continue;
                    ret.add(mi);
                }
                return ret;
            }

            @Override
            public void updateGui() {
                super.updateGui();
                LinkGrabberPanel.this.table.updateContextShortcuts();
            }
        };
        this.leftBar = new CustomizeableActionBar(MenuManagerLinkgrabberTabBottombar.getInstance()){

            @Override
            protected MenuContainerRoot prepare(MenuContainerRoot menuData) {
                MenuContainerRoot ret = new MenuContainerRoot();
                ret._setOwner(MenuManagerLinkgrabberTabBottombar.getInstance());
                for (MenuItemData mi : menuData.getItems()) {
                    if (mi instanceof LeftRightDividerItem) break;
                    ret.add(mi);
                }
                return ret;
            }

            @Override
            public void updateGui() {
                super.updateGui();
                LinkGrabberPanel.this.table.updateContextShortcuts();
            }
        };
        this.layoutComponents();
        CFG_GUI.LINKGRABBER_SIDEBAR_VISIBLE.getEventSender().addListener((EventListener)this);
        CFG_GUI.LINKGRABBER_BOTTOMBAR_POSITION.getEventSender().addListener((EventListener)new GenericConfigEventListener<Enum>(){

            public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
                LinkGrabberPanel.this.fireRelayout();
            }

            public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
            }
        });
        MenuManagerLinkgrabberTableContext.getInstance().setPanel(this);
    }

    private void layoutComponents() {
        if (this.widgetContainer != null) {
            this.widgetContainer.save();
        }
        this.removeAll();
        switch (CFG_GUI.CFG.getLinkgrabberBottombarPosition()) {
            case NORTH: {
                this.setLayout((LayoutManager)new MigLayout("ins 0, wrap 2", "[grow,fill]" + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + "[fill]0", "[]" + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + "[grow, fill]0[]"));
                break;
            }
            case SOUTH: {
                this.setLayout((LayoutManager)new MigLayout("ins 0, wrap 2", "[grow,fill]" + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + "[fill]0", "[grow, fill]0[]" + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + "[]"));
            }
        }
        if (CFG_GUI.LINKGRABBER_BOTTOMBAR_POSITION.getValue() == GraphicalUserInterfaceSettings.DockingPosition.NORTH) {
            this.add((Component)((Object)this.leftBar), "height 24!");
            this.add((Component)((Object)this.rightBar), "height 24!");
        }
        String constrains = "spanx";
        if (this.widgetContainer == null) {
            this.widgetContainer = new LinkgrabberWidgetContainer(this.table, this.leftBar, this.rightBar);
            this.widgetContainer.relayout();
        }
        if (CFG_GUI.LINKGRABBER_SIDEBAR_VISIBLE.isEnabled()) {
            constrains = "";
            this.add(this.tableScrollPane, "");
            if (this.sidebarContainer == null) {
                this.createSidebar();
            }
            this.add(this.sidebarContainer, "spany 2");
            this.add((Component)((Object)this.widgetContainer));
        } else {
            this.add(this.tableScrollPane, "spanx");
            this.add((Component)((Object)this.widgetContainer), "spanx");
            this.widgetContainer.relayout();
        }
        if (CFG_GUI.LINKGRABBER_BOTTOMBAR_POSITION.getValue() != GraphicalUserInterfaceSettings.DockingPosition.NORTH) {
            this.add((Component)((Object)this.leftBar), "height 24!");
            this.add((Component)((Object)this.rightBar), "height 24!");
        }
    }

    private void createSidebar() {
        this.sidebar = new LinkGrabberSidebar(this, this.table){

            @Override
            protected boolean isScrollbarVisible() {
                return Boolean.TRUE.equals(new EDTHelper<Boolean>(){

                    public Boolean edtRun() {
                        return LinkGrabberPanel.this.sidebarScrollPane != null && LinkGrabberPanel.this.sidebarScrollPane.getVerticalScrollBar().isVisible();
                    }
                }.getReturnValue());
            }
        };
        this.sidebarContainer = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[grow,fill]");
        SwingUtils.setOpaque((JComponent)this.sidebarContainer, (boolean)false);
        this.sidebarScrollPane = new HeaderScrollPane((JComponent)((Object)this.sidebar)){
            private static final long serialVersionUID = 1L;
            {
                this.getVerticalScrollBar().setUnitIncrement(24);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension ret = super.getPreferredSize();
                if (this.getBorder() != null) {
                    Insets borderInsets = this.getBorder().getBorderInsets(LinkGrabberPanel.this.sidebarScrollPane);
                    int scrollbarWidth = this.getVerticalScrollBar().getPreferredSize().width;
                    if (!(MainTabbedPane.getInstance().getSelectedView() instanceof LinkGrabberView)) {
                        int widthWithout;
                        ret.width = widthWithout = ((LinkGrabberPanel)LinkGrabberPanel.this).sidebar.getPreferredSize().width + scrollbarWidth + borderInsets.left + borderInsets.right;
                    }
                }
                return ret;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension pref = this.getPreferredSize();
                pref.height = 0;
                pref.width = 250;
                return pref;
            }
        };
        LAFOptions.getInstance().applyPanelBackground((JComponent)this.sidebarScrollPane);
        this.sidebarScrollPane.setHorizontalScrollBarPolicy(31);
        this.sidebarScrollPane.setVerticalScrollBarPolicy(20);
        this.sidebarScrollPane.setColumnHeaderView((Component)((Object)new LinkGrabberSideBarHeader(this.table)));
        this.sidebarContainer = LAFOptions.getInstance().getExtension().customizeLayoutWrapTitledPanels((JComponent)this.sidebarScrollPane);
    }

    protected void onShow() {
        this.tableModel.recreateModel(false);
        LinkCollector.getInstance().getEventsender().addListener(this);
        this.table.requestFocusInWindow();
        new EDTRunner(){

            protected void runInEDT() {
                if (LinkGrabberPanel.this.widgetContainer != null) {
                    LinkGrabberPanel.this.widgetContainer.refreshAfterTabSwitch();
                }
            }
        };
    }

    protected void onHide() {
        LinkCollector.getInstance().getEventsender().removeListener(this);
        Point point = this.tableScrollPane.getViewport().getViewRect().getLocation();
        CFG_GUI.CFG.setLinkgrabberListScrollPosition(new int[]{this.table.getRowIndexByPoint(point), point.x});
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        if (keyHandler != null && keyHandler == CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE && newValue == Boolean.TRUE) {
            new EDTRunner(){

                protected void runInEDT() {
                    if (LinkGrabberPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                        if (LinkGrabberPanel.this.table.getRowCount() == 0) {
                            if (CFG_GUI.HELP_DIALOGS_ENABLED.isEnabled()) {
                                HelpDialog.show(false, false, null, "propertiespanelvisible", 32, _GUI.T.LinkGrabberPanel_setPropertiesPanelVisible(), _GUI.T.LinkGrabberPanel_setPropertiesPanelVisible_help(), new AbstractIcon("bottombar", 32));
                            }
                        } else {
                            LinkGrabberPanel.this.table.getSelectionModel().setSelectionInterval(0, 0);
                        }
                    }
                }
            }.waitForEDT();
        }
        if (!newValue.booleanValue() && keyHandler == CFG_GUI.LINKGRABBER_SIDEBAR_VISIBLE) {
            JDGui.help((String)_GUI.T.LinkGrabberPanel_onConfigValueModified_title_(), (String)_GUI.T.LinkGrabberPanel_onConfigValueModified_msg_(), (Icon)new AbstractIcon("warning_green", 32));
        }
        this.fireRelayout();
    }

    public void fireRelayout() {
        new EDTRunner(){

            protected void runInEDT() {
                LinkGrabberPanel.this.layoutComponents();
                LinkGrabberPanel.this.revalidate();
            }
        };
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
        this.tableModel.refreshModel(!Queue.QueuePriority.HIGH.equals((Object)event.getPrio()));
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
        this.tableModel.recreateModel(!Queue.QueuePriority.HIGH.equals((Object)event.getPrio()));
    }

    public void onLinkCollectorLinksRemoved(LinkCollectorEvent event) {
        this.tableModel.recreateModel(!Queue.QueuePriority.HIGH.equals((Object)event.getPrio()));
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
        this.tableModel.recreateModel(!Queue.QueuePriority.HIGH.equals((Object)event.getPrio()));
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
    }

    public void onLinkCollectorContentModified(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCrawlerAdded(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStopped(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
    }

    @Override
    public void onLinkCrawlerFinished() {
    }
}

