/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber;

import java.util.Iterator;
import java.util.List;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;
import org.jdownloader.gui.views.components.packagetable.columns.ChecksumColumn;
import org.jdownloader.gui.views.components.packagetable.columns.CommentColumn;
import org.jdownloader.gui.views.components.packagetable.columns.DownloadPasswordColumn;
import org.jdownloader.gui.views.components.packagetable.columns.FileTypeColumn;
import org.jdownloader.gui.views.components.packagetable.columns.HasCaptchaColumn;
import org.jdownloader.gui.views.components.packagetable.columns.LinkIDColumn;
import org.jdownloader.gui.views.downloads.columns.AddedDateColumn;
import org.jdownloader.gui.views.downloads.columns.AvailabilityColumn;
import org.jdownloader.gui.views.downloads.columns.EnabledDisabledColumn;
import org.jdownloader.gui.views.downloads.columns.EnabledFileCountColumn;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.gui.views.downloads.columns.FileCountColumn;
import org.jdownloader.gui.views.downloads.columns.FileSizeColumn;
import org.jdownloader.gui.views.downloads.columns.HosterColumn;
import org.jdownloader.gui.views.downloads.columns.IndexColumn;
import org.jdownloader.gui.views.downloads.columns.ModifiedDateColumn;
import org.jdownloader.gui.views.downloads.columns.PriorityColumn;
import org.jdownloader.gui.views.downloads.columns.SizeColumn;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.gui.views.linkgrabber.columns.DownloadFolderColumn;
import org.jdownloader.gui.views.linkgrabber.columns.PartColumn;
import org.jdownloader.gui.views.linkgrabber.columns.UrlColumn;
import org.jdownloader.gui.views.linkgrabber.columns.VariantColumn;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;

public class LinkGrabberTableModel
extends PackageControllerTableModel<CrawledPackage, CrawledLink> {
    private static final long serialVersionUID = -198189279671615981L;
    private static final LinkGrabberTableModel INSTANCE = new LinkGrabberTableModel();
    private boolean autoConfirm;
    protected FileColumn expandCollapse;
    private PriorityColumn priorityColumn;
    private VariantColumn variantColumn;

    public static LinkGrabberTableModel getInstance() {
        return INSTANCE;
    }

    private LinkGrabberTableModel() {
        super(LinkCollector.getInstance(), "LinkGrabberTableModel");
    }

    public List<AbstractNode> refreshSort(List<AbstractNode> data) {
        try {
            List list = super.refreshSort(data);
            return list;
        }
        finally {
            if (!this.isTristateSorterEnabled()) {
                this.sortColumn = null;
            }
        }
    }

    @Override
    protected int[] getScrollPositionFromConfig() {
        return CFG_GUI.CFG.getLinkgrabberListScrollPosition();
    }

    @Override
    public List<AbstractNode> sort(List<AbstractNode> data, ExtColumn<AbstractNode> column) {
        boolean autoConfirm;
        PackageControllerTableModelData ret = (PackageControllerTableModelData)super.sort(data, column);
        boolean bl = autoConfirm = ret.size() > 0 && CFG_LINKGRABBER.LINKGRABBER_AUTO_CONFIRM_ENABLED.isEnabled();
        if (!autoConfirm) {
            Iterator it = ret.getVisibleChildrenIterator();
            while (it.hasNext()) {
                CrawledLink next = (CrawledLink)it.next();
                if (!next.isAutoConfirmEnabled() || next.getLinkState() == AvailableLinkState.OFFLINE) continue;
                autoConfirm = true;
                break;
            }
        }
        this.autoConfirm = autoConfirm;
        return ret;
    }

    public boolean isAutoConfirm() {
        return this.autoConfirm;
    }

    @Override
    protected void initColumns() {
        this.expandCollapse = new FileColumn();
        this.addColumn((ExtColumn)this.expandCollapse);
        this.variantColumn = new VariantColumn(((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).isVariantsColumnAlwaysVisible());
        this.addColumn((ExtColumn)this.variantColumn);
        this.addColumn((ExtColumn)new PartColumn());
        this.addColumn((ExtColumn)new UrlColumn());
        this.addColumn((ExtColumn)new DownloadFolderColumn());
        this.addColumn((ExtColumn)new DownloadPasswordColumn());
        this.addColumn((ExtColumn)new EnabledDisabledColumn());
        this.addColumn(new SizeColumn());
        this.addColumn(new HosterColumn());
        this.addColumn((ExtColumn)new AvailabilityColumn(){

            @Override
            public boolean isDefaultVisible() {
                return true;
            }
        });
        this.priorityColumn = new PriorityColumn();
        this.addColumn((ExtColumn)this.priorityColumn);
        this.addColumn((ExtColumn)new CommentColumn(){

            public boolean isDefaultVisible() {
                return false;
            }
        });
        if (!Application.isJared(null)) {
            this.addColumn((ExtColumn)new LinkIDColumn());
        }
        this.addColumn((ExtColumn)new AddedDateColumn());
        this.addColumn((ExtColumn)new ModifiedDateColumn());
        this.addColumn((ExtColumn)new ChecksumColumn());
        this.addColumn((ExtColumn)new FileTypeColumn());
        this.addColumn((ExtColumn)new HasCaptchaColumn());
        this.addColumn(new FileSizeColumn());
        this.addColumn(new FileCountColumn());
        this.addColumn(new EnabledFileCountColumn());
        this.addColumn((ExtColumn)new IndexColumn(LinkCollector.getInstance()));
    }

    @Override
    protected void setVariantsSupport(final boolean vs) {
        new EDTRunner(){

            protected void runInEDT() {
                LinkGrabberTableModel.this.setVariantsColumnVisible(vs);
            }
        };
    }

    public void setColumnVisible(ExtColumn<AbstractNode> column, boolean visible) {
        try {
            this.getTable().getStorage().put(this.getTable().getColumnStoreKey("VISABLE_COL_", column.getID()), Boolean.valueOf(visible));
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
        }
        this.getTable().updateColumns();
    }

    public void setVariantsColumnVisible(boolean b) {
        if (this.variantColumn != null && this.variantColumn.setAutoVisible(b)) {
            this.getTable().updateColumns();
        }
    }

    public void setPriorityColumnVisible(boolean b) {
        if (this.priorityColumn != null) {
            this.setColumnVisible((ExtColumn<AbstractNode>)this.priorityColumn, b);
        }
    }
}

