/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;

public abstract class AbstractMergeSameNamedPackagesAction<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends CustomizableTableContextAppAction<PackageType, ChildrenType>
implements ActionContext {
    private boolean caseInsensitive = true;
    private static final long serialVersionUID = -1758454550263991987L;

    public static String getTranslationForMatchPackageNamesCaseInsensitive() {
        return _GUI.T.MergeSameNamedPackagesAction_Case_Insensitive();
    }

    @Customizer(link="#getTranslationForMatchPackageNamesCaseInsensitive")
    public boolean isMatchPackageNamesCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setMatchPackageNamesCaseInsensitive(boolean val) {
        this.caseInsensitive = val;
    }

    public AbstractMergeSameNamedPackagesAction() {
        super(true, true);
        this.setName(_GUI.T.MergeSameNamedPackagesAction_());
        this.setIconKey("remove_dupes");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        final SelectionInfo sel = this.getSelection();
        final PackageController controller = sel.getController();
        controller.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                Map<String, List<Object>> dupes;
                boolean caseInsensitive = AbstractMergeSameNamedPackagesAction.this.isMatchPackageNamesCaseInsensitive();
                List selPackageViews = sel.getPackageViews();
                if (sel != null && selPackageViews.size() > 0) {
                    ArrayList selectedPackages = new ArrayList();
                    for (SelectionInfo.PackageView pv : selPackageViews) {
                        Object selectedpackage = pv.getPackage();
                        selectedPackages.add(selectedpackage);
                    }
                    if (selectedPackages.isEmpty()) {
                        return null;
                    }
                    dupes = controller.getPackagesWithSameName(selectedPackages, caseInsensitive);
                } else {
                    dupes = controller.getPackagesWithSameName(caseInsensitive);
                }
                if (dupes.isEmpty()) {
                    return null;
                }
                for (Map.Entry entry : dupes.entrySet()) {
                    List thisdupes = entry.getValue();
                    if (thisdupes.size() == 1) continue;
                    AbstractPackageNode target = (AbstractPackageNode)thisdupes.remove(0);
                    PackageController.MergePackageSettings mergesettings = new PackageController.MergePackageSettings();
                    mergesettings.setMergePackageComments(true);
                    controller.merge(target, thisdupes, mergesettings);
                }
                return null;
            }
        });
    }

    public boolean isEnabled() {
        SelectionInfo sel = this.getSelection();
        if (sel == null) {
            return false;
        }
        PackageController controller = sel.getController();
        if (controller == null || controller.getPackages() == null || controller.getPackages().size() == 0) {
            return false;
        }
        return super.isEnabled();
    }
}

