/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.addlinksdialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.CrawledLinkModifiers;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.modifier.CommentModifier;
import jd.controlling.linkcrawler.modifier.DownloadFolderModifier;
import jd.controlling.linkcrawler.modifier.PackageNameModifier;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.VariableAction;
import jd.parser.html.HTMLParser;
import jd.plugins.DownloadLink;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.pathchooser.PathChooser;
import org.appwork.swing.components.searchcombo.SearchComboBox;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberRelativeDialogLocator;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.PasswordUtils;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.packagehistorycontroller.PackageHistoryEntry;
import org.jdownloader.gui.packagehistorycontroller.PackageHistoryManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.DownloadFolderChooserDialog;
import org.jdownloader.gui.views.linkgrabber.actions.AddLinksAction;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.ConfirmOptionsAction;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.DragAndDropDelegater;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.updatev2.gui.LAFOptions;

public class AddLinksDialog
extends AbstractDialog<LinkCollectingJob> {
    private ExtTextArea input;
    private PathChooser destination;
    private SearchComboBox<PackageHistoryEntry> packagename;
    private JScrollPane sp;
    private LinkgrabberSettings config;
    private ExtTextField password;
    private ExtCheckBox extractToggle;
    private AddLinksAction.EnableDisableUnchanged autoStart = AddLinksAction.EnableDisableUnchanged.UNCHANGED;
    private AddLinksAction.EnableDisableUnchanged autoConfirm = AddLinksAction.EnableDisableUnchanged.UNCHANGED;
    private JButton confirmOptions;
    private boolean deepAnalyse = false;
    private DelayedRunnable delayedValidate;
    private ExtTextField downloadPassword;
    private JComboBox priority;
    private final HashSet<String> autoPasswords = new HashSet();
    private ExtTextField comment;
    private JCheckBox overwritePackagizer;
    private boolean hasUserClickedOverwritePackagizerButton = false;
    private final boolean packagizerAutoModeEnabled;
    private final AtomicReference<Thread> asyncImportThread = new AtomicReference();

    protected void _init() {
        super._init();
        this.autoTogglePackagizerCheckbox();
    }

    public AddLinksAction.EnableDisableUnchanged getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(AddLinksAction.EnableDisableUnchanged autoStart) {
        this.autoStart = autoStart;
    }

    public AddLinksAction.EnableDisableUnchanged getAutoConfirm() {
        return this.autoConfirm;
    }

    public void setAutoConfirm(AddLinksAction.EnableDisableUnchanged autoConfirm) {
        this.autoConfirm = autoConfirm;
    }

    public boolean isDeepAnalyse() {
        return this.deepAnalyse;
    }

    public void setDeepAnalyse(boolean deepAnalyse) {
        this.deepAnalyse = deepAnalyse;
    }

    public AddLinksDialog() {
        super(8, _GUI.T.AddLinksDialog_AddLinksDialog_(), null, _GUI.T.AddLinksDialog_AddLinksDialog_confirm(), null);
        this.config = (LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class);
        this.packagizerAutoModeEnabled = this.config.isAddLinksOverridePackagizerCheckboxAutoModeEnabled();
        String dialog_id = "AddLinksDialog";
        this.delayedValidate = new DelayedRunnable(500L, 10000L){

            public String getID() {
                return "AddLinksDialog";
            }

            public void delayedrun() {
                if (AddLinksDialog.this.config.getAddLinksDialogCheck()) {
                    AddLinksDialog.this.validateForm();
                }
            }
        };
        this.setPreferredWidth(700);
        this.setPreferredHeight(300);
        this.setLocator((DialogLocator)new RememberRelativeDialogLocator("AddLinksDialog", (Window)JDGui.getInstance().getMainFrame()));
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension("AddLinksDialog"));
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    protected MigPanel createBottomPanel() {
        MigPanel ret = new MigPanel("ins 0", "[][][][]20[grow,fill][]", "[]");
        JLabel lbl = new JLabel(_GUI.T.AddLinksDialog_getDefaultButtonPanel_overwrite_packagizer());
        this.overwritePackagizer = new JCheckBox();
        this.overwritePackagizer.setSelected(CFG_LINKGRABBER.CFG.isAddLinksDialogOverwritesPackagizerRulesEnabled());
        this.overwritePackagizer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddLinksDialog.this.hasUserClickedOverwritePackagizerButton = true;
            }
        });
        ret.add((Component)new JLabel(new AbstractIcon("upload", 22)), (Object)"gapleft 5");
        ret.add((Component)this.overwritePackagizer, (Object)"gapleft 0");
        ret.add((Component)lbl);
        return ret;
    }

    public boolean isOverwritePackagizerEnabled() {
        return this.overwritePackagizer.isSelected();
    }

    protected void setReturnmask(boolean b) {
        super.setReturnmask(b);
        if (b && this.hasUserClickedOverwritePackagizerButton) {
            CFG_LINKGRABBER.CFG.setAddLinksDialogOverwritesPackagizerRulesEnabled(this.overwritePackagizer.isSelected());
        }
    }

    protected DefaultButtonPanel getDefaultButtonPanel() {
        DefaultButtonPanel ret = new DefaultButtonPanel("ins 0 0 0 0", "[grow,fill]0[][]", "0[fill]0");
        this.confirmOptions = new JButton(new ConfirmOptionsAction(this.okButton, this)){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x - 1, y, width + 1, height);
            }
        };
        this.getDialog().getRootPane().setDefaultButton(this.okButton);
        this.okButton.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JButton defaultButton;
                JRootPane root;
                if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                    root.setDefaultButton(defaultButton);
                }
            }
        });
        ret.add((Component)this.okButton, (Object)"alignx right,sizegroup confirms,growx,pushx");
        ret.add((Component)this.confirmOptions, (Object)"width 12!");
        return ret;
    }

    public void dispose() {
        try {
            if (this.isInitialized() && this.destination != null) {
                String finalDestination;
                String string = finalDestination = this.destination.getFile() != null ? this.destination.getFile().getAbsolutePath() : null;
                if (StringUtils.isNotEmpty((String)finalDestination)) {
                    DownloadPathHistoryManager.getInstance().add(finalDestination);
                }
            }
        }
        finally {
            super.dispose();
        }
    }

    protected LinkCollectingJob createReturnValue() {
        BooleanStatus extractAfterDownload;
        String passwordTxt;
        AddLinksAction.EnableDisableUnchanged as;
        AddLinksAction.EnableDisableUnchanged ac;
        Priority finalPriority;
        String finalDownloadPassword;
        String finalDestination;
        String finalComment;
        LinkCollectingJob job = new LinkCollectingJob(LinkOrigin.ADD_LINKS_DIALOG.getLinkOriginDetails(), this.input.getText());
        job.setDeepAnalyse(this.isDeepAnalyse());
        ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
        ArrayList<CrawledLinkModifier> requiredPreModifiers = new ArrayList<CrawledLinkModifier>();
        final boolean overwritePackagizerRules = this.isOverwritePackagizerEnabled();
        String finalPackageName = this.getPackageName();
        if (StringUtils.isNotEmpty((String)finalPackageName)) {
            PackageHistoryManager.getInstance().add(finalPackageName);
            PackageNameModifier mod = new PackageNameModifier(finalPackageName, overwritePackagizerRules);
            modifiers.add(mod);
            requiredPreModifiers.add(mod);
        }
        if (StringUtils.isNotEmpty((String)(finalComment = this.getComment()))) {
            modifiers.add(new CommentModifier(finalComment));
        }
        if (StringUtils.isNotEmpty((String)(finalDestination = this.getDestination()))) {
            modifiers.add(new DownloadFolderModifier(finalDestination, overwritePackagizerRules));
        }
        if (StringUtils.isNotEmpty((String)(finalDownloadPassword = this.getDownloadPassword()))) {
            job.setCrawlerPassword(finalDownloadPassword);
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    DownloadLink dlLink = link.getDownloadLink();
                    if (dlLink != null && (overwritePackagizerRules || StringUtils.isEmpty((String)dlLink.getDownloadPassword()))) {
                        dlLink.setDownloadPassword(finalDownloadPassword);
                        return true;
                    }
                    return false;
                }
            });
        }
        if ((finalPriority = this.getPriority()) != null && !Priority.DEFAULT.equals((Object)finalPriority)) {
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.setPriority(finalPriority);
                    return true;
                }
            });
        }
        if ((ac = this.getAutoConfirm()) != null && ac != AddLinksAction.EnableDisableUnchanged.UNCHANGED) {
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.setAutoConfirmEnabled(ac == AddLinksAction.EnableDisableUnchanged.ENABLED);
                    return true;
                }
            });
        }
        if ((as = this.getAutoStart()) != null && as != AddLinksAction.EnableDisableUnchanged.UNCHANGED) {
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.setAutoStartEnabled(as == AddLinksAction.EnableDisableUnchanged.ENABLED);
                    return true;
                }
            });
        }
        if (StringUtils.isNotEmpty((String)(passwordTxt = this.password.getText()))) {
            HashSet<String> passwords = (HashSet<String>)JSonStorage.restoreFromString((String)passwordTxt, (TypeRef)new TypeRef<HashSet<String>>(){}, new HashSet());
            if (passwords == null || passwords.size() == 0) {
                passwords = new HashSet<String>();
                passwords.add(passwordTxt.trim());
            }
            final HashSet<String> finalPasswords = passwords;
            job.setArchivPasswords(new ArrayList<String>(passwords));
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.getArchiveInfo().getExtractionPasswords().addAll(finalPasswords);
                    return true;
                }
            });
        }
        BooleanStatus booleanStatus = extractAfterDownload = this.extractToggle.isSelected() ? BooleanStatus.TRUE : BooleanStatus.FALSE;
        if (BooleanStatus.isSet((BooleanStatus)extractAfterDownload)) {
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.getArchiveInfo().setAutoExtract(extractAfterDownload);
                    return true;
                }
            });
        }
        if (modifiers.size() > 0) {
            if (overwritePackagizerRules) {
                job.addPrePackagizerModifier(new CrawledLinkModifiers(requiredPreModifiers));
                job.addPostPackagizerModifier(new CrawledLinkModifiers(modifiers));
            } else {
                job.addPrePackagizerModifier(new CrawledLinkModifiers(modifiers));
            }
        }
        return job;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    public String getPackageName() {
        return this.packagename.getText().trim();
    }

    public String getComment() {
        return ((String)new EDTHelper<String>(){

            public String edtRun() {
                return AddLinksDialog.this.comment.getText();
            }
        }.getReturnValue()).trim();
    }

    public String getDestination() {
        return this.destination.getFile() != null ? this.destination.getFile().getAbsolutePath() : null;
    }

    public String getDownloadPassword() {
        return this.downloadPassword.getText();
    }

    public Priority getPriority() {
        return (Priority)((Object)this.priority.getSelectedItem());
    }

    public JComponent layoutDialogContent() {
        this.destination = new PathChooser("ADDLinks", true){
            {
                this.txt.setDragEnabled(true);
            }

            protected void onChanged(ExtTextField txt2) {
                AddLinksDialog.this.delayedValidate.run();
                File file = this.getFile();
                if (file == null) {
                    return;
                }
            }

            public JPopupMenu getPopupMenu(ExtTextField txt, AbstractAction cutAction, AbstractAction copyAction, AbstractAction pasteAction, AbstractAction deleteAction, AbstractAction selectAction) {
                JPopupMenu menu = new JPopupMenu();
                menu.add((Action)new VariableAction((JTextComponent)txt, _GUI.T.PackagizerFilterRuleDialog_createVariablesMenu_date(), "<jd:simpledate:dd.MM.yyyy>"));
                menu.add((Action)new VariableAction((JTextComponent)txt, _GUI.T.PackagizerFilterRuleDialog_createVariablesMenu_packagename(), "<jd:packagename>"));
                return menu;
            }

            public File doFileChooser() {
                try {
                    return DownloadFolderChooserDialog.open(this.getFile(), true, this.getDialogTitle());
                }
                catch (DialogClosedException e) {
                    e.printStackTrace();
                }
                catch (DialogCanceledException e) {
                    e.printStackTrace();
                }
                return null;
            }

            protected String getProtoType(SearchComboBox<String> comboBox, List<String> model) {
                return "";
            }

            protected String getHelpText() {
                return _GUI.T.AddLinksDialog_layoutDialogContent_help_destination();
            }
        };
        this.packagename = new SearchComboBox<PackageHistoryEntry>(){

            protected boolean isSearchCaseSensitive() {
                return true;
            }

            protected Icon getIconForValue(PackageHistoryEntry value) {
                return null;
            }

            public PackageHistoryEntry getProtoType(List<PackageHistoryEntry> model) {
                PackageHistoryEntry ret = new PackageHistoryEntry("");
                return ret;
            }

            public JTextField createTextField() {
                JTextField ret = super.createTextField();
                ret.setDragEnabled(true);
                return ret;
            }

            protected String getTextForValue(PackageHistoryEntry value) {
                return value == null ? null : value.getName();
            }

            public void onChanged() {
                AddLinksDialog.this.autoTogglePackagizerCheckbox();
            }
        };
        this.packagename.setBadColor(null);
        this.packagename.setList(PackageHistoryManager.getInstance().list());
        this.packagename.setUnkownTextInputAllowed(true);
        this.packagename.setHelpText(_GUI.T.AddLinksDialog_layoutDialogContent_packagename_help());
        this.packagename.setSelectedItem(null);
        this.comment = new ExtTextField(){

            public void onChanged() {
                AddLinksDialog.this.autoTogglePackagizerCheckbox();
            }
        };
        this.comment.setDragEnabled(true);
        this.comment.setHelpText(_GUI.T.AddLinksDialog_layoutDialogContent_comment_help());
        this.comment.setBorder((Border)BorderFactory.createCompoundBorder(this.comment.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        String defaultFolder = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder();
        this.destination.setQuickSelectionList(DownloadPathHistoryManager.getInstance().listPaths(defaultFolder));
        this.destination.setFile(new File(this.getDownloadDestinationFieldDefaultValue()));
        this.input = new ExtTextArea(){
            {
                final 16 textArea = this;
                this.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyChar() == '\t') {
                            if (e.isShiftDown()) {
                                textArea.transferFocusBackward();
                            } else {
                                textArea.transferFocus();
                            }
                            e.consume();
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }
                });
            }

            public void onChanged() {
                AddLinksDialog.this.delayedValidate.run();
            }
        };
        this.input.setWrapStyleWord(true);
        this.input.setHelpText(_GUI.T.AddLinksDialog_layoutDialogContent_input_help());
        this.input.setDragEnabled(true);
        this.sp = new JScrollPane((Component)this.input);
        this.sp.setViewportBorder(BorderFactory.createEmptyBorder(2, 6, 1, 6));
        this.password = new ExtTextField(){

            public void onChanged() {
                AddLinksDialog.this.autoTogglePackagizerCheckbox();
            }
        };
        this.password.setDragEnabled(true);
        this.password.setHelpText(_GUI.T.AddLinksDialog_createExtracOptionsPanel_password());
        this.password.setBorder((Border)BorderFactory.createCompoundBorder(this.password.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.priority = new JComboBox<Priority>(Priority.values());
        final ListCellRenderer org = this.priority.getRenderer();
        this.priority.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel r = (JLabel)org.getListCellRendererComponent(list, ((Priority)((Object)value)).T(), index, isSelected, cellHasFocus);
                r.setIcon(((Priority)((Object)value)).loadIcon(20));
                return r;
            }
        });
        this.priority.setSelectedItem((Object)this.getPriorityFieldDefaultValue());
        if (this.packagizerAutoModeEnabled) {
            this.priority.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLinksDialog.this.autoTogglePackagizerCheckbox();
                }
            });
        }
        this.downloadPassword = new ExtTextField();
        this.downloadPassword.setDragEnabled(true);
        this.downloadPassword.setHelpText(_GUI.T.AddLinksDialog_createExtracOptionsPanel_downloadpassword());
        this.downloadPassword.setBorder((Border)BorderFactory.createCompoundBorder(this.downloadPassword.getBorder(), BorderFactory.createEmptyBorder(2, 6, 1, 6)));
        this.extractToggle = new ExtCheckBox(new JComponent[0]);
        this.extractToggle.setSelected(this.getAutoExtractionFieldDefaultValue());
        this.extractToggle.setToolTipText(_GUI.T.AddLinksDialog_layoutDialogContent_autoextract_tooltip());
        if (this.packagizerAutoModeEnabled) {
            this.extractToggle.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AddLinksDialog.this.autoTogglePackagizerCheckbox();
                }
            });
        }
        int height = Math.max(24, (int)((double)this.comment.getPreferredSize().height * 0.9));
        MigPanel p = new MigPanel("ins 0 0 3 0,wrap 3", "[][grow,fill][]", "[fill,grow][grow," + height + "!][grow," + height + "!][grow," + height + "!][grow," + height + "!]");
        p.add((Component)new JLabel(new AbstractIcon("linkgrabber", 32)), (Object)"aligny top,height 32!,width 32!");
        p.add((Component)this.sp, (Object)"height 30:100:n,spanx");
        p.add(this.createIconLabel("save", _GUI.T.AddLinksDialog_layoutDialogContent_save_tt()), (Object)("aligny center,width 32!,height " + height + "!"));
        p.add((Component)this.destination.getDestination(), (Object)("height " + height + "!"));
        p.add((Component)this.destination.getButton(), (Object)("sg right,height " + height + "!"));
        p.add(this.createIconLabel("package_open", _GUI.T.AddLinksDialog_layoutDialogContent_package_tt()), (Object)"aligny center,width 32!");
        p.add(this.packagename, (Object)("spanx,height " + height + "!"));
        p.add(this.createIconLabel("document", _GUI.T.AddLinksDialog_layoutDialogContent_comment_tt()), (Object)"aligny center,width 32!");
        p.add((Component)this.comment, (Object)("spanx,height " + height + "!"));
        p.add(this.createIconLabel((Icon)new ExtMergedIcon((Icon)new AbstractIcon("extract", 24)).add((Icon)new AbstractIcon("lock", 18), 6, 6), _GUI.T.AddLinksDialog_layoutDialogContent_downloadpassword_tt()), (Object)("aligny center,height " + height + "!,width 32!"));
        p.add((Component)this.password, (Object)("pushx,growx,height " + height + "!"));
        MigPanel subpanel = new MigPanel("ins 0", "[grow,fill][]", "[" + height + "!,grow]");
        p.add((Component)subpanel, (Object)"sg right");
        JLabel lbl = new JLabel(_GUI.T.AddLinksDialog_layoutDialogContent_autoextract_lbl());
        subpanel.add((Component)lbl);
        lbl.setHorizontalAlignment(4);
        subpanel.add((Component)this.extractToggle, (Object)"aligny center");
        p.add(this.createIconLabel((Icon)((Object)new BadgeIcon("password", "download", 24)), _GUI.T.AddLinksDialog_layoutDialogContent_downloadpassword_tt()), (Object)"aligny center,width 32!");
        p.add((Component)this.downloadPassword);
        p.add((Component)this.priority, (Object)"sg right");
        this.input.setTransferHandler((TransferHandler)new DragAndDropDelegater((JComponent)this.input));
        this.getDialog().addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                Thread thread = new Thread(){
                    {
                        this.setDaemon(true);
                        this.setName(this.getClass().getName());
                    }

                    @Override
                    public void run() {
                        ClipboardMonitoring clp;
                        AddLinksDialog.this.inform();
                        String textAuto = AddLinksDialog.this.config.getPresetDebugLinks();
                        if (textAuto != null && textAuto.startsWith("\"") && textAuto.endsWith("\"")) {
                            try {
                                String result = (String)JSonStorage.restoreFromString((String)textAuto, (TypeRef)TypeRef.STRING);
                                if (result != null) {
                                    textAuto = result;
                                }
                            }
                            catch (Exception e) {
                                LogController.CL().log((Throwable)e);
                            }
                        }
                        ClipboardMonitoring.ClipboardContent clipboardContent = null;
                        if (AddLinksDialog.this.config.isAutoFillAddLinksDialogWithClipboardContentEnabled() && StringUtils.isEmpty((String)textAuto) && (clipboardContent = (clp = ClipboardMonitoring.getINSTANCE()).getCurrentContent()) != null) {
                            textAuto = clipboardContent.getContent();
                        }
                        new EDTRunner(){

                            protected void runInEDT() {
                                AddLinksDialog.this.input.setEditable(false);
                                AddLinksDialog.this.input.setText(_GUI.T.AddLinksDialog_ParsingClipboard());
                            }
                        };
                        AddLinksDialog.this.asyncAnalyse(textAuto, clipboardContent);
                    }
                };
                thread.start();
                AddLinksDialog.this.getDialog().removeWindowListener((WindowListener)this);
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        return p;
    }

    private String getDownloadDestinationFieldDefaultValue() {
        String defaultFolder = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder();
        String latest = this.config.getLatestDownloadDestinationFolder();
        if (this.config.isUseLastDownloadDestinationAsDefault() && !StringUtils.isEmpty((String)latest)) {
            return latest;
        }
        return defaultFolder;
    }

    private boolean getAutoExtractionFieldDefaultValue() {
        return this.config.isAutoExtractionEnabled();
    }

    private Priority getPriorityFieldDefaultValue() {
        return Priority.DEFAULT;
    }

    private Component createIconLabel(Icon add, String tooltip) {
        JLabel ret = new JLabel(add);
        ret.setToolTipText(tooltip);
        return ret;
    }

    protected JButton createOkButton() {
        return new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setName(AddLinksDialog.this.okButtonText);
            }

            public void actionPerformed(ActionEvent e) {
            }
        })){

            public int getTooltipDelay(Point mousePositionOnScreen) {
                return 500;
            }

            public boolean isTooltipWithoutFocusEnabled() {
                return super.isTooltipWithoutFocusEnabled();
            }
        };
    }

    protected void validateForm() {
        AtomicBoolean fastContainsLinksFlag;
        block3: {
            if (this.input == null) {
                return;
            }
            String text = (String)new EDTHelper<String>(){

                public String edtRun() {
                    return AddLinksDialog.this.input.getText();
                }
            }.getReturnValue();
            fastContainsLinksFlag = new AtomicBoolean(false);
            try {
                HTMLParser.getHttpLinks(text, null, new HTMLParser.HtmlParserResultSet(){

                    @Override
                    public boolean add(HTMLParser.HtmlParserCharSequence e) {
                        if (e != null) {
                            fastContainsLinksFlag.set(true);
                            throw new RuntimeException("abort");
                        }
                        return false;
                    }
                });
            }
            catch (Throwable ignore) {
                if (fastContainsLinksFlag.get()) break block3;
                LogController.CL().log(ignore);
            }
        }
        new EDTRunner(){

            protected void runInEDT() {
                if (fastContainsLinksFlag.get()) {
                    AddLinksDialog.this.okButton.setToolTipText("");
                    AddLinksDialog.this.input.setToolTipText(null);
                    AddLinksDialog.this.okButton.setEnabled(true);
                    AddLinksDialog.this.confirmOptions.setEnabled(true);
                } else {
                    AddLinksDialog.this.okButton.setToolTipText(_GUI.T.AddLinksDialog_validateForm_input_missing());
                    AddLinksDialog.this.input.setToolTipText(_GUI.T.AddLinksDialog_validateForm_input_missing());
                    AddLinksDialog.this.okButton.setEnabled(false);
                    AddLinksDialog.this.confirmOptions.setEnabled(false);
                }
                File dest = AddLinksDialog.this.destination.getFile();
                if (dest == null || !AddLinksDialog.this.validateFolder(dest.getAbsolutePath())) {
                    String toolTip = AddLinksDialog.this.okButton.getToolTipText();
                    if (toolTip == null || toolTip.length() == 0) {
                        AddLinksDialog.this.okButton.setToolTipText(_GUI.T.AddLinksDialog_validateForm_folder_invalid_missing());
                    }
                    AddLinksDialog.this.okButton.setEnabled(false);
                    AddLinksDialog.this.destination.setToolTipText(_GUI.T.AddLinksDialog_validateForm_folder_invalid_missing());
                    AddLinksDialog.this.confirmOptions.setEnabled(false);
                    AddLinksDialog.this.destination.getTxt().setForeground(LAFOptions.getInstance().getColorForErrorForeground());
                } else {
                    AddLinksDialog.this.destination.setToolTipText(null);
                    AddLinksDialog.this.destination.getTxt().setForeground(null);
                }
                if (AddLinksDialog.this.okButton.isEnabled() && AddLinksDialog.this.cancelButton.hasFocus()) {
                    AddLinksDialog.this.okButton.requestFocus();
                }
            }
        };
    }

    private boolean validateFolder(String text) {
        if (text == null) {
            return false;
        }
        File file = new File(text);
        if (file.isDirectory() && file.exists()) {
            return true;
        }
        for (int threshold = this.config.getMissingParentDirectoryThreshold(); threshold > 0; --threshold) {
            File parent = file.getParentFile();
            if (parent == null) {
                return false;
            }
            if (parent.exists()) {
                return true;
            }
            file = parent;
        }
        return false;
    }

    private void inform() {
        new Thread(){
            {
                this.setDaemon(true);
                this.setName(this.getClass().getName());
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                new EDTRunner(){

                    protected void runInEDT() {
                        if (AddLinksDialog.this.input.isShowing() && CFG_GUI.HELP_DIALOGS_ENABLED.isEnabled()) {
                            HelpDialog.show(Boolean.FALSE, Boolean.TRUE, new Point(((AddLinksDialog)AddLinksDialog.this).input.getLocationOnScreen().x + AddLinksDialog.this.input.getWidth() / 2, ((AddLinksDialog)AddLinksDialog.this).input.getLocationOnScreen().y + 10), null, 32, _GUI.T.AddLinksDialog_AddLinksDialog_(), _GUI.T.AddLinksDialog_layoutDialogContent_description(), new AbstractIcon("linkgrabber", 32));
                        }
                    }
                };
            }
        }.start();
    }

    public void pack() {
        this.getDialog().pack();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void asyncAnalyse(final String textAuto, final ClipboardMonitoring.ClipboardContent clipboardContent) {
        Thread thread = new Thread(){
            private Thread thisThread = null;
            {
                this.setDaemon(true);
                this.setName(this.getClass().getName());
            }

            @Override
            public void run() {
                try {
                    this.thisThread = Thread.currentThread();
                    String resultText = this.processTextAuto(textAuto, clipboardContent);
                    this.updateUIWithResult(resultText);
                }
                catch (Throwable e) {
                    if (this.thisThread == AddLinksDialog.this.asyncImportThread.get()) {
                        LogController.CL().log(e);
                    }
                }
                finally {
                    AddLinksDialog.this.asyncImportThread.compareAndSet(Thread.currentThread(), null);
                }
            }

            private String processTextAuto(String textAuto2, ClipboardMonitoring.ClipboardContent clipboardContent2) {
                if (textAuto2 == null) {
                    return "";
                }
                textAuto2 = textAuto2.replaceAll("\r(!\n)", "\r\n");
                if (AddLinksDialog.this.config.isAddLinksPreParserAutoExtractionPasswordSearchEnabled()) {
                    this.processPasswordExtraction(textAuto2, clipboardContent2);
                }
                if (!AddLinksDialog.this.config.isAddLinksPreParserEnabled()) {
                    return textAuto2;
                }
                return this.extractLinksFromText(textAuto2, clipboardContent2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void processPasswordExtraction(String textAuto2, ClipboardMonitoring.ClipboardContent clipboardContent2) {
                HashSet<String> passwords = PasswordUtils.getPasswords(clipboardContent2 != null ? clipboardContent2.getContentText() : null);
                if (passwords == null || passwords.isEmpty()) {
                    passwords = PasswordUtils.getPasswords(textAuto2);
                }
                if (passwords == null || passwords.size() == 0) {
                    return;
                }
                HashSet hashSet = AddLinksDialog.this.autoPasswords;
                synchronized (hashSet) {
                    AddLinksDialog.this.autoPasswords.addAll(passwords);
                }
                this.updatePasswordUI();
            }

            private void updatePasswordUI() {
                new EDTRunner(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void runInEDT() {
                        HashSet hashSet = AddLinksDialog.this.autoPasswords;
                        synchronized (hashSet) {
                            if (AddLinksDialog.this.autoPasswords.size() > 1) {
                                AddLinksDialog.this.password.setText(JSonStorage.serializeToJson((Object)AddLinksDialog.this.autoPasswords));
                            } else if (AddLinksDialog.this.autoPasswords.size() > 0) {
                                AddLinksDialog.this.password.setText(AddLinksDialog.this.autoPasswords.toArray(new String[0])[0]);
                            }
                        }
                    }
                };
            }

            private String extractLinksFromText(String textAuto2, ClipboardMonitoring.ClipboardContent clipboardContent2) {
                String base;
                String parseTextAuto = AddLinksDialog.this.preprocessFind(textAuto2);
                Object[] result = this.tryExtractLinks(parseTextAuto, base = clipboardContent2 != null ? clipboardContent2.getBrowserURL() : null);
                if (result.length > 0) {
                    return StringUtils.join((Object[])result, (String)"\r\n");
                }
                result = this.tryExtractLinks(parseTextAuto.replace("www.", "https://www."), base);
                if (result.length > 0) {
                    return StringUtils.join((Object[])result, (String)"\r\n");
                }
                result = this.tryExtractLinks("https://" + parseTextAuto, base);
                return StringUtils.join((Object[])result, (String)"\r\n");
            }

            private String[] tryExtractLinks(String text, String base) {
                return HTMLParser.getHttpLinks(text, base, new HTMLParser.HtmlParserResultSet(){

                    @Override
                    public boolean add(HTMLParser.HtmlParserCharSequence e) {
                        if (thisThread != AddLinksDialog.this.asyncImportThread.get()) {
                            throw new RuntimeException("abort");
                        }
                        return super.add(e);
                    }
                });
            }

            private void updateUIWithResult(final String resultText) {
                new EDTRunner(){

                    protected void runInEDT() {
                        if (thisThread == AddLinksDialog.this.asyncImportThread.get()) {
                            AddLinksDialog.this.input.setText(resultText);
                            AddLinksDialog.this.input.setEditable(true);
                        }
                    }
                }.waitForEDT();
            }
        };
        this.asyncImportThread.set(thread);
        thread.start();
    }

    private void autoTogglePackagizerCheckbox() {
        if (this.overwritePackagizer == null) {
            return;
        }
        if (!this.packagizerAutoModeEnabled) {
            return;
        }
        if (this.hasUserClickedOverwritePackagizerButton) {
            return;
        }
        boolean hasCustomValueFlag = false;
        hasCustomValueFlag = hasCustomValueFlag || !StringUtils.isEmpty((String)this.getComment());
        hasCustomValueFlag = hasCustomValueFlag || !StringUtils.isEmpty((String)this.getPackageName());
        hasCustomValueFlag = hasCustomValueFlag || !StringUtils.isEmpty((String)this.getDownloadPassword());
        hasCustomValueFlag = hasCustomValueFlag || this.getPriority() != this.getPriorityFieldDefaultValue();
        hasCustomValueFlag = hasCustomValueFlag || this.extractToggle != null && this.extractToggle.isSelected() != this.getAutoExtractionFieldDefaultValue();
        this.overwritePackagizer.setSelected(hasCustomValueFlag);
    }

    private Component createIconLabel(String iconKey, String tooltip) {
        JLabel ret = new JLabel(new AbstractIcon(iconKey, 24));
        ret.setToolTipText(tooltip);
        return ret;
    }

    protected String preprocessFind(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        return new LinkCrawler(false, false).preprocessFind(text, null, false);
    }
}

