/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.addlinksdialog;

import java.util.List;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.MultiLineString;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.packagizer.SubFolderByPackageRule;
import org.jdownloader.gui.packagehistorycontroller.DownloadPath;
import org.jdownloader.gui.packagehistorycontroller.PackageHistoryEntry;
import org.jdownloader.gui.views.linkgrabber.contextmenu.ConfirmLinksContextAction;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public interface LinkgrabberSettings
extends ConfigInterface {
    @AboutConfig
    @DescriptionForConfigEntry(value="Threshold for missing parent directories")
    @DefaultIntValue(value=1)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getMissingParentDirectoryThreshold();

    public void setMissingParentDirectoryThreshold(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isVariantsColumnAlwaysVisible();

    public void setVariantsColumnAlwaysVisible(boolean var1);

    @DefaultJsonObject(value="[]")
    @DefaultOnNull
    @AboutConfig
    public List<DownloadPath> getDownloadDestinationHistory();

    public void setDownloadDestinationHistory(List<DownloadPath> var1);

    @DefaultJsonObject(value="[]")
    @DefaultOnNull
    @AboutConfig
    public List<PackageHistoryEntry> getPackageNameHistory();

    public void setPackageNameHistory(List<PackageHistoryEntry> var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isAutoExtractionEnabled();

    public void setAutoExtractionEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isVariousPackageEnabled();

    public void setVariousPackageEnabled(boolean var1);

    public void setLatestDownloadDestinationFolder(String var1);

    public String getLatestDownloadDestinationFolder();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, AddLinks Dialogs will use the last used downloadfolder as defaultvalue. IF False, the Default Download Paath (settings) will be used")
    public boolean isUseLastDownloadDestinationAsDefault();

    public void setUseLastDownloadDestinationAsDefault(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, JD will switch to the Download Tab after confirming Links in Linkgrabber")
    public boolean isAutoSwitchToDownloadTableOnConfirmDefaultEnabled();

    public void setAutoSwitchToDownloadTableOnConfirmDefaultEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If false, The 'Add Links' dialog in Linkgrabber works on the pasted text, and does not prefilter URLS anymore")
    public boolean isAddLinksPreParserEnabled();

    public void setAddLinksPreParserEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Allows add links dialog to auto enable/disable 'override packagizer rules' checkbox based on user input of the other fields.")
    public boolean isAddLinksOverridePackagizerCheckboxAutoModeEnabled();

    public void setAddLinksOverridePackagizerCheckboxAutoModeEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Automatically search for possible extraction password in pasted text and show them in 'Add Links' dialog")
    @DefaultBooleanValue(value=true)
    public boolean isAddLinksPreParserAutoExtractionPasswordSearchEnabled();

    public void setAddLinksPreParserAutoExtractionPasswordSearchEnabled(boolean var1);

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Selecting Views in Linkgrabber Sidebar autoselects the matching links in the table. Set this to false to avoid this.")
    public boolean isQuickViewSelectionEnabled();

    public void setQuickViewSelectionEnabled(boolean var1);

    @DescriptionForConfigEntry(value="If set, the addlinks dialog has this text. Use it for debug reasons.")
    @AboutConfig
    @MultiLineString
    public String getPresetDebugLinks();

    public void setPresetDebugLinks(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Set to false to hide the 'Add Downloads' Context Menu Action in Linkgrabber")
    public boolean isContextMenuAddLinksActionAlwaysVisible();

    public void setContextMenuAddLinksActionAlwaysVisible(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, Offline Links, that do not fit in a existing package, will be moved to a offline package.")
    public boolean isOfflinePackageEnabled();

    public void setOfflinePackageEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, Linkcollector will create an extra package for each multipart or *.rar  archive")
    public boolean isArchivePackagizerEnabled();

    public void setArchivePackagizerEnabled(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=1)
    @DescriptionForConfigEntry(value="If >0, there will be no packages with * or less links")
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getVariousPackageLimit();

    public void setVariousPackageLimit(int var1);

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="AutoConfirm waits a delay before confirming the links. Default is 15000ms")
    @DefaultIntValue(value=15000)
    @SpinnerValidator(min=1L, max=0x7FFFFFFFL)
    public int getAutoConfirmDelay();

    public void setAutoConfirmDelay(int var1);

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="AutoConfirm waits max delay in ms after first link has been added before confirming the links. Default is -1 = wait for min delay")
    @DefaultIntValue(value=-1)
    @SpinnerValidator(min=-1L, max=0x7FFFFFFFL)
    public int getAutoConfirmMaxDelay();

    public void setAutoConfirmMaxDelay(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, Plugins will try to correct filenames to match to others. For example in split archives.")
    public boolean isAutoFilenameCorrectionEnabled();

    public void setAutoFilenameCorrectionEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If true, the Linkcollector asks the Hosterplugins to filter the packageidentifier. This helps to map corrupt filenames into the correct packages.")
    public boolean isAutoPackageMatchingCorrectionEnabled();

    public void setAutoPackageMatchingCorrectionEnabled(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Define the Pattern that is used to create Packagename created by SplitPackages! {PACKAGENAME,HOSTNAME}")
    @DefaultStringValue(value="{PACKAGENAME}-{HOSTNAME}")
    public String getSplitPackageNameFactoryPattern();

    public void setSplitPackageNameFactoryPattern(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isSplitPackageMergeEnabled();

    public void setSplitPackageMergeEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isLinkgrabberAddAtTop();

    public void setLinkgrabberAddAtTop(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkgrabberAutoStartEnabled();

    public void setLinkgrabberAutoStartEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isLinkgrabberAutoConfirmEnabled();

    public void setLinkgrabberAutoConfirmEnabled(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="Retain filtered links and provide a restore button for them. When disabled, filtered links will not be stored and the 'restore' button will be hidden.")
    public boolean isRestoreButtonEnabled();

    public void setRestoreButtonEnabled(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @DescriptionForConfigEntry(value="If true, the 'Add Links' dialog in Linkgrabber will be filled with current clipboard content")
    public boolean isAutoFillAddLinksDialogWithClipboardContentEnabled();

    public void setAutoFillAddLinksDialogWithClipboardContentEnabled(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @DescriptionForConfigEntry(value="If true, the 'Add Links' dialog in Linkgrabber will come up with the 'Overwrite Packagizer rules' checkbox checked.")
    public boolean isAddLinksDialogOverwritesPackagizerRulesEnabled();

    public void setAddLinksDialogOverwritesPackagizerRulesEnabled(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isAutoStartConfirmSidebarFilterEnabled();

    public void setAutoStartConfirmSidebarFilterEnabled(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="ASK")
    public ConfirmLinksContextAction.OnOfflineLinksAction getDefaultOnAddedOfflineLinksAction();

    public void setDefaultOnAddedOfflineLinksAction(ConfirmLinksContextAction.OnOfflineLinksAction var1);

    @AboutConfig
    @DefaultEnumValue(value="ASK")
    @DescriptionForConfigEntry(value="Defines what to do when user tries to add items from linkgrabber to downloadlist that are already in downloadlist.")
    public ConfirmLinksContextAction.OnDupesLinksAction getDefaultOnAddedDupesLinksAction();

    public void setDefaultOnAddedDupesLinksAction(ConfirmLinksContextAction.OnDupesLinksAction var1);

    @AboutConfig
    @DefaultIntValue(value=25)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="How many entries will be in the Packagename quick selection")
    @SpinnerValidator(min=0L, max=250L)
    public int getPackageNameHistoryLength();

    public void setPackageNameHistoryLength(int var1);

    @AboutConfig
    @DefaultEnumValue(value="AUTO")
    public void setAutoConfirmManagerAutoStart(ConfirmLinksContextAction.AutoStartOptions var1);

    public ConfirmLinksContextAction.AutoStartOptions getAutoConfirmManagerAutoStart();

    @AboutConfig
    @DefaultEnumValue(value="GLOBAL")
    public void setAutoConfirmManagerHandleOffline(ConfirmLinksContextAction.OnOfflineLinksAction var1);

    public ConfirmLinksContextAction.OnOfflineLinksAction getAutoConfirmManagerHandleOffline();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public void setAutoConfirmManagerForceDownloads(boolean var1);

    public boolean isAutoConfirmManagerForceDownloads();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public void setAutoConfirmManagerAssignPriorityEnabled(boolean var1);

    public boolean isAutoConfirmManagerAssignPriorityEnabled();

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    public void setAutoConfirmManagerPriority(Priority var1);

    public Priority getAutoConfirmManagerPriority();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public void setAutoConfirmManagerClearListAfterConfirm(boolean var1);

    public boolean isAutoConfirmManagerClearListAfterConfirm();

    @AboutConfig
    public void setHandleOfflineOnConfirmLatestSelection(ConfirmLinksContextAction.OnOfflineLinksAction var1);

    public ConfirmLinksContextAction.OnOfflineLinksAction getHandleOfflineOnConfirmLatestSelection();

    @AboutConfig
    public void setHandleIncompleteArchiveOnConfirmLatestSelection(GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction var1);

    public GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction getHandleIncompleteArchiveOnConfirmLatestSelection();

    @AboutConfig
    @DescriptionForConfigEntry(value="Defines pre-selected default action in dialog that shows up when user tries to add items from linkgrabber to downloadlist that are already in downloadlist.")
    public void setHandleDupesOnConfirmLatestSelection(ConfirmLinksContextAction.OnDupesLinksAction var1);

    public ConfirmLinksContextAction.OnDupesLinksAction getHandleDupesOnConfirmLatestSelection();

    @AboutConfig
    @DescriptionForConfigEntry(value="Analyze content in the links field 'Add Links' dialog before button \"continue\" is enabled.")
    @DefaultBooleanValue(value=true)
    public boolean getAddLinksDialogCheck();

    public void setAddLinksDialogCheck(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="if this value is >0, the subfolder option only will be used if the package contains more than subfolderThreshold value links")
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DefaultIntValue(value=0)
    public int getSubfolderThreshold();

    public void setSubfolderThreshold(int var1);

    @AboutConfig
    @DefaultEnumValue(value="NAMES")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public void setSubfolderCount(SubFolderByPackageRule.COUNT var1);

    public SubFolderByPackageRule.COUNT getSubfolderCount();
}

