/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.bottombar;

import java.util.EventListener;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.translate._JDT;

public class IncludedSelectionSetup
implements ActionContext {
    private boolean includeUnselectedLinks = false;
    private boolean includeSelectedLinks = true;
    private final PackageControllerTable table;
    private final PackageControllerTableModel model;
    private ExtTableModelListener modelListener;
    private ExtTableListener tableListener;
    public static final String INCLUDE_SELECTED_LINKS = "includeSelectedLinks";
    public static final String INCLUDE_UNSELECTED_LINKS = "includeUnselectedLinks";

    public PackageControllerTable getTable() {
        return this.table;
    }

    public IncludedSelectionSetup(PackageControllerTable table, ExtTableModelListener modelListener, ExtTableListener tableListener) {
        this.table = table;
        this.model = table.getModel();
        this.modelListener = modelListener;
        this.tableListener = tableListener;
    }

    public PackageControllerTable.SelectionType getSelectionType() {
        if (this.isIncludeSelectedLinks() && this.isIncludeUnselectedLinks()) {
            return PackageControllerTable.SelectionType.ALL;
        }
        if (this.isIncludeSelectedLinks()) {
            return PackageControllerTable.SelectionType.SELECTED;
        }
        if (this.isIncludeUnselectedLinks()) {
            return PackageControllerTable.SelectionType.UNSELECTED;
        }
        return PackageControllerTable.SelectionType.NONE;
    }

    public void updateListeners() {
        switch (this.getSelectionType()) {
            case ALL: {
                this.table.getEventSender().removeListener((EventListener)this.tableListener);
                this.model.getEventSender().addListener((EventListener)this.modelListener, true);
                break;
            }
            case SELECTED: 
            case UNSELECTED: {
                this.table.getEventSender().addListener((EventListener)this.tableListener, true);
                this.model.getEventSender().removeListener((EventListener)this.modelListener);
                break;
            }
            case NONE: 
            case BACKEND: {
                this.table.getEventSender().removeListener((EventListener)this.tableListener);
                this.model.getEventSender().removeListener((EventListener)this.modelListener);
                break;
            }
        }
    }

    public static String getTranslationForIncludeSelectedLinks() {
        return _JDT.T.IncludedSelectionSetup_getTranslationForIncludeSelectedLinks();
    }

    @Customizer(link="#getTranslationForIncludeSelectedLinks")
    public boolean isIncludeSelectedLinks() {
        return this.includeSelectedLinks;
    }

    public void setIncludeSelectedLinks(boolean includeSelectedLinks) {
        this.includeSelectedLinks = includeSelectedLinks;
    }

    public static String getTranslationForIncludeUnselectedLinks() {
        return _JDT.T.IncludedSelectionSetup_getTranslationForIncludeUnselectedLinks();
    }

    @Customizer(link="#getTranslationForIncludeUnselectedLinks")
    public boolean isIncludeUnselectedLinks() {
        return this.includeUnselectedLinks;
    }

    public void setIncludeUnselectedLinks(boolean includeUnselectedLinks) {
        this.includeUnselectedLinks = includeUnselectedLinks;
    }
}

