/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.bottombar;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.TransferHandler;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkOrigin;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.dragdrop.PackageControllerTableTransferable;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.gui.views.linkgrabber.actions.AddLinksProgress;
import org.jdownloader.translate._JDT;

public class PasteLinksAction
extends CustomizableAppAction
implements ActionContext {
    public static final String DEEP_DECRYPT_ENABLED = "deepDecryptEnabled";
    private boolean deepDecryptEnabled = false;

    public static String getTranslationForDeepDecryptEnabled() {
        return _JDT.T.PasteLinksAction_getTranslationForDeepDecryptEnabled();
    }

    @Customizer(link="#getTranslationForDeepDecryptEnabled")
    public boolean isDeepDecryptEnabled() {
        return this.deepDecryptEnabled;
    }

    public void setDeepDecryptEnabled(boolean deepDecryptEnabled) {
        this.deepDecryptEnabled = deepDecryptEnabled;
        this.update();
    }

    private void update() {
        if (this.isDeepDecryptEnabled()) {
            this.setName(_GUI.T.PasteLinksAction_PasteLinksAction_deep());
            this.setIconKey("clipboard");
        } else {
            this.setName(_GUI.T.PasteLinksAction_PasteLinksAction());
            this.setIconKey("clipboard");
        }
    }

    public PasteLinksAction() {
        this.update();
    }

    public void actionPerformed(ActionEvent e) {
        PasteLinksAction.processPaste(this.isDeepDecryptEnabled());
    }

    public static void processPaste(final boolean deepDecrypt) {
        View view = MainTabbedPane.getInstance().getSelectedView();
        final Transferable transferable = ClipboardMonitoring.getTransferable();
        if ((view instanceof DownloadsView || view instanceof LinkGrabberView) && transferable.isDataFlavorSupported(PackageControllerTableTransferable.FLAVOR)) {
            PackageControllerTable table = view instanceof DownloadsView ? DownloadsTable.getInstance() : LinkGrabberTable.getInstance();
            TransferHandler.getPasteAction().actionPerformed(new ActionEvent((Object)table, 1001, "paste"));
            return;
        }
        new Thread("Add Links Thread"){

            @Override
            public void run() {
                ClipboardMonitoring.ClipboardContent content = ClipboardMonitoring.getINSTANCE().getCurrentContent(transferable);
                LinkCollectingJob crawljob = new LinkCollectingJob(LinkOrigin.PASTE_LINKS_ACTION.getLinkOriginDetails(), content != null ? content.getContent() : null);
                if (content != null) {
                    crawljob.setCustomSourceUrl(content.getBrowserURL());
                }
                crawljob.setDeepAnalyse(deepDecrypt);
                AddLinksProgress d = new AddLinksProgress(crawljob);
                if (d.isHiddenByDontShowAgain()) {
                    d.getAddLinksDialogThread(crawljob, null).start();
                } else {
                    try {
                        Dialog.getInstance().showDialog((AbstractDialog)d);
                    }
                    catch (DialogClosedException e1) {
                        e1.printStackTrace();
                    }
                    catch (DialogCanceledException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }.start();
    }
}

