/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.bottombar;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtCheckBoxMenuItem;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.ComponentProviderInterface;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.images.NewTheme;
import org.jdownloader.translate._JDT;

public class ToggleAppAction
extends CustomizableAppAction
implements ComponentProviderInterface,
GenericConfigEventListener<Boolean>,
ActionContext {
    private BooleanKeyHandler handler;
    private boolean hidePopupOnClick = false;

    public static String getTranslationForHidePopupOnClick() {
        return _JDT.T.ToggleAppAction_getTranslationForHidePopupOnClick();
    }

    @Customizer(link="#getTranslationForHidePopupOnClick")
    public boolean isHidePopupOnClick() {
        return this.hidePopupOnClick;
    }

    public void setHidePopupOnClick(boolean hidePopupOnClick) {
        this.hidePopupOnClick = hidePopupOnClick;
    }

    public ToggleAppAction(BooleanKeyHandler handler, String name, String tt) {
        this.handler = handler;
        this.setName(name);
        this.setTooltipText(tt);
        this.setSelected(handler.isEnabled());
        handler.getEventSender().addListener((EventListener)((Object)this), true);
    }

    @Override
    public JComponent createComponent(MenuItemData menuItemData) {
        ExtCheckBoxMenuItem ret = new ExtCheckBoxMenuItem((AbstractAction)((Object)this));
        ret.setHideOnClick(this.isHidePopupOnClick());
        ret.getAccessibleContext().setAccessibleName(this.getName());
        ret.getAccessibleContext().setAccessibleDescription(this.getTooltipText());
        if (StringUtils.isNotEmpty((String)menuItemData.getName())) {
            ret.setText(menuItemData.getName());
        } else if (MenuItemData.isEmptyValue(menuItemData.getName())) {
            ret.setText("");
        }
        if (StringUtils.isNotEmpty((String)menuItemData.getIconKey())) {
            ret.setIcon(NewTheme.I().getIcon(menuItemData.getIconKey(), 20));
        } else if (MenuItemData.isEmptyValue(menuItemData.getIconKey())) {
            ret.setIcon(null);
        }
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        this.handler.toggle();
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                ToggleAppAction.this.setSelected(ToggleAppAction.this.handler.isEnabled());
            }
        };
    }
}

