/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.images.NewTheme;

public class OpenInBrowserAction
extends CustomizableTableContextAppAction<CrawledPackage, CrawledLink>
implements ActionContext {
    private static final long serialVersionUID = 7911375550836173693L;
    private int delay = 1000;
    private int threshold = 50;

    public OpenInBrowserAction() {
        this.setIconKey("browse");
        this.setName(_GUI.T.gui_table_contextmenu_browselink());
    }

    public static String getTranslationOpenDelay() {
        return _GUI.T.gui_table_contextmenu_browselink_delay();
    }

    @Customizer(link="#getTranslationOpenDelay")
    public int getOpenDelay() {
        return this.delay;
    }

    public void setOpenDelay(int delay) {
        this.delay = Math.max(100, delay);
    }

    public static String getTranslationMaxOpenThreshold() {
        return _GUI.T.gui_table_contextmenu_browselink_maxurls();
    }

    @Customizer(link="#getTranslationMaxOpenThreshold")
    public int getMaxOpenThreshold() {
        return this.threshold;
    }

    public void setMaxOpenThreshold(int threshold) {
        this.threshold = Math.max(-1, threshold);
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
    }

    @Override
    protected void onRequestUpdateSelection(Object requestor, PackageControllerTable.SelectionType selectionType, SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
        int threshold = this.getMaxOpenThreshold();
        if (!CrossSystem.isOpenBrowserSupported() || threshold == 0) {
            this.setEnabled(false);
            return;
        }
        SelectionInfo selection = this.getSelection();
        if (SelectionInfo.isNotEmpty(selection)) {
            if (threshold < 0) {
                this.setEnabled(true);
                return;
            }
            List links = selection.getChildren();
            if (links.size() <= threshold) {
                for (CrawledLink cl : links) {
                    if (cl.getDownloadLink().getView().getDisplayUrl() == null) continue;
                    this.setEnabled(true);
                    return;
                }
            }
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void onActionPerformed(ActionEvent e, PackageControllerTable.SelectionType selectionType, final SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
        if (SelectionInfo.isNotEmpty(selectionInfo) && this.isEnabled()) {
            new Thread("OpenInBrowserAction"){

                @Override
                public void run() {
                    final int delay = OpenInBrowserAction.this.getOpenDelay();
                    final Set<String> urls = LinkTreeUtils.getURLs(selectionInfo, true);
                    if (urls.size() < 5 && delay < 1000) {
                        for (String url : urls) {
                            try {
                                Thread.sleep(delay);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                            CrossSystem.openURL((String)url);
                        }
                        return;
                    }
                    ProgressDialog pg = new ProgressDialog(new ProgressDialog.ProgressGetter(){
                        private int total = -1;
                        private int current;

                        public void run() throws Exception {
                            this.total = urls.size();
                            this.current = 0;
                            for (String url : urls) {
                                CrossSystem.openURL((String)url);
                                ++this.current;
                                Thread.sleep(delay);
                            }
                        }

                        public String getString() {
                            return this.current + "/" + this.total;
                        }

                        public int getProgress() {
                            if (this.total == 0) {
                                return -1;
                            }
                            int ret = this.current * 100 / this.total;
                            return ret;
                        }

                        public String getLabelString() {
                            return null;
                        }
                    }, 0, _GUI.T.OpenInBrowserAction_actionPerformed_open_in_browser__multi(), _GUI.T.OpenInBrowserAction_actionPerformed_open_in_browser__multi_msg(urls.size()), NewTheme.I().getIcon("browse", 32), null, null);
                    try {
                        Dialog.getInstance().showDialog((AbstractDialog)pg);
                    }
                    catch (DialogNoAnswerException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }
}

