/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.io.File;
import java.util.List;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.BadContextException;
import org.jdownloader.gui.views.DownloadFolderChooserDialog;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.context.SetDownloadFolderAction;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;

public class SetDownloadFolderInLinkgrabberAction
extends SetDownloadFolderAction<CrawledPackage, CrawledLink> {
    private static final long serialVersionUID = -6632019767606316873L;
    private final SelectionInfo<CrawledPackage, CrawledLink> selection;

    public SetDownloadFolderInLinkgrabberAction() {
        this(null);
    }

    public SetDownloadFolderInLinkgrabberAction(SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
        this.selection = selectionInfo;
    }

    @Override
    protected SelectionInfo<CrawledPackage, CrawledLink> getSelection() {
        if (this.selection == null) {
            return super.getSelection();
        }
        return this.selection;
    }

    @Override
    protected File dialog(File path) throws DialogClosedException, DialogCanceledException {
        CrawledPackage cp = this.getSelection().getFirstPackage();
        try {
            cp = this.getSelection().getFirstPackage();
        }
        catch (BadContextException badContextException) {
            // empty catch block
        }
        return DownloadFolderChooserDialog.open(path, true, _GUI.T.OpenDownloadFolderAction_actionPerformed_object_(cp.getName()));
    }

    @Override
    protected void set(CrawledPackage pkg, String absolutePath) {
        pkg.setDownloadFolder(absolutePath);
    }

    @Override
    protected CrawledPackage createNewByPrototype(SelectionInfo<CrawledPackage, CrawledLink> si, CrawledPackage entry) {
        CrawledPackage pkg = new CrawledPackage();
        pkg.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
        if (CrawledPackage.TYPE.NORMAL == entry.getType()) {
            pkg.setName(entry.getName());
        } else {
            String packageName = LinknameCleaner.derivePackagenameFromFilename(this.getSelection().getPackageView(entry).getChildren().get(0).getName());
            pkg.setName(packageName);
        }
        pkg.setComment(entry.getComment());
        return pkg;
    }

    @Override
    protected void move(CrawledPackage pkg, List<CrawledLink> selectedLinksByPackage) {
        LinkCollector.getInstance().moveOrAddAt(pkg, selectedLinksByPackage, -1);
    }

    @Override
    protected Queue getQueue() {
        return LinkCollector.getInstance().getQueue();
    }
}

