/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.overview;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jd.SecondLevelLaunch;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.AggregatedCrawlerNumbers;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.overviewpanel.AbstractOverviewPanel;
import org.jdownloader.gui.views.downloads.overviewpanel.DataEntry;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class LinkgrabberOverview
extends AbstractOverviewPanel<AggregatedCrawlerNumbers, CrawledPackage, CrawledLink>
implements GenericConfigEventListener<Boolean>,
LinkCollectorListener,
GUIListener {
    private static final long serialVersionUID = -195024600818162517L;
    private final ListSelectionListener selectionListener;
    private final TableModelListener tableListener;

    public LinkgrabberOverview(LinkGrabberTable table) {
        super(table.getModel());
        CFG_GUI.LINKGRABBER_TAB_OVERVIEW_VISIBLE.getEventSender().addListener((EventListener)this, true);
        LinkCollector.getInstance().getEventsender().addListener(this, true);
        this.tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                LinkgrabberOverview.this.slowDelayer.run();
            }
        };
        this.tableModel.addTableModelListener(this.tableListener);
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e == null || e.getValueIsAdjusting() || LinkgrabberOverview.this.tableModel.isTableSelectionClearing()) {
                    return;
                }
                LinkgrabberOverview.this.onConfigValueModified(null, null);
            }
        };
        table.getSelectionModel().addListSelectionListener(this.selectionListener);
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                LinkgrabberOverview.this.visible.set(JDGui.getInstance().isCurrentPanel(JDGui.Panels.LINKGRABBER));
                LinkgrabberOverview.this.slowDelayer.run();
            }
        });
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        new EDTRunner(){

            protected void runInEDT() {
                CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_INCLUDE_DISABLED_LINKS.getEventSender().removeListener((EventListener)LinkgrabberOverview.this);
                CFG_GUI.LINKGRABBER_TAB_OVERVIEW_VISIBLE.getEventSender().removeListener((EventListener)LinkgrabberOverview.this);
                LinkCollector.getInstance().getEventsender().removeListener(LinkgrabberOverview.this);
                LinkgrabberOverview.this.tableModel.removeTableModelListener(LinkgrabberOverview.this.tableListener);
                LinkgrabberOverview.this.tableModel.getTable().getSelectionModel().removeListSelectionListener(LinkgrabberOverview.this.selectionListener);
            }
        };
    }

    @Override
    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        if (CFG_GUI.LINKGRABBER_TAB_OVERVIEW_VISIBLE == keyHandler && Boolean.FALSE.equals(newValue)) {
            this.removeListeners();
            this.visible.set(false);
        } else {
            super.onConfigValueModified(keyHandler, newValue);
        }
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
        this.slowDelayer.run();
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
        this.slowDelayer.run();
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
        this.slowDelayer.run();
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
        this.slowDelayer.run();
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
        this.slowDelayer.run();
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
    }

    @Override
    protected boolean isActiveView(View newView) {
        return newView instanceof LinkGrabberView;
    }

    @Override
    public void onKeyModifier(int parameter) {
    }

    @Override
    public void onLinkCrawlerAdded(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStopped(LinkCollectorCrawler parameter) {
    }

    @Override
    protected List<DataEntry<AggregatedCrawlerNumbers>> createDataEntries() {
        PackagesEntry packageCount = new PackagesEntry();
        BytesTotalEntry size = new BytesTotalEntry(_GUI.T.DownloadOverview_DownloadOverview_size());
        LinksCountEntry linkCount = new LinksCountEntry(_GUI.T.DownloadOverview_DownloadOverview_links());
        HostCountEntry hosterCount = new HostCountEntry(_GUI.T.DownloadOverview_DownloadOverview_hoster());
        OnlineCountEntry onlineCount = new OnlineCountEntry(_GUI.T.DownloadOverview_DownloadOverview_online());
        OfflineCountEntry offlineCount = new OfflineCountEntry(_GUI.T.DownloadOverview_DownloadOverview_offline());
        UnknownCountEntry unknownCount = new UnknownCountEntry(_GUI.T.DownloadOverview_DownloadOverview_unknown());
        ArrayList<DataEntry<AggregatedCrawlerNumbers>> entries = new ArrayList<DataEntry<AggregatedCrawlerNumbers>>();
        entries.add(packageCount);
        entries.add(linkCount);
        entries.add(size);
        entries.add(onlineCount);
        entries.add(hosterCount);
        entries.add(offlineCount);
        entries.add(unknownCount);
        return entries;
    }

    @Override
    protected AggregatedCrawlerNumbers createSelected() {
        return new AggregatedCrawlerNumbers(this.tableModel.getTable().getSelectionInfo(true, true));
    }

    @Override
    protected AggregatedCrawlerNumbers createFiltered() {
        return new AggregatedCrawlerNumbers(this.tableModel.getTable().getSelectionInfo(false, true));
    }

    @Override
    protected AggregatedCrawlerNumbers createTotal() {
        return new AggregatedCrawlerNumbers(this.tableModel.getTable().getSelectionInfo(false, false));
    }

    @Override
    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
    }

    @Override
    public void onLinkCrawlerFinished() {
    }

    private final class PackagesEntry
    extends DataEntry<AggregatedCrawlerNumbers> {
        private PackagesEntry() {
            super(_GUI.T.DownloadOverview_DownloadOverview_packages());
        }

        @Override
        public void setData(AggregatedCrawlerNumbers total, AggregatedCrawlerNumbers filtered, AggregatedCrawlerNumbers selected) {
            if (total != null) {
                this.setTotal(total.getPackageCount());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getPackageCount());
            }
            if (selected != null) {
                this.setSelected(selected.getPackageCount());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_PACKAGE_COUNT_VISIBLE;
        }
    }

    private final class BytesTotalEntry
    extends DataEntry<AggregatedCrawlerNumbers> {
        private BytesTotalEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedCrawlerNumbers total, AggregatedCrawlerNumbers filtered, AggregatedCrawlerNumbers selected) {
            boolean includeDisabled = CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_INCLUDE_DISABLED_LINKS.isEnabled();
            if (total != null) {
                this.setTotal(total.getTotalBytesString(includeDisabled));
            }
            if (filtered != null) {
                this.setFiltered(filtered.getTotalBytesString(includeDisabled));
            }
            if (selected != null) {
                this.setSelected(selected.getTotalBytesString(includeDisabled));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_TOTAL_BYTES_VISIBLE;
        }
    }

    private final class LinksCountEntry
    extends DataEntry<AggregatedCrawlerNumbers> {
        private LinksCountEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedCrawlerNumbers total, AggregatedCrawlerNumbers filtered, AggregatedCrawlerNumbers selected) {
            if (total != null) {
                this.setTotal(total.getLinkCount());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getLinkCount());
            }
            if (selected != null) {
                this.setSelected(selected.getLinkCount());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_LINKS_COUNT_VISIBLE;
        }
    }

    private final class HostCountEntry
    extends DataEntry<AggregatedCrawlerNumbers> {
        private HostCountEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedCrawlerNumbers total, AggregatedCrawlerNumbers filtered, AggregatedCrawlerNumbers selected) {
            if (total != null) {
                this.setTotal(total.getHoster().size());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getHoster().size());
            }
            if (selected != null) {
                this.setSelected(selected.getHoster().size());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_HOSTER_COUNT_VISIBLE;
        }
    }

    private final class OnlineCountEntry
    extends DataEntry<AggregatedCrawlerNumbers> {
        private OnlineCountEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedCrawlerNumbers total, AggregatedCrawlerNumbers filtered, AggregatedCrawlerNumbers selected) {
            if (total != null) {
                this.setTotal(total.getStatusOnline());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getStatusOnline());
            }
            if (selected != null) {
                this.setSelected(selected.getStatusOnline());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_STATUS_ONLINE_VISIBLE;
        }
    }

    private final class OfflineCountEntry
    extends DataEntry<AggregatedCrawlerNumbers> {
        private OfflineCountEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedCrawlerNumbers total, AggregatedCrawlerNumbers filtered, AggregatedCrawlerNumbers selected) {
            if (total != null) {
                this.setTotal(total.getStatusOffline());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getStatusOffline());
            }
            if (selected != null) {
                this.setSelected(selected.getStatusOffline());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_STATUS_OFFLINE_VISIBLE;
        }
    }

    private final class UnknownCountEntry
    extends DataEntry<AggregatedCrawlerNumbers> {
        private UnknownCountEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedCrawlerNumbers total, AggregatedCrawlerNumbers filtered, AggregatedCrawlerNumbers selected) {
            if (total != null) {
                this.setTotal(total.getStatusUnknown());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getStatusUnknown());
            }
            if (selected != null) {
                this.setSelected(selected.getStatusUnknown());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_LINKGRABBER_STATUS_UNKNOWN_VISIBLE;
        }
    }
}

