/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.quickfilter;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jd.SecondLevelLaunch;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.BasicJDTable;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelCustomizer;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelFilter;
import org.jdownloader.gui.views.components.packagetable.context.EnabledAction;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.jdownloader.gui.views.linkgrabber.quickfilter.Filter;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTableDataUpdater;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTableModel;
import org.jdownloader.gui.views.linkgrabber.quickfilter.HeaderInterface;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class FilterTable
extends BasicJDTable<Filter>
implements PackageControllerTableModelFilter<CrawledPackage, CrawledLink> {
    private static final long serialVersionUID = -5917220196056769905L;
    private HeaderInterface header;
    private LinkGrabberTable linkgrabberTable;
    private static CopyOnWriteArraySet<FilterTableUpdater> FILTERTABLES = new CopyOnWriteArraySet();
    private static ScheduledExecutorService EXECUTER = DelayedRunnable.getNewScheduledExecutorService();
    protected static final long SELECTION_REFRESH_MIN = 25L;
    protected static final long SELECTION_REFRESH_MAX = 100L;
    private static final DelayedRunnable SELECTIONUPDATER = new DelayedRunnable(EXECUTER, 25L, 100L){

        public void delayedrun() {
            if (CFG_LINKGRABBER.QUICK_VIEW_SELECTION_ENABLED.isEnabled()) {
                LinkGrabberTableModel.getInstance().addTableModifier(FilterTable.getTableDataModification(null), false);
            }
        }
    };
    protected static final long FILTER_REFRESH_MIN = 1000L;
    protected static final long FILTER_REFRESH_MAX = 3000L;
    private static final DelayedRunnable FILTERTABLESUPDATER = new DelayedRunnable(EXECUTER, 1000L, 3000L){

        public String getID() {
            return "FilterTable";
        }

        public void delayedrun() {
            try {
                ArrayList<FilterTableDataUpdater> updater = new ArrayList<FilterTableDataUpdater>();
                for (FilterTableUpdater filterTable : FILTERTABLES) {
                    if (!filterTable.getUpdate().getAndSet(false)) continue;
                    updater.add(filterTable.getTable().getFilterTableDataUpdater());
                }
                FilterTable.updateFilterTables(updater);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    };
    private static final PropertyChangeListener PROPERTYCHANGELISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FilterTable.updateAllFiltersInstant();
        }
    };
    private static volatile Filter filterException = null;
    private static volatile Thread filterExceptionThread = null;
    private BooleanKeyHandler visibleKeyHandler;
    private GenericConfigEventListener<Boolean> sidebarListener;
    private final FilterTableUpdater filterTableUpdater;

    private static PackageControllerTableModel.TableDataModification getTableDataModification(final Runnable runnable) {
        LinkGrabberTableModel linkGrabberTableModel = LinkGrabberTableModel.getInstance();
        ((Object)((Object)linkGrabberTableModel)).getClass();
        return new PackageControllerTableModel.TableDataModification(linkGrabberTableModel){
            final List<Filter> selectedFilters;
            final List<AbstractNode> selectedCrawledLinks;
            {
                super(x0);
                this.selectedFilters = FilterTable.getSelectedFilters();
                this.selectedCrawledLinks = new ArrayList<AbstractNode>();
            }

            protected void modifyPackageData(CrawledPackage pkg, List<CrawledLink> unfilteredChildren) {
                boolean expand = false;
                block0: for (CrawledLink link : unfilteredChildren) {
                    for (Filter filter : this.selectedFilters) {
                        if (!filter.isFiltered(link)) continue;
                        expand = true;
                        this.selectedCrawledLinks.add(link);
                        continue block0;
                    }
                }
                if (expand) {
                    pkg.setExpanded(true);
                }
            }

            @Override
            protected PackageControllerTableModelCustomizer finalizeTableModification() {
                return new PackageControllerTableModelCustomizer(){

                    @Override
                    public boolean customizedTableData() {
                        LinkGrabberTableModel.getInstance().setSelectedObjects(selectedCrawledLinks);
                        if (runnable != null) {
                            runnable.run();
                        }
                        return false;
                    }
                };
            }
        };
    }

    private static void updateAllFiltersInstant() {
        for (FilterTableUpdater filterTable : FILTERTABLES) {
            filterTable.getUpdate().set(true);
        }
        FILTERTABLESUPDATER.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFilterTables(List<FilterTableDataUpdater> updater) {
        if (updater.size() == 0) {
            return;
        }
        for (FilterTableDataUpdater update : updater) {
            update.reset();
        }
        List tableData = LinkGrabberTableModel.getInstance().getTableData();
        int invisibleChildren = 0;
        for (PackageControllerTableModelData.PackageControllerTableModelDataPackage modelDataPackage : ((PackageControllerTableModelData)tableData).getModelDataPackages()) {
            if (modelDataPackage.getVisibleChildrenSize() <= 0) continue;
            for (CrawledLink link : modelDataPackage.getVisibleChildren()) {
                for (FilterTableDataUpdater update : updater) {
                    update.updateVisible(link);
                }
            }
        }
        for (FilterTableDataUpdater update : updater) {
            update.afterVisible();
        }
        invisibleChildren += ((PackageControllerTableModelData)tableData).getFilteredChildren().size();
        for (CrawledLink link : ((PackageControllerTableModelData)tableData).getFilteredChildren()) {
            for (FilterTableDataUpdater update : updater) {
                update.updateVisible(link);
            }
        }
        invisibleChildren += ((PackageControllerTableModelData)tableData).getInvisibleChildren().size();
        for (CrawledLink link : ((PackageControllerTableModelData)tableData).getInvisibleChildren()) {
            for (FilterTableDataUpdater update : updater) {
                update.updateVisible(link);
            }
        }
        HashMap<FilterTable, List<Filter>> updateTableData = new HashMap<FilterTable, List<Filter>>();
        boolean newDisabledFilters = false;
        for (FilterTableDataUpdater update : updater) {
            if (update.hasNewDisabledFilters()) {
                newDisabledFilters = true;
            }
            FilterTable filterTable = update.getFilterTable();
            List<Filter> filters = update.finalizeUpdater();
            if (filters.size() > 0 && filterTable.visibleKey()) {
                try {
                    filterExceptionThread = Thread.currentThread();
                    for (Filter filter : filters) {
                        if (filter.getCounter() != 0 || invisibleChildren <= 0) continue;
                        filter.setCounter(FilterTable.getCountWithout(filter, (PackageControllerTableModelData<CrawledPackage, CrawledLink>)tableData));
                    }
                }
                finally {
                    filterExceptionThread = null;
                }
                update.getFilterTable().sort(filters);
            }
            updateTableData.put(filterTable, filters);
        }
        for (Map.Entry next : updateTableData.entrySet()) {
            ((FilterTable)next.getKey()).updateTableData((List)next.getValue());
        }
        if (newDisabledFilters) {
            LinkGrabberTableModel.getInstance().recreateModel(false);
        }
    }

    public boolean isSortingEnabledDisabled() {
        return false;
    }

    protected void sort(List<Filter> filters) {
        try {
            final boolean sortEnabledDisabled = this.isSortingEnabledDisabled();
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(boolean x, boolean y) {
                    return x == y ? 0 : (x ? -1 : 1);
                }

                @Override
                public int compare(Filter o1, Filter o2) {
                    if (!sortEnabledDisabled || o1.isEnabled() == o2.isEnabled()) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                    return this.compare(o1.isEnabled(), o2.isEnabled());
                }
            });
        }
        catch (Throwable e) {
            LogController.CL(true).log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getCountWithout(Filter filter, PackageControllerTableModelData<CrawledPackage, CrawledLink> tableModelData) {
        List<PackageControllerTableModelFilter<CrawledPackage, CrawledLink>> tableFilters = tableModelData.getChildrenFilters();
        if (tableFilters == null || tableFilters.size() == 0) {
            return 0;
        }
        int ret = 0;
        block8: for (CrawledLink link : tableModelData.getFilteredChildren()) {
            if (!filter.isFiltered(link)) continue;
            try {
                filterException = filter;
                for (PackageControllerTableModelFilter<CrawledPackage, CrawledLink> f : tableFilters) {
                    if (f.isFiltered(link)) continue block8;
                }
            }
            finally {
                filterException = null;
                continue;
            }
            ++ret;
        }
        block10: for (CrawledLink link : tableModelData.getInvisibleChildren()) {
            if (!filter.isFiltered(link)) continue;
            try {
                filterException = filter;
                for (PackageControllerTableModelFilter<CrawledPackage, CrawledLink> f : tableFilters) {
                    if (f.isFiltered(link)) continue block10;
                }
            }
            finally {
                filterException = null;
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public FilterTable(HeaderInterface hosterFilter, LinkGrabberTable table, final BooleanKeyHandler visible) {
        super((ExtTableModel)new FilterTableModel());
        this.header = hosterFilter;
        this.visibleKeyHandler = visible;
        this.header.setFilterCount(0);
        this.linkgrabberTable = table;
        this.filterTableUpdater = new FilterTableUpdater(this);
        this.setShowVerticalLines(false);
        this.setShowGrid(false);
        this.setShowHorizontalLines(false);
        this.setSelectionMode(2);
        this.setBackground(LAFOptions.getInstance().getColorForPanelBackground());
        this.setIntercellSpacing(new Dimension(0, 0));
        this.sidebarListener = new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                if (Boolean.TRUE.equals(newValue) && CFG_GUI.CFG.isLinkgrabberSidebarVisible()) {
                    boolean addListener = FILTERTABLES.size() == 0;
                    FILTERTABLES.add(FilterTable.this.filterTableUpdater);
                    FilterTable.this.linkgrabberTable.getModel().addFilter(FilterTable.this);
                    if (addListener) {
                        FilterTable.this.linkgrabberTable.addPropertyChangeListener("repaintFired", PROPERTYCHANGELISTENER);
                        FilterTable.this.linkgrabberTable.addPropertyChangeListener("structureChangedFired", PROPERTYCHANGELISTENER);
                    }
                    FilterTable.super.setVisible(true);
                } else {
                    FILTERTABLES.remove(FilterTable.this.filterTableUpdater);
                    FilterTable.this.linkgrabberTable.getModel().removeFilter(FilterTable.this);
                    if (FILTERTABLES.size() == 0) {
                        FilterTable.this.linkgrabberTable.removePropertyChangeListener("repaintFired", PROPERTYCHANGELISTENER);
                        FilterTable.this.linkgrabberTable.removePropertyChangeListener("structureChangedFired", PROPERTYCHANGELISTENER);
                    }
                    FilterTable.super.setVisible(false);
                }
                FilterTable.this.linkgrabberTable.getModel().recreateModel(false);
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        };
        visible.getEventSender().addListener(this.sidebarListener);
        CFG_GUI.LINKGRABBER_SIDEBAR_VISIBLE.getEventSender().addListener(this.sidebarListener, true);
        SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                FilterTable.this.sidebarListener.onConfigValueModified(null, visible.getValue());
            }
        });
    }

    protected abstract FilterTableDataUpdater getFilterTableDataUpdater();

    protected void requestUpdate() {
        this.filterTableUpdater.getUpdate().set(true);
        FILTERTABLESUPDATER.run();
    }

    protected void onSelectionChanged() {
        if (!this.getModel().isTableStructureChanging() && this.hasFocus()) {
            SELECTIONUPDATER.run();
        }
    }

    private static List<Filter> getSelectedFilters() {
        final ArrayList<Filter> ret = new ArrayList<Filter>();
        new EDTRunner(){

            protected void runInEDT() {
                for (FilterTableUpdater filterTableUpdater : FILTERTABLES) {
                    FilterTable f = filterTableUpdater.getTable();
                    ret.addAll(f.getModel().getSelectedObjects());
                }
            }
        }.waitForEDT();
        return ret;
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, Filter contextObject, List<Filter> selection, ExtColumn<Filter> column, final MouseEvent mouseEvent) {
        if (CFG_LINKGRABBER.QUICK_VIEW_SELECTION_ENABLED.isEnabled()) {
            LinkGrabberTableModel.getInstance().addTableModifier(FilterTable.getTableDataModification(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPopupMenu ret = MenuManagerLinkgrabberTableContext.getInstance().build(mouseEvent);
                            FilterTable.this.showPopup(ret, mouseEvent.getPoint());
                        }
                    });
                }
            }), false);
            return popup;
        }
        return MenuManagerLinkgrabberTableContext.getInstance().build(mouseEvent);
    }

    protected void processMouseEvent(MouseEvent e) {
        int row;
        if (e.getID() == 501 && !e.isControlDown() && e.getButton() == 1 && e.getClickCount() == 1) {
            row = this.rowAtPoint(e.getPoint());
            ExtColumn col = this.getExtColumnAtPoint(e.getPoint());
            if (this.isRowSelected(row) && !(col instanceof ExtCheckColumn)) {
                if (this.getSelectedRows().length > 1) {
                    this.getSelectionModel().setSelectionInterval(row, row);
                } else {
                    this.getSelectionModel().removeSelectionInterval(row, row);
                }
                return;
            }
        }
        if (e.getID() == 502 && this.isContextMenuTrigger(e)) {
            row = this.rowAtPoint(e.getPoint());
            Filter obj = (Filter)this.getModel().getObjectbyRow(row);
            if (obj == null || row == -1 || !this.isRowSelected(row)) {
                for (FilterTableUpdater filterTableUpdater : FILTERTABLES) {
                    FilterTable f = filterTableUpdater.getTable();
                    if (f == this) {
                        this.clearSelection();
                        continue;
                    }
                    f.getModel().clearSelection();
                }
            }
        }
        super.processMouseEvent(e);
    }

    protected boolean onSingleClick(MouseEvent e, Filter obj) {
        if (!e.isControlDown()) {
            for (FilterTableUpdater filterTableUpdater : FILTERTABLES) {
                FilterTable f = filterTableUpdater.getTable();
                if (f == this) continue;
                f.getModel().clearSelection();
            }
            return true;
        }
        return false;
    }

    protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
        if (!pressed) {
            return super.processKeyBinding(stroke, evt, condition, pressed);
        }
        switch (evt.getKeyCode()) {
            case 8: 
            case 127: {
                if (CFG_GUI.CFG.isLinkgrabberSidebarDeleteHotkeyEnabled()) break;
                EnabledAction action = new EnabledAction();
                action.requestUpdate(null);
                action.actionPerformed(null);
                return true;
            }
            case 10: {
                EnabledAction action = new EnabledAction();
                action.requestUpdate(null);
                action.actionPerformed(null);
                return true;
            }
            case 32: {
                for (FilterTableUpdater filterTableUpdater : FILTERTABLES) {
                    Iterator iterator = filterTableUpdater.getTable().getModel().getSelectedObjects().iterator();
                    while (iterator.hasNext()) {
                        Filter f;
                        f.setEnabled(!(f = (Filter)iterator.next()).isEnabled());
                    }
                }
                return true;
            }
            case 67: 
            case 86: 
            case 88: {
                return true;
            }
            case 38: 
            case 40: {
                if (!evt.isMetaDown() && !evt.isControlDown()) break;
                return true;
            }
        }
        return super.processKeyBinding(stroke, evt, condition, pressed);
    }

    protected boolean visibleKey() {
        return this.visibleKeyHandler.isEnabled();
    }

    protected void updateTableData(List<Filter> filter) {
        boolean enabled = filter.size() > 0;
        this.setVisible(enabled);
        if (this.visibleKey()) {
            if (enabled) {
                this.getModel()._fireTableStructureChanged(filter, false);
            } else {
                this.getModel().clear();
            }
        }
    }

    protected static Filter getFilterException() {
        if (filterException != null && Thread.currentThread() == filterExceptionThread) {
            return filterException;
        }
        return null;
    }

    public LinkGrabberTable getLinkgrabberTable() {
        return this.linkgrabberTable;
    }

    public void setVisible(final boolean aFlag) {
        new EDTRunner(){

            protected void runInEDT() {
                FilterTable.this.header.setEnabled(aFlag);
                FilterTable.super.setVisible(aFlag && FilterTable.this.visibleKey());
            }
        };
    }

    public boolean isEnabled() {
        return FILTERTABLES.size() > 0;
    }

    @Override
    public boolean isFilteringPackageNodes() {
        return false;
    }

    @Override
    public boolean isFiltered(CrawledPackage e) {
        return false;
    }

    private static class FilterTableUpdater {
        private AtomicBoolean update = new AtomicBoolean(false);
        private FilterTable table;

        public FilterTable getTable() {
            return this.table;
        }

        private FilterTableUpdater(FilterTable table) {
            this.table = table;
        }

        public AtomicBoolean getUpdate() {
            return this.update;
        }
    }
}

