/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.quickfilter;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import jd.SecondLevelLaunch;
import jd.controlling.linkcrawler.CrawledLink;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.ExceptionsRuleDialog;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.FilterRuleDialog;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeListener;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.filter.LinkFilterController;
import org.jdownloader.controlling.filter.LinkgrabberFilterRule;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.quickfilter.CustomFilterHeader;
import org.jdownloader.gui.views.linkgrabber.quickfilter.ExceptionFilter;
import org.jdownloader.gui.views.linkgrabber.quickfilter.Filter;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTable;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTableDataUpdater;
import org.jdownloader.settings.staticreferences.CFG_LINKFILTER;

public class QuickFilterExceptionsTable
extends FilterTable {
    private static final long serialVersionUID = 658947589171018284L;
    private volatile CopyOnWriteArrayList<ExceptionFilter> allFilters = new CopyOnWriteArrayList();
    private volatile CopyOnWriteArraySet<Filter> enabledFilters = new CopyOnWriteArraySet();

    public QuickFilterExceptionsTable(CustomFilterHeader exceptions, LinkGrabberTable table) {
        super(exceptions, table, CFG_LINKFILTER.LINKGRABBER_EXCEPTIONS_QUICKFILTER_ENABLED);
        this.init();
    }

    private void init() {
        SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                LinkFilterController.getInstance().getEventSender().addListener((EventListener)new ChangeListener(){

                    public void onChangeEvent(ChangeEvent event) {
                        QuickFilterExceptionsTable.this.convertLinkgrabberFilterRuleWrapper();
                    }
                });
                QuickFilterExceptionsTable.this.convertLinkgrabberFilterRuleWrapper();
            }
        });
    }

    private void convertLinkgrabberFilterRuleWrapper() {
        ArrayList<LinkgrabberFilterRuleWrapper> filtersToSetup = new ArrayList<LinkgrabberFilterRuleWrapper>();
        List<LinkgrabberFilterRuleWrapper> filters = LinkFilterController.getInstance().getAcceptFilters();
        if (filters != null) {
            filtersToSetup.addAll(filters);
        }
        CopyOnWriteArrayList<2> newAllFilters = new CopyOnWriteArrayList<2>();
        CopyOnWriteArraySet<2> newEnabledFilters = new CopyOnWriteArraySet<2>();
        for (LinkgrabberFilterRuleWrapper rule : filtersToSetup) {
            ExceptionFilter filter = new ExceptionFilter(rule){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    QuickFilterExceptionsTable.this.setEnabled(enabled, this);
                }
            };
            newAllFilters.add(filter);
            if (filter.isEnabled()) continue;
            newEnabledFilters.add(filter);
        }
        this.allFilters = newAllFilters;
        this.enabledFilters = newEnabledFilters;
        this.requestUpdate();
        this.getLinkgrabberTable().getModel().recreateModel(false);
    }

    private void setEnabled(boolean enabled, Filter filter) {
        if (!enabled) {
            this.enabledFilters.add(filter);
        } else {
            this.enabledFilters.remove(filter);
        }
        this.getLinkgrabberTable().getModel().recreateModel(false);
    }

    protected boolean onDoubleClick(MouseEvent e, Filter obj) {
        for (ExceptionFilter exceptionFilter : this.allFilters) {
            if (exceptionFilter != obj) continue;
            try {
                LinkgrabberFilterRule filterRule = (LinkgrabberFilterRule)exceptionFilter.getWrapperRule().getRule();
                if (filterRule.isAccept()) {
                    Dialog.getInstance().showDialog((AbstractDialog)new ExceptionsRuleDialog(filterRule));
                } else {
                    Dialog.getInstance().showDialog((AbstractDialog)new FilterRuleDialog(filterRule));
                }
                LinkFilterController.getInstance().update();
            }
            catch (DialogNoAnswerException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        return false;
    }

    @Override
    protected FilterTableDataUpdater getFilterTableDataUpdater() {
        return new FilterTableDataUpdater(){
            List<Filter> availableFilters;
            Set<Filter> usedFilters;
            {
                this.availableFilters = new ArrayList<Filter>(QuickFilterExceptionsTable.this.allFilters);
                this.usedFilters = new HashSet<Filter>();
            }

            @Override
            public void updateVisible(CrawledLink link) {
                for (Filter filter : this.availableFilters) {
                    if (!filter.isFiltered(link)) continue;
                    this.usedFilters.add(filter);
                    filter.increaseCounter();
                }
            }

            @Override
            public void updateFiltered(CrawledLink link) {
                if (this.availableFilters.size() > 0) {
                    Iterator<Filter> it = this.availableFilters.iterator();
                    while (it.hasNext()) {
                        Filter filter = it.next();
                        if (!((ExceptionFilter)filter).isFiltered(link)) continue;
                        this.usedFilters.add(filter);
                        it.remove();
                    }
                }
            }

            @Override
            public void reset() {
                for (Filter filter : this.availableFilters) {
                    filter.resetCounter();
                }
            }

            @Override
            public FilterTable getFilterTable() {
                return QuickFilterExceptionsTable.this;
            }

            @Override
            public List<Filter> finalizeUpdater() {
                return new ArrayList<Filter>(this.usedFilters);
            }

            @Override
            public void afterVisible() {
                this.availableFilters.removeAll(this.usedFilters);
            }

            @Override
            public boolean hasNewDisabledFilters() {
                return false;
            }
        };
    }

    @Override
    public int getComplexity() {
        return 100;
    }

    @Override
    public boolean isFiltered(CrawledLink v) {
        Filter exception = QuickFilterExceptionsTable.getFilterException();
        for (Filter enabledFilter : this.enabledFilters) {
            if (enabledFilter == exception || !enabledFilter.isFiltered(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFilteringChildrenNodes() {
        return this.isEnabled() && this.enabledFilters.size() > 0;
    }
}

