/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.images;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.appwork.resources.AWUTheme;
import org.appwork.resources.Theme;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.components.IDIcon;
import org.appwork.utils.images.ColoredIcon;
import org.appwork.utils.images.IconIO;
import org.jdownloader.images.IdentifierWrapperIcon;
import org.jdownloader.updatev2.gui.LAFOptions;

public class NewTheme
extends Theme {
    private static final NewTheme INSTANCE = new NewTheme();

    public static NewTheme getInstance() {
        return INSTANCE;
    }

    public static NewTheme I() {
        return INSTANCE;
    }

    private NewTheme() {
        super("org/jdownloader/");
        AWUTheme.getInstance().setNameSpace(this.getNameSpace());
        AWUTheme.I().setDelegate((Theme)this);
        try {
            LAFOptions inst = LAFOptions.getInstance();
            if (inst != null) {
                this.setTheme(inst.getCfg().getIconSetID());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setTheme(String theme) {
        super.setTheme(theme);
        AWUTheme.getInstance().setTheme(theme);
    }

    public Icon getDisabledIcon(JComponent component, Icon input) {
        Icon ret = super.getDisabledIcon(component, input);
        if (input instanceof IDIcon) {
            return new IdentifierWrapperIcon(ret, ((IDIcon)input).getIdentifier().getKey() + "_disabled");
        }
        return ret;
    }

    public Icon getIcon(String relativePath, int size) {
        Object ret;
        if ("compress".equals(relativePath) || "archive".equals(relativePath)) {
            relativePath = "extract";
        }
        if ((ret = super.getIcon(relativePath, size)) != null) {
            ret = new IdentifierWrapperIcon((Icon)ret, relativePath);
        }
        return ret;
    }

    protected String getCacheKey(Object ... objects) {
        if (objects != null) {
            if (objects.length == 1 && objects[0] != null) {
                return objects[0].toString();
            }
            StringBuilder sb = new StringBuilder();
            for (Object o : objects) {
                if (o == null) continue;
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(o.toString());
            }
            return sb.toString();
        }
        return null;
    }

    public Icon getCheckBoxImage(String path, boolean selected, int size) {
        return this.getCheckBoxImage(path, selected, size, null);
    }

    public static Set<Color> getInner25PercentColors(BufferedImage image) {
        HashSet<Color> colors = new HashSet<Color>();
        int width = image.getWidth();
        int height = image.getHeight();
        int startX = width / 4;
        int startY = height / 4;
        int innerWidth = width / 2;
        int innerHeight = height / 2;
        for (int y = startY; y < startY + innerHeight; ++y) {
            for (int x = startX; x < startX + innerWidth; ++x) {
                int rgb = image.getRGB(x, y);
                Color color = new Color(rgb, true);
                colors.add(color);
            }
        }
        return colors;
    }

    public Icon getCheckBoxImage(String path, boolean selected, int size, Color red) {
        Icon ret = null;
        String key = this.getCacheKey(path + "/" + red, size, selected);
        ret = this.getCached(key);
        if (ret == null) {
            CheckBoxIcon checkBox;
            Icon back = this.getIcon(path, size);
            CheckBoxIcon checkBoxIcon = checkBox = selected ? new CheckBoxIcon((int)(1.0 * (0.5 * (double)size)), selected, true) : new CheckBoxIcon((int)(1.0 * (0.5 * (double)size)), selected, true);
            if (red != null) {
                ColoredIcon colored = new ColoredIcon((Icon)checkBox);
                for (Color c : NewTheme.getInner25PercentColors(IconIO.toBufferedImage((Icon)CheckBoxIcon.FALSE))) {
                    colored.replace(new ColoredIcon.ColorLookup(c, 20, true), red);
                }
                checkBox = colored;
            }
            ret = new ExtMergedIcon(back, 0, 0).add((Icon)checkBox, 0, back.getIconHeight() - checkBox.getIconHeight() + 2);
            this.cache(ret, key);
        }
        return ret;
    }
}

