/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.jna.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.appwork.utils.swing.windowmanager.WindowsWindowManager;
import org.jdownloader.jna.windows.User32;

public class JNAWindowsWindowManager
extends WindowsWindowManager {
    private final User32 instance = User32.INSTANCE;

    public void setZState(Window w, WindowManager.FrameState state) {
        super.setZState(w, state);
        if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_XP) && w.isVisible()) {
            switch (state) {
                case TO_FRONT: 
                case TO_FRONT_FOCUSED: {
                    if (!(w instanceof Frame)) break;
                    try {
                        WinDef.HWND hWnd = User32.INSTANCE.FindWindow(null, ((Frame)w).getTitle());
                        if (hWnd == null) break;
                        User32.INSTANCE.SetForegroundWindow(hWnd);
                    }
                    catch (Exception e) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e);
                    }
                    break;
                }
            }
        }
    }

    public void setExtendedState(Frame w, WindowManager.WindowExtendedState state) {
        if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_XP) && w.isVisible()) {
            try {
                switch (state) {
                    case ICONIFIED: {
                        this.instance.CloseWindow(new WinDef.HWND(Native.getComponentPointer((Component)w)));
                        return;
                    }
                    case NORMAL: {
                        this.instance.ShowWindow(new WinDef.HWND(Native.getComponentPointer((Component)w)), 9);
                        return;
                    }
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
        super.setExtendedState(w, state);
    }
}

