/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.myjdownloader.client.bindings.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jdownloader.myjdownloader.client.AbstractMyJDClientForBasicJVM;
import org.jdownloader.myjdownloader.client.bindings.events.EventsDistributorEventSender;
import org.jdownloader.myjdownloader.client.bindings.events.EventsDistributorListener;
import org.jdownloader.myjdownloader.client.bindings.events.json.SubscriptionResponse;
import org.jdownloader.myjdownloader.client.bindings.interfaces.EventsInterface;

public class EventDistributor
implements Runnable,
EventsDistributorListener {
    private EventsInterface link;
    private SubscriptionResponse subscription;
    private EventsDistributorEventSender eventSender;
    private ArrayList<EventsDistributorListener> listeners;
    private long polltimeout;
    private long keepalive;
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicBoolean stopping = new AtomicBoolean(false);

    public EventDistributor(AbstractMyJDClientForBasicJVM api, String deviceID) {
        this.link = api.link(EventsInterface.class, deviceID);
        this.listeners = new ArrayList();
        this.eventSender = new EventsDistributorEventSender();
        this.eventSender.addListener(this);
    }

    public void removeListener(EventsDistributorListener listener) {
        ArrayList<EventsDistributorListener> newListeners = new ArrayList<EventsDistributorListener>();
        boolean changed = false;
        for (EventsDistributorListener fi : this.listeners) {
            if (listener == fi) {
                changed = true;
                continue;
            }
            newListeners.add(fi);
        }
        this.listeners = newListeners;
        if (changed) {
            this.updateChannel();
        }
    }

    public void addListener(EventsDistributorListener listener) {
        ArrayList<EventsDistributorListener> newListeners = new ArrayList<EventsDistributorListener>();
        newListeners.addAll(this.listeners);
        newListeners.add(listener);
        this.listeners = newListeners;
        this.updateChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateChannel() {
        EventDistributor eventDistributor = this;
        synchronized (eventDistributor) {
            try {
                SubscriptionResponse resp;
                HashSet<String> subscribes = new HashSet<String>();
                for (EventsDistributorListener fi : this.listeners) {
                    if (fi.getEventPattern() == null) continue;
                    subscribes.add(fi.getEventPattern());
                }
                if (subscribes.size() == 0) {
                    this.close();
                    return;
                }
                if (this.subscription != null) {
                    resp = this.link.setsubscription(this.subscription.getSubscriptionid(), subscribes.toArray(new String[0]), null);
                    if ((resp = this.updateConnectionSetup(resp)) != null && resp.getSubscriptionid() >= 0L) {
                        this.updateSubscription(resp);
                        this.printSub();
                        return;
                    }
                }
                this.close();
                System.out.println("Subscribe ");
                resp = this.link.subscribe(subscribes.toArray(new String[0]), null);
                if (resp == null) return;
                if (resp.getSubscriptionid() < 0L) return;
                resp = this.updateConnectionSetup(resp);
                this.updateSubscription(resp);
                this.printSub();
                return;
            }
            finally {
                EventDistributor eventDistributor2 = this;
                synchronized (eventDistributor2) {
                    this.notifyAll();
                }
            }
        }
    }

    public void updateSubscription(SubscriptionResponse resp) {
        this.subscription = resp;
    }

    public SubscriptionResponse updateConnectionSetup(SubscriptionResponse resp) {
        if (this.polltimeout > 0L && this.polltimeout != resp.getMaxPolltimeout() || this.keepalive > 0L && this.keepalive != resp.getMaxKeepalive()) {
            long pt = this.polltimeout > 0L ? this.polltimeout : resp.getMaxPolltimeout();
            long ka = this.keepalive > 0L ? this.keepalive : resp.getMaxKeepalive();
            resp = this.link.changesubscriptiontimeouts(resp.getSubscriptionid(), pt, ka);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        EventDistributor eventDistributor = this;
        synchronized (eventDistributor) {
            if (this.subscription != null) {
                System.out.println("Unsubscribe " + this.subscription.getSubscriptionid());
                this.link.unsubscribe(this.subscription.getSubscriptionid());
                this.updateSubscription(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionConfig(long polltimeout, long keepalive) {
        this.polltimeout = polltimeout;
        this.keepalive = keepalive;
        EventDistributor eventDistributor = this;
        synchronized (eventDistributor) {
            SubscriptionResponse resp;
            if (this.subscription != null && (resp = this.updateConnectionSetup(this.subscription)) != null && resp.getSubscriptionid() >= 0L) {
                this.updateSubscription(resp);
                this.printSub();
            }
        }
    }

    private void printSub() {
        System.out.println("Channel Update" + this.subscription.getSubscriptionid());
        System.out.println("Subscriptions: " + Arrays.toString(this.subscription.getSubscriptions()));
        System.out.println("Excludes: " + Arrays.toString(this.subscription.getExclusions()));
        System.out.println("getMaxKeepalive: " + this.subscription.getMaxKeepalive());
        System.out.println("getMaxPolltimeout: " + this.subscription.getMaxPolltimeout());
    }

    public void stop() {
        this.stopping.set(true);
        this.close();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void onNewMyJDEvent(String publisher, String eventid, Object eventData) {
        for (EventsDistributorListener fi : this.listeners) {
            if (!Pattern.compile(fi.getEventPattern()).matcher(publisher + "." + eventid).find() || fi.getFilterPattern() != null && fi.getFilterPattern().trim().length() > 0 && Pattern.compile(fi.getFilterPattern()).matcher(publisher + "." + eventid).matches()) continue;
            fi.onNewMyJDEvent(publisher, eventid, eventData);
        }
    }

    @Override
    public String getEventPattern() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getFilterPattern() {
        throw new RuntimeException("Not implemented");
    }

    public SubscriptionResponse getSubscription() {
        return this.subscription;
    }
}

