/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.par2;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.appwork.utils.formatter.HexFormatter;
import org.jdownloader.par2.Packet;
import org.jdownloader.par2.RawPacket;

public class UnicodeFilenamePacket
extends Packet {
    public static final byte[] MAGIC = new byte[]{80, 65, 82, 32, 50, 46, 48, 0, 85, 110, 105, 70, 105, 108, 101, 78};
    protected final RawPacket rawPacket;
    protected static final Charset UTF16 = Charset.forName("UTF-16");

    public ByteBuffer getFileID() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 0, 16);
    }

    public String toString() {
        return "UnicodeFilenamePacket|Name:" + this.getName() + "|FileID:" + HexFormatter.byteBufferToHex((ByteBuffer)this.getFileID());
    }

    public ByteBuffer getNameAsByteBuffer(boolean ignoreNullTermination) {
        return this.getByteBuffer(16, this.getRawPacket().getBody().length - 16, ignoreNullTermination);
    }

    public String getName() {
        return UTF16.decode(this.getNameAsByteBuffer(false)).toString();
    }

    public UnicodeFilenamePacket(RawPacket rawPacket) {
        this.rawPacket = rawPacket;
    }

    @Override
    public byte[] getType() {
        return MAGIC;
    }

    @Override
    public RawPacket getRawPacket() {
        return this.rawPacket;
    }
}

