/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractNode;
import jd.nutils.Formatter;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.IgnorableConditionalSkipReason;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.translate._JDT;

public class WaitForAccountSkipReason
implements ConditionalSkipReason,
IgnorableConditionalSkipReason,
TimeOutCondition {
    private final Account account;
    private final Icon icon;

    public Icon getIcon() {
        return this.icon;
    }

    public WaitForAccountSkipReason(Account account) {
        this.account = account;
        this.icon = new AbstractIcon("wait", 16);
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    public long getTimeOutTimeStamp() {
        return this.getAccount().getTmpDisabledTimeout();
    }

    @Override
    public long getTimeOutLeft() {
        return Math.max(0L, this.getTimeOutTimeStamp() - System.currentTimeMillis());
    }

    @Override
    public boolean canIgnore() {
        return true;
    }

    public String toString() {
        return "WaitForAccountSkipReason(Account:" + this.getAccount() + "|" + this.getMessage(this, null) + ")";
    }

    @Override
    public boolean isConditionReached() {
        return !this.getAccount().isEnabled() || !this.getAccount().isValid() || this.getAccount().getAccountController() == null || !this.getAccount().isTempDisabled() || this.getTimeOutLeft() == 0L;
    }

    @Override
    public String getMessage(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getMessage(this, node);
        }
        long left = this.getTimeOutLeft();
        return _JDT.T.gui_download_waittime_status2(Formatter.formatSeconds((long)Math.max(0L, left / 1000L)));
    }

    @Override
    public Icon getIcon(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getIcon(this, node);
        }
        return this.getIcon();
    }

    @Override
    public void finalize(DownloadLink link) {
    }
}

