/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import jd.plugins.MultiHostHost;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.IgnorableConditionalSkipReason;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.translate._JDT;

public class WaitForAccountTrafficSkipReasonMultihostTrafficRequired
implements ConditionalSkipReason,
IgnorableConditionalSkipReason {
    private static final GraphicalUserInterfaceSettings.SIZEUNIT MAXSIZEUNIT = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
    private final Account account;
    private final String host;
    private final Icon icon;
    private final long trafficRequired;

    public Icon getIcon() {
        return this.icon;
    }

    public long getTrafficRequired() {
        return this.trafficRequired;
    }

    public WaitForAccountTrafficSkipReasonMultihostTrafficRequired(Account account, String host, long trafficRequired) {
        this.account = account;
        this.host = host;
        this.icon = new AbstractIcon("wait", 16);
        this.trafficRequired = trafficRequired;
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    public boolean canIgnore() {
        return false;
    }

    private final boolean hasEnoughTraffic() {
        long host_TrafficLeft;
        AccountInfo ai = this.getAccount().getAccountInfo();
        if (ai == null) {
            return true;
        }
        MultiHostHost mhost = ai.getMultihostSupportedHost(this.host);
        if (mhost == null) {
            return true;
        }
        return mhost.isUnlimitedTraffic() || (host_TrafficLeft = Math.max(0L, mhost.getTrafficLeft())) >= this.trafficRequired;
    }

    public String toString() {
        return "WaitForAccountMultiHostHostTrafficSkipReason(Account:" + this.getAccount() + "|" + this.getMessage(this, null) + ")";
    }

    @Override
    public boolean isConditionReached() {
        return !this.getAccount().isEnabled() || !this.getAccount().isValid() || this.getAccount().getAccountController() == null || this.hasEnoughTraffic();
    }

    @Override
    public String getMessage(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getMessage(this, node);
        }
        return _JDT.T.gui_download_waittime_notenoughtraffic_multihost(this.getAccount().getHoster(), GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(MAXSIZEUNIT, this.trafficRequired));
    }

    @Override
    public Icon getIcon(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getIcon(this, node);
        }
        return this.getIcon();
    }

    @Override
    public void finalize(DownloadLink link) {
    }
}

