/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.controlling.packagecontroller.AbstractNode;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackageView;
import org.jdownloader.api.downloads.ChannelCollector;
import org.jdownloader.api.downloads.DownloadControllerEventPublisher;
import org.jdownloader.api.downloads.v2.DownloadsAPIV2Impl;
import org.jdownloader.gui.views.downloads.columns.ETAColumn;
import org.jdownloader.gui.views.downloads.columns.TaskColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.plugins.ValidatableConditionalSkipReason;
import org.jdownloader.translate._JDT;

public class WaitingSkipReason
implements ConditionalSkipReason,
TimeOutCondition,
ValidatableConditionalSkipReason {
    private final CAUSE cause;
    private final long timeOutTimeStamp;
    private final String message;
    private final Icon icon;
    private boolean valid = true;

    public CAUSE getCause() {
        return this.cause;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public long getTimeOutTimeStamp() {
        return this.timeOutTimeStamp;
    }

    public WaitingSkipReason(CAUSE cause, long timeOut, String message) {
        this.cause = cause;
        this.timeOutTimeStamp = System.currentTimeMillis() + timeOut;
        this.message = message;
        switch (cause) {
            case FILE_TEMP_UNAVAILABLE: {
                this.icon = new AbstractIcon("warning_green", 16);
                break;
            }
            case HOST_TEMP_UNAVAILABLE: {
                this.icon = new AbstractIcon("warning_red", 16);
                break;
            }
            case IP_BLOCKED: {
                this.icon = NewTheme.I().getIcon("auto-reconnect", 16);
                break;
            }
            default: {
                this.icon = new AbstractIcon("wait", 16);
            }
        }
    }

    public WaitingSkipReason(CAUSE cause, long timeOut) {
        this(cause, timeOut, null);
    }

    public String getMessage() {
        if (this.message == null) {
            if (this.getCause() == CAUSE.RETRY_IN) {
                long left = this.getTimeOutLeft();
                if (left > 0L) {
                    return _JDT.T.gui_download_waittime_status2(Formatter.formatSeconds((long)(left / 1000L)));
                }
                return _JDT.T.gui_download_waittime_status2("");
            }
            return this.getCause().getExplanation();
        }
        return this.message;
    }

    public String toString() {
        return (Object)((Object)this.getCause()) + ":" + this.getMessage() + "|Timeout:" + this.getTimeOutLeft();
    }

    @Override
    public long getTimeOutLeft() {
        return Math.max(0L, this.getTimeOutTimeStamp() - System.currentTimeMillis());
    }

    @Override
    public boolean isConditionReached() {
        return this.getTimeOutLeft() == 0L;
    }

    @Override
    public void finalize(DownloadLink link) {
    }

    @Override
    public String getMessage(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getMessage(this, node);
        }
        long left = this.getTimeOutLeft();
        if (left <= 0L) {
            return null;
        }
        if (requestor == this) {
            return this.getMessage();
        }
        if (requestor instanceof HistoryEntry) {
            return this.getMessage();
        }
        if (requestor instanceof TaskColumn) {
            return this.getMessage();
        }
        if (requestor instanceof DownloadControllerEventPublisher) {
            return this.getMessage();
        }
        if (requestor instanceof ChannelCollector) {
            return this.getMessage();
        }
        if (requestor instanceof DownloadsAPIV2Impl) {
            return this.getMessage();
        }
        if (requestor instanceof FilePackageView) {
            return this.getMessage();
        }
        if (requestor instanceof ETAColumn) {
            return Formatter.formatSeconds((long)(left / 1000L));
        }
        return null;
    }

    @Override
    public Icon getIcon(Object requestor, AbstractNode node) {
        return this.icon;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    public static enum CAUSE {
        IP_BLOCKED(_JDT.T.downloadlink_status_error_download_limit()),
        FILE_TEMP_UNAVAILABLE(_JDT.T.downloadlink_status_error_temp_unavailable()),
        CONNECTION_TEMP_UNAVAILABLE(_JDT.T.download_error_message_networkreset()),
        HOST_TEMP_UNAVAILABLE(_JDT.T.downloadlink_status_error_hoster_temp_unavailable()),
        MULTIHOST_QUEUE_DOWNLOAD_PENDING(_JDT.T.downloadlink_status_error_multihost_queue_download_pending()),
        RETRY_IN(null);

        private final String exp;

        private CAUSE(String exp) {
            this.exp = exp;
        }

        public String getExplanation() {
            return this.exp;
        }
    }
}

