/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.http.Browser;
import jd.http.Cookies;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountInvalidException;
import jd.plugins.AccountRequiredException;
import jd.plugins.AccountUnavailableException;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.components.SiteType;
import jd.plugins.download.HashInfo;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.parser.UrlQuery;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.captcha.v2.challenge.hcaptcha.AbstractHCaptcha;
import org.jdownloader.captcha.v2.challenge.hcaptcha.CaptchaHelperHostPluginHCaptcha;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.AbstractRecaptchaV2;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.CaptchaHelperHostPluginRecaptchaV2;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

@HostPlugin(revision="$Revision: 51879 $", interfaceVersion=2, names={}, urls={})
public abstract class TurbobitCore
extends PluginForHost {
    public static final String SETTING_FREE_PARALLEL_DOWNLOADSTARTS = "SETTING_FREE_PARALLEL_DOWNLOADSTARTS";
    public static final String SETTING_PREFERRED_DOMAIN = "SETTING_PREFERRED_DOMAIN";
    private static String PROPERTY_DOWNLOADLINK_checked_atleast_onetime = "checked_atleast_onetime";
    private static final int FREE_MAXDOWNLOADS_PLUGINSETTING = 20;
    private static final boolean prefer_single_linkcheck_via_mass_linkchecker = true;
    private static final String TYPE_premiumRedirectLinks = "(?i)(?:https?://[^/]+/)?/?download/redirect/[A-Za-z0-9]+/([a-z0-9]+)";
    private static Map<String, AtomicLong> hostLastPremiumCaptchaProcessedTimestampMap = new HashMap<String, AtomicLong>();

    protected List<String> getDeadDomains() {
        return null;
    }

    @Override
    public Browser createNewBrowserInstance() {
        Browser br = super.createNewBrowserInstance();
        br.setFollowRedirects(true);
        return br;
    }

    private Browser prepBrowserGeneral(Browser brc) {
        brc.getHeaders().put("Pragma", null);
        brc.getHeaders().put("Cache-Control", null);
        brc.getHeaders().put("Accept-Charset", null);
        brc.getHeaders().put("Accept", "text/html, application/xhtml+xml, */*");
        brc.getHeaders().put("Accept-Language", "en-EN");
        brc.getHeaders().put("Referer", null);
        brc.setCustomCharset("UTF-8");
        brc.setCookie(this.getMainpage(), "JD", "1");
        brc.setCookie(this.getMainpage(), "set_user_lang_change", "en");
        brc.setCookie(this.getMainpage(), "user_lang", "en");
        return brc;
    }

    private Browser prepBrowserWebsiteV1(Browser prepBr) {
        this.prepBrowserGeneral(prepBr);
        this.br.setCookie(this.getMainpage(), "site_version", "1");
        return prepBr;
    }

    private Browser prepBrowserWebsiteV2(Browser br) {
        this.prepBrowserGeneral(br);
        br.getHeaders().put("Accept", "application/json, text/plain, */*");
        br.setCookie(this.getMainpage(), "site_version", "2");
        br.setAllowedResponseCodes(new int[]{400});
        return br;
    }

    public TurbobitCore(PluginWrapper wrapper) {
        super(wrapper);
        this.setConfigElements();
        this.enablePremium("https://" + this.getHost() + "/turbo/v2/");
    }

    @Override
    public LazyPlugin.FEATURE[] getFeatures() {
        return new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.USERNAME_IS_EMAIL};
    }

    @Override
    public String getLinkID(DownloadLink link) {
        try {
            String fuid = this.getFUID(link);
            return this.getHost() + "://" + fuid;
        }
        catch (PluginException e) {
            e.printStackTrace();
            return super.getLinkID(link);
        }
    }

    protected boolean isFastLinkcheckEnabled() {
        return true;
    }

    protected abstract boolean allowWebsiteV2Handling();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkLinks(DownloadLink[] urls) {
        if (urls == null || urls.length == 0) {
            return false;
        }
        boolean fastLinkcheck = this.isFastLinkcheckEnabled();
        ArrayList<DownloadLink> linksForDeepCheck = new ArrayList<DownloadLink>();
        try {
            Browser brc = this.createNewBrowserInstance();
            this.prepBrowserWebsiteV1(brc);
            brc.getHeaders().put("X-Requested-With", "XMLHttpRequest");
            brc.setCookiesExclusive(true);
            StringBuilder sb = new StringBuilder();
            ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
            int index = 0;
            brc.getPage("https://" + this.getConfiguredDomain() + "/linkchecker?site_version=1&from_mirror=1");
            do {
                links.clear();
                while (index != urls.length && links.size() <= 49) {
                    links.add(urls[index]);
                    ++index;
                }
                sb.delete(0, sb.capacity());
                sb.append("links_to_check=");
                for (DownloadLink dl : links) {
                    sb.append(Encoding.urlEncode((String)this.getContentURL(dl)));
                    sb.append("%0A");
                }
                sb.delete(sb.length() - 3, sb.length());
                brc.postPage("https://" + brc.getHost() + "/linkchecker/check", sb.toString());
                for (DownloadLink link : links) {
                    String file_id = this.getFUID(link);
                    if (brc.containsHTML("<td>" + file_id + "</td>\\s*<td>\\s*</td>\\s*<td[^>]*>\\s*<img src=\"[^\"]*/error\\.png")) {
                        link.setAvailable(false);
                        continue;
                    }
                    Regex fileInfo = brc.getRegex("<td>" + file_id + "</td>\\s*(<td>([^<]+)</td>\\s*)?<td style=\"text-align:center;\">\\s*<img src=\"[^\"]*/(done|error)\\.png\"");
                    if (fileInfo.patternFind()) {
                        String name = fileInfo.getMatch(1);
                        link.setAvailable(true);
                        link.setFinalFileName(Encoding.htmlDecode((String)name).trim());
                        boolean checkedBeforeAlready = link.getBooleanProperty(PROPERTY_DOWNLOADLINK_checked_atleast_onetime, false);
                        if (link.getKnownDownloadSize() < 0L && (checkedBeforeAlready || !fastLinkcheck)) {
                            linksForDeepCheck.add(link);
                        }
                        link.setProperty(PROPERTY_DOWNLOADLINK_checked_atleast_onetime, true);
                        continue;
                    }
                    link.setAvailableStatus(DownloadLink.AvailableStatus.UNCHECKED);
                    this.logger.warning("Unable to check link: " + link.getPluginPatternMatcher());
                }
            } while (index != urls.length);
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            for (DownloadLink link : linksForDeepCheck) {
                this.logger.info("Performing deep linkcheck for: " + link.getPluginPatternMatcher());
                try {
                    DownloadLink.AvailableStatus availableStatus = this.requestFileInformation_Website(link, null);
                    link.setAvailableStatus(availableStatus);
                }
                catch (PluginException e) {
                    DownloadLink.AvailableStatus availableStatus;
                    this.logger.log((Throwable)e);
                    switch (e.getLinkStatus()) {
                        case 2048: 
                        case 4096: {
                            availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                            break;
                        }
                        case 32: {
                            availableStatus = DownloadLink.AvailableStatus.FALSE;
                            break;
                        }
                        case 256: {
                            if (e.getValue() == (long)PluginException.VALUE_ID_PREMIUM_ONLY) {
                                availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                                break;
                            }
                        }
                        default: {
                            availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                        }
                    }
                    link.setAvailableStatus(availableStatus);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        }
        return true;
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink link) throws Exception {
        if (this.supports_mass_linkcheck()) {
            return this.requestFileInformation_Mass_Linkchecker(link);
        }
        return this.requestFileInformation_WebsiteV1(link, null);
    }

    public DownloadLink.AvailableStatus requestFileInformation_Mass_Linkchecker(DownloadLink link) throws IOException, PluginException {
        this.checkLinks(new DownloadLink[]{link});
        if (!link.isAvailabilityStatusChecked()) {
            return DownloadLink.AvailableStatus.UNCHECKED;
        }
        if (link.isAvailabilityStatusChecked() && !link.isAvailable()) {
            throw new PluginException(32);
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    private DownloadLink.AvailableStatus requestFileInformation_Website(DownloadLink link, Account account) throws Exception {
        if (this.allowWebsiteV2Handling()) {
            return this.requestFileInformation_WebsiteV2(link, account);
        }
        return this.requestFileInformation_WebsiteV1(link, account);
    }

    private DownloadLink.AvailableStatus requestFileInformation_WebsiteV1(DownloadLink link, Account account) throws Exception {
        String[] split;
        this.setBrowserExclusive();
        this.accessContentURLWebsiteV1(this.br, link);
        if (TurbobitCore.isFileOfflineWebsite(this.br)) {
            throw new PluginException(32);
        }
        String titlePattern = "<title>\\s*(?:Download\\s+file|Datei\\s+downloaden|Descargar\\s+el\\s+archivo|T\u00e9l\u00e9charger\\s+un\\s+fichier|Scarica\\s+il\\s+file|Pobierz\\s+plik|Baixar\\s+arquivo|\u0130ndirilecek\\s+dosya|\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9)\\s*(.*?)\\s*\\(([\\d\\.,]+\\s*[BMKGTP]{1,2})\\)\\s*\\|\\s*(?:TurboBit|Hitfile)\\.net";
        String fileName = this.br.getRegex("<title>\\s*(?:Download\\s+file|Datei\\s+downloaden|Descargar\\s+el\\s+archivo|T\u00e9l\u00e9charger\\s+un\\s+fichier|Scarica\\s+il\\s+file|Pobierz\\s+plik|Baixar\\s+arquivo|\u0130ndirilecek\\s+dosya|\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9)\\s*(.*?)\\s*\\(([\\d\\.,]+\\s*[BMKGTP]{1,2})\\)\\s*\\|\\s*(?:TurboBit|Hitfile)\\.net").getMatch(0);
        String fileSize = this.br.getRegex("<title>\\s*(?:Download\\s+file|Datei\\s+downloaden|Descargar\\s+el\\s+archivo|T\u00e9l\u00e9charger\\s+un\\s+fichier|Scarica\\s+il\\s+file|Pobierz\\s+plik|Baixar\\s+arquivo|\u0130ndirilecek\\s+dosya|\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9)\\s*(.*?)\\s*\\(([\\d\\.,]+\\s*[BMKGTP]{1,2})\\)\\s*\\|\\s*(?:TurboBit|Hitfile)\\.net").getMatch(1);
        if (fileName == null && StringUtils.contains((String)(fileName = this.br.getRegex("<span class\\s*=\\s*(\"|')file\\-title\\1[^>]*>\\s*(.*?)\\s*</span>").getMatch(1)), (String)"...") && (split = fileName.split("\\.\\.\\.")).length == 2) {
            String customTitlePattern = "<title>\\s*[^<]*\\s*(" + Pattern.quote(split[0]) + ".*?" + Pattern.quote(split[1]) + ")\\s*\\(([\\d\\., ]+\\s*[BMKGTP]{1,2}\\s*)\\)";
            String fromTitle = this.br.getRegex(customTitlePattern).getMatch(0);
            if (fromTitle != null && fromTitle.length() > fileName.length()) {
                fileName = fromTitle;
            }
            if (fileSize == null) {
                fileSize = this.br.getRegex(customTitlePattern).getMatch(1);
            }
        }
        if (fileSize == null) {
            fileSize = this.br.getRegex("class\\s*=\\s*\"file-size\"\\s*>\\s*\\(?\\s*([^<]*?)\\s*\\)?\\s*<").getMatch(0);
        }
        if (fileName != null) {
            link.setName(fileName);
        }
        if (fileSize != null) {
            fileSize = fileSize.replace("\u041c", "M");
            fileSize = fileSize.replace("\u043a", "k");
            fileSize = fileSize.replace("\u0413", "g");
            if (!(fileSize = fileSize.replace("\u0431", "")).endsWith("b")) {
                fileSize = fileSize + "b";
            }
            link.setDownloadSize(SizeFormatter.getSize((String)fileSize.trim().replace(",", ".").replace(" ", "")));
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    private DownloadLink.AvailableStatus requestFileInformation_WebsiteV2(DownloadLink link, Account account) throws Exception {
        String fid = this.getFUID(link);
        Browser brc = this.prepBrowserWebsiteV2(this.br.cloneBrowser());
        brc.postPageRaw(this.getWebsiteV2Base() + "/api/download/info", "{\"fileId\":\"" + fid + "\",\"referrer\":null,\"site\":null,\"shortDomain\":\"\"}");
        Map<String, Object> entries = this.checkErrorsWebsiteV2(brc, link, account);
        Map file = (Map)entries.get("file");
        Number freeDownloadSize = (Number)entries.get("freeDownloadSize");
        long filesizeBytes = ((Number)file.get("size")).longValue();
        link.setFinalFileName(file.get("name").toString());
        link.setVerifiedFileSize(filesizeBytes);
        if (this.getPluginEnvironment() == Plugin.PluginEnvironment.DOWNLOAD) {
            boolean isPremium;
            boolean bl = isPremium = account != null && account.getType() == Account.AccountType.PREMIUM;
            if (!isPremium && Boolean.TRUE.equals(entries.get("premiumOnlyDownload"))) {
                throw new AccountRequiredException("Only downloadable for premium users");
            }
            if (!isPremium && freeDownloadSize != null && filesizeBytes > freeDownloadSize.longValue()) {
                GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit = (GraphicalUserInterfaceSettings.SIZEUNIT)((Object)CFG_GUI.MAX_SIZE_UNIT.getValue());
                String filesizeFormatted = GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(maxSizeUnit, freeDownloadSize.longValue());
                throw new AccountRequiredException(String.format("Limit reached for free download of this file (only %s free traffic left for this file). You can download this file using a premium account.", filesizeFormatted));
            }
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    public static boolean isFileOfflineWebsite(Browser br) {
        return br.getHttpConnection().getResponseCode() == 404 || br.containsHTML("(<div class=\"code-404\">404</div>|\u0424\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\\. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043d \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d\\.<br|(?:Document|File|Page)\\s*(was)?\\s*not found|It could possibly be deleted\\.)");
    }

    @Override
    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        Map<String, Object> userinfo = this.login(account, true);
        AccountInfo ai = new AccountInfo();
        ai.setUnlimitedTraffic();
        if (this.allowWebsiteV2Handling()) {
            Map<String, Object> entries = userinfo != null && StringUtils.endsWithCaseInsensitive((String)this.br.getURL(), (String)"/api/user/info") ? userinfo : this.getUserInformationWebsiteV2(this.br, account);
            Map entries_premium = (Map)entries.get("premium");
            String status = entries_premium.get("status").toString();
            if (status.equalsIgnoreCase("banned")) {
                account.setType(Account.AccountType.PREMIUM);
                this.getAndSetPremiumInformationWebsiteV1_in_website_v2_handling(account, ai);
                throw new AccountUnavailableException("You have reached limit of premium downloads", 1800000L);
            }
            if (status.equalsIgnoreCase("active")) {
                account.setType(Account.AccountType.PREMIUM);
                String expiredateStr = entries_premium.get("expiredAt").toString();
                ai.setValidUntil(TimeFormatter.getMilliSeconds((String)expiredateStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH), this.br);
                this.getAndSetPremiumInformationWebsiteV1_in_website_v2_handling(account, ai);
            } else {
                account.setType(Account.AccountType.FREE);
            }
        } else {
            String expire = this.br.getRegex(">\\s*Turbo access till\\s*(.*?)\\s*</span>").getMatch(0);
            if (expire == null) {
                expire = this.br.getRegex("'/premium(?:/info)?'\\s*>\\s*(\\d+\\.\\d+\\.\\d+)\\s*<").getMatch(0);
            }
            if (expire != null) {
                ai.setValidUntil(TimeFormatter.getMilliSeconds((String)expire.trim(), (String)"dd.MM.yyyy", (Locale)Locale.ENGLISH), this.br);
                account.setType(Account.AccountType.PREMIUM);
                this.getAndSetPremiumInformationWebsiteV1(account, ai);
            } else {
                account.setType(Account.AccountType.FREE);
            }
        }
        return ai;
    }

    private void getAndSetPremiumInformationWebsiteV1_in_website_v2_handling(Account account, AccountInfo ai) throws AccountUnavailableException {
        try {
            this.getAndSetPremiumInformationWebsiteV1(account, ai);
        }
        catch (AccountUnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            this.logger.warning("Exception happened during obtaining premium traffic");
        }
    }

    protected void getAndSetPremiumInformationWebsiteV1(Account account, AccountInfo ai) throws IOException, AccountUnavailableException {
        if (account.getType() != Account.AccountType.PREMIUM) {
            this.logger.warning("DEVELOPER MISTAKE!! ONLY CALL THIS FUNCTION FOR PREMIUM ACCOUNTS!!");
        }
        this.logger.info("Obtaining premium traffic information");
        Browser brc = this.br.cloneBrowser();
        brc.getPage("https://" + this.br.getHost(false) + "/premium/info?site_version=1&from_mirror=1");
        ai.setProperty("getAndSetPremiumInformationWebsiteV1", true);
        Regex traffic_daily = brc.getRegex("The rest of the traffic until the end of the day:\\s*<b>(\\d+[^<]+)</b>\\s*\\(of (\\d+[^<]+)/day\\)");
        if (traffic_daily.patternFind()) {
            long traffic_daily_left = SizeFormatter.getSize((String)traffic_daily.getMatch(0));
            long traffic_daily_max = SizeFormatter.getSize((String)traffic_daily.getMatch(1));
            ai.setTrafficLeft(traffic_daily_left);
            ai.setTrafficMax(traffic_daily_max);
        } else {
            this.logger.warning("Failed to find daily traffic left information");
        }
        Regex traffic_monthly = brc.getRegex("The rest of the monthly traffic:\\s*<b>(\\d+[^<]+)</b>\\s*\\(of (\\d+[^<]+)/month\\)");
        String monthlyTrafficLeftInfo = "N/A";
        if (traffic_monthly.patternFind()) {
            String traffic_monthly_left = traffic_monthly.getMatch(0);
            String traffic_monthly_max = traffic_monthly.getMatch(1);
            monthlyTrafficLeftInfo = traffic_monthly_left + "/" + traffic_monthly_max;
        } else {
            this.logger.warning("Failed to find monthly traffic left information");
        }
        ai.setStatus(account.getType().getLabel() + " | Monthly traffic left: " + monthlyTrafficLeftInfo);
        long dateEndTime = TurbobitCore.getDateEndTimeWebsiteV1(brc, account);
        if (dateEndTime != -1L) {
            ai.setValidUntil(dateEndTime);
        }
        Long endBlockingTime = null;
        if (brc.containsHTML("<span class='glyphicon glyphicon-ok banturbo'>") || (endBlockingTime = Long.valueOf(TurbobitCore.getBlockingEndTime(brc, account))) > 0L) {
            if (endBlockingTime == null) {
                endBlockingTime = TurbobitCore.getBlockingEndTime(brc, account);
            }
            if (endBlockingTime > 0L) {
                String readableTime = new SimpleDateFormat("yyyy-MM-dd' 'HH':'mm':'ss", Locale.ENGLISH).format(new Date(endBlockingTime));
                long wait = Math.max(300000L, Math.min(endBlockingTime - System.currentTimeMillis(), 1800000L));
                throw new AccountUnavailableException("You have reached limit of premium downloads:" + readableTime, wait);
            }
            throw new AccountUnavailableException("You have reached limit of premium downloads", 1800000L);
        }
    }

    private Map<String, Object> getUserInformationWebsiteV2(Browser br, Account account) throws IOException, PluginException {
        br.getPage(this.getWebsiteV2Base() + "/api/user/info");
        if (StringUtils.containsIgnoreCase((String)br.getURL(), (String)"login=true")) {
            this.logger.info("Not logged in because: URL contains 'login=true'");
            return null;
        }
        if (!br.getRequest().getHtmlCode().startsWith("{")) {
            this.logger.info("Not logged in because: Got html instead of json");
            return null;
        }
        Map<String, Object> entries = this.checkErrorsWebsiteV2(br, null, account);
        return entries;
    }

    protected static long getBlockingEndTime(Browser br, Account account) {
        String[] endTimes = br.getRegex("(?:Ban|Blocking) end (?:date|time)\\s*:\\s*(?:</span>)?\\s*(?:<b>)?\\s*(\\d{4}-\\d{2}-\\d{2}\\s*\\d{2}:\\d{2}:\\d{2})\\s*<").getColumn(0);
        if (endTimes == null || endTimes.length == 0) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        for (String endTime : endTimes) {
            long timeStamp = TimeFormatter.getMilliSeconds((String)endTime, (String)"yyyy-MM-dd' 'HH':'mm':'ss", (Locale)Locale.ENGLISH);
            if (timeStamp <= 0L || timeStamp <= now) continue;
            return timeStamp;
        }
        return -1L;
    }

    protected static long getDateEndTimeWebsiteV1(Browser br, Account account) {
        String[] endTimes = br.getRegex("Date end\\s*:\\s*(?:<b>)?\\s*(\\d{2}\\.\\d{2}\\.\\d{4}\\s*\\d{2}:\\d{2})\\s*<").getColumn(0);
        if (endTimes == null || endTimes.length == 0) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        for (String endTime : endTimes) {
            long timeStamp = TimeFormatter.getMilliSeconds((String)endTime, (String)"dd'.'MM'.'yyyy' 'HH':'mm", (Locale)Locale.ENGLISH);
            if (timeStamp <= 0L || timeStamp <= now) continue;
            return timeStamp;
        }
        return -1L;
    }

    @Override
    public String getAGBLink() {
        return this.getMainpage() + "/rules";
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        if (this.getPluginConfig().getBooleanProperty(SETTING_FREE_PARALLEL_DOWNLOADSTARTS, false).booleanValue()) {
            return 20;
        }
        return 1;
    }

    @Override
    public int getMaxSimultanPremiumDownloadNum() {
        return Integer.MAX_VALUE;
    }

    protected String getAPIKey() {
        String userDefinedAPIKey = this.getPluginConfig().getStringProperty("APIKEY");
        if (StringUtils.isEmpty((String)userDefinedAPIKey) || StringUtils.equalsIgnoreCase((String)userDefinedAPIKey, (String)"DEFAULT")) {
            return this.getAPIKeyDefault();
        }
        return userDefinedAPIKey;
    }

    public String getAPIKeyDefault() {
        return null;
    }

    public boolean supports_https() {
        return true;
    }

    public boolean supports_mass_linkcheck() {
        return true;
    }

    public boolean downloadurls_need_html_ending() {
        return true;
    }

    public int minimum_pre_download_waittime_seconds() {
        return 60;
    }

    protected int get_fallback_waittime() {
        return 600;
    }

    @Override
    public void handleFree(DownloadLink link) throws Exception {
        this.handleFree(link, null);
    }

    protected void accessContentURLWebsiteV1(Browser br, DownloadLink link) throws Exception {
        br.getPage(this.getContentURL(link));
    }

    protected String getContentURL(DownloadLink link) throws PluginException {
        return this.getContentURL(this.getConfiguredDomain(), this.getFUID(link));
    }

    protected String getContentURL(String domain, String fuid) throws PluginException {
        List<String> deadDomains = this.getDeadDomains();
        String domainToUse = deadDomains != null && deadDomains.contains(domain) ? this.getHost() : domain;
        String contentURL = "https://" + domainToUse + "/" + fuid;
        if (this.downloadurls_need_html_ending()) {
            contentURL = contentURL + ".html";
        }
        return contentURL;
    }

    protected void handleFree(DownloadLink link, Account account) throws Exception {
        this.handleDownload(link, account);
    }

    protected void checkPremiumOnlyWebsiteV1(DownloadLink link, Account account, Browser br) throws PluginException {
        String msg = br.getRegex("<div class=\"free-limit-note\"[^>]*>\\s*(Limit reached for free download of this file\\.)").getMatch(0);
        if (msg != null) {
            msg = Encoding.htmlDecode((String)msg).trim();
            throw new AccountRequiredException(msg);
        }
        if (br.containsHTML("<a\\s*data-premium-only-download") || br.containsHTML("href\\s*=\\s*\"/download/free/[^>]*?data-premium-only-download")) {
            throw new AccountRequiredException();
        }
    }

    protected boolean processCaptchaFormWebsiteV1(DownloadLink link, Account account, Form captchaform, Browser br, boolean optionalCaptcha) throws PluginException, InterruptedException {
        if (AbstractHCaptcha.containsHCaptcha(br)) {
            String response = new CaptchaHelperHostPluginHCaptcha(this, br).getToken();
            captchaform.put("g-recaptcha-response", Encoding.urlEncode((String)response));
            captchaform.put("h-captcha-response", Encoding.urlEncode((String)response));
            return true;
        }
        if (AbstractRecaptchaV2.containsRecaptchaV2Class(br)) {
            String recaptchaV2Response = new CaptchaHelperHostPluginRecaptchaV2(this, br).getToken();
            captchaform.put("g-recaptcha-response", Encoding.urlEncode((String)recaptchaV2Response));
            return true;
        }
        if (!optionalCaptcha) {
            this.logger.warning("Captcha-handling failed: Captcha handling was executed and captcha is expected to be there but is not there");
            throw new PluginException(0x400000);
        }
        return false;
    }

    protected void checkErrorsLastResort(Browser br, DownloadLink downloadLink, Account account) throws Exception {
        String waittime = br.getRegex("limit\\s?:\\s?(\\d+)\\s*,").getMatch(0);
        if (waittime != null) {
            throw new PluginException(16, (long)Integer.parseInt(waittime) * 1001L);
        }
        if (br.containsHTML("Timeout\\.limit\\s*>\\s*0")) {
            throw new PluginException(16, 600600L);
        }
        throw new PluginException(0x400000);
    }

    private final void handleDownload(DownloadLink link, Account account) throws Exception {
        String[] mirrors;
        if (link.getPluginPatternMatcher().matches(TYPE_premiumRedirectLinks)) {
            if (this.handlePremiumLink(link, account)) {
                return;
            }
            this.logger.info("Download of pre given directurl failed --> Attempting normal free download");
        }
        boolean verifiedLogin = false;
        if (account != null) {
            verifiedLogin = this.login(account, false) != null;
        } else if (this.checkShowFreeDialog(this.getHost())) {
            super.showFreeDialog(this.getHost());
        }
        String fid = this.getFUID(link);
        if (this.allowWebsiteV2Handling()) {
            Browser brc = this.prepBrowserWebsiteV2(this.br.cloneBrowser());
            if (account != null && account.getType() == Account.AccountType.PREMIUM) {
                List mirrorList = null;
                do {
                    brc.postPageRaw(this.getWebsiteV2Base() + "/api/download/info", "{\"fileId\":\"" + fid + "\",\"referrer\":null,\"site\":null,\"shortDomain\":\"\"}");
                    Map<String, Object> downloadmap = this.checkErrorsWebsiteV2(brc, link, account);
                    mirrorList = (List)downloadmap.get("downloadUrls");
                    if (mirrorList != null || verifiedLogin) break;
                    this.logger.info("Looks like session has expired -> Ensuring that we're logged in");
                    this.login(account, true);
                    verifiedLogin = true;
                } while (!this.isAbort());
                mirrors = mirrorList.toArray(new String[0]);
                this.logger.info("Available premium mirrors: " + mirrors.length);
            } else {
                this.requestFileInformation_WebsiteV2(link, account);
                brc.postPageRaw(this.getWebsiteV2Base() + "/api/download/free/init", "{\"fileId\":\"" + fid + "\"}");
                Map<String, Object> freedl = this.checkErrorsWebsiteV2(brc, link, account);
                Map freedl_ipBan = (Map)freedl.get("ipBan");
                if (freedl_ipBan != null) {
                    int seconds = ((Number)freedl_ipBan.get("delay")).intValue();
                    throw new PluginException(16, (long)seconds * 1000L);
                }
                brc.getPage("/api/captcha");
                Map<String, Object> captchainfo = this.checkErrorsWebsiteV2(brc, link, account);
                String reCaptchaIndex = captchainfo.get("index").toString();
                String reCaptchaKey = captchainfo.get("publicKey").toString();
                String recaptchaV2Response = new CaptchaHelperHostPluginRecaptchaV2(this, brc, reCaptchaKey).getToken();
                brc.postPageRaw("/api/download/free/captcha", "{\"fileId\":\"" + fid + "\",\"g-recaptcha-response\":\"" + recaptchaV2Response + "\",\"g-captcha-index\":" + reCaptchaIndex + "}");
                Map<String, Object> delaymap = this.checkErrorsWebsiteV2(brc, link, account);
                int waitSeconds = ((Number)delaymap.get("delay")).intValue();
                this.sleep(waitSeconds * 1000, link);
                brc.postPageRaw("/api/download/free/prepare", "{\"fileId\":\"" + fid + "\"}");
                this.checkErrorsWebsiteV2(brc, link, account);
                brc.getHeaders().put("Referer", "https://new.turbobit.net/download/started/" + fid);
                brc.postPageRaw("/api/download/free/start", "{\"fileId\":\"" + fid + "\"}");
                Map<String, Object> downloadmap = this.checkErrorsWebsiteV2(brc, link, account);
                String directlink = downloadmap.get("downloadUrl").toString();
                mirrors = new String[]{directlink};
            }
        } else {
            String directlink;
            Form captchaform;
            block32: {
                block33: {
                    this.requestFileInformation_WebsiteV1(link, account);
                    if (account != null && account.getType() == Account.AccountType.PREMIUM) {
                        this.handlePremiumWebsiteV1(link, account);
                        return;
                    }
                    this.br.getPage("/download/free/" + this.getFUID(link));
                    if (TurbobitCore.isFileOfflineWebsite(this.br)) {
                        throw new PluginException(32);
                    }
                    this.checkPremiumOnlyWebsiteV1(link, account, this.br);
                    boolean hasRetried = false;
                    captchaform = null;
                    while (true) {
                        Form[] allForms;
                        if ((allForms = this.br.getForms()) != null && allForms.length != 0) {
                            for (Form aForm : allForms) {
                                if (!aForm.containsHTML("captcha")) continue;
                                captchaform = aForm;
                                break;
                            }
                        }
                        if (captchaform != null) break block32;
                        this.handleGeneralErrors(this.br, account);
                        if (!StringUtils.containsIgnoreCase((String)this.br.getURL(), (String)"/download/free/")) break block33;
                        if (hasRetried || !this.br.containsHTML("/download/free/" + Pattern.quote(fid))) break;
                        this.br.getPage("/download/free/" + fid);
                        hasRetried = true;
                    }
                    throw new PluginException(2048, "Captcha form fail", 60000L);
                }
                this.checkErrorsLastResort(this.br, link, account);
                throw new PluginException(0x400000);
            }
            if (StringUtils.equalsIgnoreCase((String)captchaform.getAction(), (String)"#")) {
                captchaform.setAction(this.br.getURL());
            }
            if (!captchaform.hasInputFieldByName("captcha_type") && captchaform.containsHTML("recaptcha2")) {
                captchaform.put("captcha_type", "recaptcha2");
            }
            if (!captchaform.hasInputFieldByName("captcha_subtype") && captchaform.containsHTML("captcha_subtype")) {
                captchaform.put("captcha_subtype", "");
            }
            this.processCaptchaFormWebsiteV1(link, account, captchaform, this.br, false);
            this.br.submitForm(captchaform);
            if (this.br.getHttpConnection().getResponseCode() == 302 || this.br.containsHTML("<div\\s*class\\s*=\\s*\"captcha-error\"\\s*>\\s*Incorrect")) {
                this.invalidateLastChallengeResponse();
                throw new PluginException(8);
            }
            String continueLink = this.br.getRegex("\\$\\('#timeoutBox'\\)\\.load\\(\"(/[^\"]+)\"\\);").getMatch(0);
            if (continueLink == null) {
                this.checkErrorsLastResort(this.br, link, account);
                throw new PluginException(0x400000);
            }
            int wait = 0;
            String wait_str = this.br.getRegex("minLimit\\s*:\\s*(\\d+)").getMatch(0);
            if (wait_str == null) {
                this.logger.warning("Using fallback pre-download-wait");
                wait = this.get_fallback_waittime();
            } else {
                wait = Integer.parseInt(wait_str);
                if (wait > 800 || wait < this.minimum_pre_download_waittime_seconds()) {
                    wait = this.get_fallback_waittime();
                }
            }
            if (wait > 250) {
                throw new PluginException(16, "Limit reached or IP already loading", (long)wait * 1001L);
            }
            this.sleep((long)wait * 1001L, link);
            Browser br2 = this.br.cloneBrowser();
            br2.getHeaders().put("X-Requested-With", "XMLHttpRequest");
            br2.getPage(continueLink);
            String continueLink2 = br2.getRegex("(\"|')(/?/download/started/[^\"\\']+)\\1").getMatch(1);
            if (!StringUtils.isEmpty((String)continueLink2)) {
                br2.getPage(continueLink2);
            }
            if ((directlink = br2.getRegex("(\"|')(/?/download/redirect/[^\"\\']+)\\1").getMatch(1)) == null) {
                this.logger.info("'redirect' downloadurl is null");
                if (this.br.getRequest().getHtmlCode().matches("Error: \\d+")) {
                    throw new PluginException(4);
                }
                if (this.br.getRequest().getHtmlCode().matches("^The file is not avaliable now because of technical problems\\. <br> Try to download it once again after 10-15 minutes\\..*?")) {
                    throw new PluginException(2048, "File not avaiable due to technical problems.", 900900L);
                }
                if (this.br.containsHTML("<a href=\\'/" + this.getLinkID(link) + "(\\.html)?\\'>new</a>")) {
                    if (link.getPluginPatternMatcher().matches(TYPE_premiumRedirectLinks)) {
                        throw new PluginException(131072, "Generated Premium link has expired");
                    }
                    throw new PluginException(2048, "Failed to generate final downloadlink");
                }
                String linkerror = this.br.getRegex("<div\\s*id\\s*=\\s*\"brin-link-error\"\\s*>\\s*([^>]+)\\s*</div>").getMatch(0);
                if (linkerror != null) {
                    throw new PluginException(2048, linkerror);
                }
                throw new PluginException(2048, "Unknown Error - failed to find redirect-url to final downloadurl");
            }
            mirrors = new String[]{directlink};
        }
        this.initMirrorDownload(link, account, mirrors);
        this.dl.startDownload();
    }

    private String getFUID(DownloadLink link) throws PluginException {
        if (link == null || link.getPluginPatternMatcher() == null) {
            return null;
        }
        if (link.getPluginPatternMatcher().matches(TYPE_premiumRedirectLinks)) {
            String fuid = new Regex(link.getPluginPatternMatcher(), TYPE_premiumRedirectLinks).getMatch(0);
            if (fuid == null) {
                throw new PluginException(0x400000);
            }
            return fuid;
        }
        String fuid = new Regex(link.getPluginPatternMatcher(), "(?i)https?://[^/]+/([A-Za-z0-9]+)(?:/[^/]+)?(?:\\.html)?$").getMatch(0);
        if (fuid == null) {
            fuid = new Regex(link.getPluginPatternMatcher(), "(?i)download/free/([A-Za-z0-9]+)").getMatch(0);
        }
        if (fuid == null) {
            throw new PluginException(0x400000);
        }
        return fuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicLong getLastPremiumCaptchaProcessedTimestamp() {
        Map<String, AtomicLong> map = hostLastPremiumCaptchaProcessedTimestampMap;
        synchronized (map) {
            AtomicLong ret = hostLastPremiumCaptchaProcessedTimestampMap.get(this.getHost());
            if (ret == null) {
                ret = new AtomicLong(-1L);
                hostLastPremiumCaptchaProcessedTimestampMap.put(this.getHost(), ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void handlePremiumCaptchaWebsiteV1(Browser br, DownloadLink link, Account account) throws Exception {
        Form premiumCaptchaForm = null;
        for (Form form : br.getForms()) {
            if (!form.containsHTML(">\\s*Please enter captcha to continue\\s*<") && !form.hasInputFieldByName("captcha_type") && !form.hasInputFieldByName("g-captcha-index") || !form.hasInputFieldByName("check")) continue;
            premiumCaptchaForm = form;
            break;
        }
        if (premiumCaptchaForm == null) {
            return;
        }
        AtomicLong lastPremiumCaptchaProcessedTimestamp = this.getLastPremiumCaptchaProcessedTimestamp();
        long lastPremiumCaptchaRequestedTimestamp = lastPremiumCaptchaProcessedTimestamp.get();
        AtomicLong atomicLong = lastPremiumCaptchaProcessedTimestamp;
        synchronized (atomicLong) {
            this.logger.info("Detected premium download-captcha");
            if (!lastPremiumCaptchaProcessedTimestamp.compareAndSet(lastPremiumCaptchaRequestedTimestamp, System.currentTimeMillis())) {
                this.logger.info("Captcha has just been solved -> We might be able to skip this and all other subsequent premium captchas by just retrying");
            }
            this.processCaptchaFormWebsiteV1(link, account, premiumCaptchaForm, br, false);
            br.submitForm(premiumCaptchaForm);
        }
    }

    @Override
    public void handlePremium(DownloadLink link, Account account) throws Exception {
        this.handleDownload(link, account);
    }

    @Deprecated
    private void handlePremiumWebsiteV1(DownloadLink link, Account account) throws Exception {
        if (link.getPluginPatternMatcher().matches(TYPE_premiumRedirectLinks)) {
            if (this.handlePremiumLink(link, account)) {
                return;
            }
            this.logger.info("Download of pre given directurl failed --> Attempting normal premium download");
        }
        this.requestFileInformation_WebsiteV1(link, account);
        this.login(account, false);
        this.sleep(2000L, link);
        this.accessContentURLWebsiteV1(this.br, link);
        this.handlePremiumCaptchaWebsiteV1(this.br, link, account);
        String[] mirrors = this.br.getRegex("('|\")(https?://([a-z0-9\\.]+)?[^/\\'\"]+//?download/redirect/.*?)\\1").getColumn(1);
        if (mirrors == null || mirrors.length == 0) {
            if (this.br.containsHTML("You have reached the.*? limit of premium downloads")) {
                throw new AccountUnavailableException("Downloadlimit reached", 1800000L);
            }
            if (this.br.containsHTML("'>\\s*Premium access is blocked\\s*<")) {
                this.logger.info("Premium access is blocked --> No traffic available?");
                throw new AccountUnavailableException("Error 'Premium access is blocked' --> No traffic available?", 1800000L);
            }
            this.handleGeneralErrors(this.br, account);
            this.logger.warning("dllink equals null, plugin seems to be broken!");
            throw new PluginException(2048, "Failed to find final downloadlink");
        }
        this.initMirrorDownload(link, account, mirrors);
        this.dl.startDownload();
    }

    protected boolean getAndSetMd5Hash(DownloadLink link, String dllink) {
        String md5Value = new Regex(dllink, "(?i)md5=([a-f0-9]{32})").getMatch(0);
        HashInfo md5Hash = HashInfo.parse(md5Value, true, false);
        if (md5Hash != null) {
            HashInfo existingHash = link.getHashInfo();
            if (existingHash == null || md5Hash.isStrongerThan(existingHash) || existingHash.getType() == md5Hash.getType() && !existingHash.equals(md5Hash)) {
                this.logger.info("Found hash on downloadstart:" + md5Hash + "|Existing:" + existingHash);
                link.setHashInfo(md5Hash);
            }
            return true;
        }
        return false;
    }

    private void initMirrorDownload(DownloadLink link, Account account, String ... mirrors) throws Exception {
        DownloadType dltype = link.getPluginPatternMatcher().matches(TYPE_premiumRedirectLinks) ? DownloadType.GUEST_PREMIUMLINK : (account == null ? DownloadType.GUEST_FREE : (account.getType() == Account.AccountType.PREMIUM ? DownloadType.ACCOUNT_PREMIUM : DownloadType.ACCOUNT_FREE));
        LinkedHashSet<String> uniqueSet = new LinkedHashSet<String>(Arrays.asList(mirrors));
        if (uniqueSet.size() != mirrors.length) {
            this.logger.info("Removed mirror dupes | Size before: " + mirrors.length + " | New: " + uniqueSet.size());
        }
        ArrayList<String> uniqueMirrors = new ArrayList<String>(uniqueSet);
        Collections.shuffle(uniqueMirrors);
        String dllink = null;
        for (int i = 0; i < uniqueMirrors.size(); ++i) {
            dllink = (String)uniqueMirrors.get(i);
            this.logger.info("Trying mirror: " + (i + 1) + "/" + uniqueMirrors.size() + ": " + dllink);
            try {
                if (this.initSingleDownload(dltype, link, account, dllink)) {
                    break;
                }
            }
            catch (PluginException e) {
                boolean isLastMirror;
                boolean bl = isLastMirror = uniqueMirrors.size() - 1 == i;
                if (isLastMirror) {
                    throw e;
                }
                this.logger.log((Throwable)e);
                this.logger.info("Skipping broken mirror: " + dllink);
                continue;
            }
            this.logger.info("Skipping non working mirror: " + dllink);
        }
        if (this.dl == null) {
            throw new PluginException(2048, "Failed to find final downloadlink");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initSingleDownload(DownloadType dltype, DownloadLink link, Account account, String directlink) throws Exception {
        boolean bl;
        if (directlink == null) {
            this.logger.warning("dllink is null");
            throw new PluginException(0x400000);
        }
        boolean success = false;
        boolean previousFollowRedirectState = this.br.isFollowingRedirects();
        this.br.setCurrentURL(null);
        this.br.getHeaders().put("Referer", "");
        try {
            switch (dltype) {
                case ACCOUNT_PREMIUM: 
                case GUEST_PREMIUMLINK: {
                    new BrowserAdapter();
                    this.dl = BrowserAdapter.openDownload(this.br, link, directlink, true, 0);
                    break;
                }
                default: {
                    new BrowserAdapter();
                    this.dl = BrowserAdapter.openDownload(this.br, link, directlink, true, 1);
                }
            }
            if (this.dl.getConnection().getURL().getPath().startsWith("/error/download/ip")) {
                this.br.followConnection(true);
                if (dltype == DownloadType.ACCOUNT_PREMIUM) {
                    throw new AccountUnavailableException("403: You have reached the limit of downloads from this IP address", 1800000L);
                }
                throw new PluginException(2048, "You cannot download this file with your current IP", 3600000L);
            }
            if (this.dl.getConnection().getResponseCode() == 403) {
                this.br.followConnection(true);
                throw new PluginException(2048, "Server error 403");
            }
            if (this.dl.getConnection().getResponseCode() == 404) {
                this.br.followConnection(true);
                throw new PluginException(2048, "Server error 404");
            }
            if (!this.looksLikeDownloadableContent(this.dl.getConnection())) {
                this.br.followConnection(true);
                this.handleGeneralErrors(this.br, account);
                throw new PluginException(2048, "Final downloadlink did not lead to downloadable content");
            }
            if (this.dl.getConnection().getLongContentLength() == 0L) {
                throw new PluginException(2048, "Server error, server sends empty file", 300000L);
            }
            this.getAndSetMd5Hash(link, this.dl.getConnection().getURL().toExternalForm());
            success = true;
            bl = true;
            this.logger.info("Mirror is " + (success ? "okay: " : "down: ") + directlink);
        }
        catch (Throwable throwable) {
            this.logger.info("Mirror is " + (success ? "okay: " : "down: ") + directlink);
            this.br.setFollowRedirects(previousFollowRedirectState);
            try {
                if (!success) {
                    this.dl.getConnection().disconnect();
                    this.dl = null;
                    throw new PluginException(2048, "Broken mirror", 300000L);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        this.br.setFollowRedirects(previousFollowRedirectState);
        try {
            if (!success) {
                this.dl.getConnection().disconnect();
                this.dl = null;
                throw new PluginException(2048, "Broken mirror", 300000L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean handlePremiumLink(DownloadLink link, Account account) throws Exception {
        if (!link.getPluginPatternMatcher().matches(TYPE_premiumRedirectLinks)) {
            throw new PluginException(0x400000);
        }
        try {
            this.initMirrorDownload(link, account, link.getPluginPatternMatcher());
            this.dl.startDownload();
            return true;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            this.logger.info("Download of premium directlink failed");
            return false;
        }
    }

    private void handleGeneralErrors(Browser br, Account account) throws PluginException {
        if (br.containsHTML("Try to download it once again after")) {
            throw new PluginException(2048, "Server error 'Try again later'", 1200000L);
        }
        if (br.containsHTML(">\\s*\u0421\u0441\u044b\u043b\u043a\u0430 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u0430\\. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u0435")) {
            throw new PluginException(2048, "Server error 'link expired'", 300000L);
        }
        if (br.containsHTML("Our service is currently unavailable in your country\\.")) {
            throw new PluginException(131072, this.getHost() + " is currently unavailable in your country!");
        }
        if (br.containsHTML(">\\s*Your IP exceeded the max\\.? number of files that can be downloaded")) {
            Regex durationRegex = br.getRegex("You will be able to download at high speed again in (\\d+) hour\\(s\\) (\\d+) minute");
            String hoursStr = durationRegex.getMatch(0);
            String minutesStr = durationRegex.getMatch(1);
            long wait = 1800000L;
            if (hoursStr != null && minutesStr != null) {
                wait = (Long.parseLong(hoursStr) * 60L * 60L + Long.parseLong(minutesStr) * 60L) * 1000L;
            }
            if (account != null) {
                throw new AccountUnavailableException("Your IP exceeded the max number of files that can be downloaded", wait);
            }
            throw new PluginException(4096, "Your IP exceeded the max number of files that can be downloaded", 300000L);
        }
    }

    private Map<String, Object> checkErrorsWebsiteV2(Browser br, DownloadLink link, Account account) throws PluginException {
        long waitmillis = 60000L;
        HashMap<String, Object> entries = new HashMap<String, Object>();
        try {
            Object obj = this.restoreFromString(br.getRequest().getHtmlCode(), TypeRef.OBJECT);
            if (obj instanceof Map) {
                entries.putAll((Map)obj);
            } else if (obj instanceof List ? ((List)obj).size() > 0 : obj != null) {
                throw new PluginException(0x400000);
            }
        }
        catch (JSonMapperException ignore) {
            String errortext = "Invalid API response";
            if (link != null) {
                throw new PluginException(2048, "Invalid API response", 60000L);
            }
            throw new AccountUnavailableException("Invalid API response", 60000L);
        }
        String error_name = (String)entries.get("error_name");
        String message = (String)entries.get("message");
        if (error_name == null && message == null) {
            return entries;
        }
        if (error_name != null) {
            if (error_name.equalsIgnoreCase("file_is_not_available_for_download")) {
                throw new PluginException(32);
            }
            if (link == null) {
                throw new AccountInvalidException(error_name);
            }
            throw new PluginException(131072, error_name);
        }
        if (message.equalsIgnoreCase("File size is greater than allowed")) {
            throw new AccountRequiredException(message);
        }
        if (link == null) {
            throw new AccountInvalidException(message);
        }
        throw new PluginException(131072, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> login(Account account, boolean force) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            this.setBrowserExclusive();
            Cookies cookies = account.loadCookies("");
            this.prepBrowserWebsiteV1(this.br);
            this.br.getPage(this.getMainpage());
            String curr_domain = this.br.getHost();
            if (cookies != null) {
                this.logger.info("Attempting cookie login");
                this.br.setCookies(curr_domain, cookies);
                if (!force) {
                    return null;
                }
                if (this.allowWebsiteV2Handling()) {
                    try {
                        Map<String, Object> entries = this.getUserInformationWebsiteV2(this.br, account);
                        if (entries != null) {
                            this.logger.info("Cookie login successful");
                            this.br.setCookies(curr_domain, cookies);
                            return entries;
                        }
                        this.logger.info("Cookie login failed");
                    }
                    catch (PluginException ignore) {
                        this.logger.log((Throwable)ignore);
                        this.logger.info("Cookie login failed due to exception");
                    }
                } else {
                    this.br.getPage(this.br.getURL());
                    if (this.isLoggedIN(this.br)) {
                        this.logger.info("Cookie login successful");
                        this.br.setCookies(curr_domain, cookies);
                        return null;
                    }
                    this.logger.info("Cookie login failed");
                    if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                        this.logger.warning("Cookie login failed MAKE SURE THAT YOU RE-USED THE SAME USER-AGENT AS USED FOR THE FIRST LOGIN ELSE COOKIE LOGIN WILL NOT WORK!!!");
                    }
                }
            }
            this.logger.info("Performing full login");
            this.prepBrowserWebsiteV1(this.br);
            this.br.getPage("https://" + curr_domain + "/login");
            boolean requiredLoginCaptcha = false;
            Form loginform = this.findAndPrepareLoginForm(this.br, account);
            if (loginform != null) {
                this.br.submitForm(loginform);
                loginform = this.findAndPrepareLoginForm(this.br, account);
                this.throwWebInvalidLoginOrPassword(this.br, account);
                if (!this.isLoggedIN(this.br) && loginform != null) {
                    this.logger.info("Loginform is present again after login attempt");
                    DownloadLink link = this.getDownloadLink();
                    if (link == null) {
                        link = new DownloadLink(this, "Account", account.getHoster(), this.getMainpage(), true);
                        this.setDownloadLink(link);
                    }
                    requiredLoginCaptcha = this.processCaptchaFormWebsiteV1(link, account, loginform, this.br, true);
                    if (loginform.containsHTML("class=\"reloadCaptcha\"")) {
                        requiredLoginCaptcha = true;
                        String captchaurl = this.br.getRegex("(https?://[^/]+/captcha/securimg[^\"<>]+)").getMatch(0);
                        if (captchaurl == null) {
                            this.logger.warning("Failed to find captchaURL");
                            throw new PluginException(0x400000);
                        }
                        String code = this.getCaptchaCode(captchaurl, link);
                        loginform.put("user%5Bcaptcha_response%5D", Encoding.urlEncode((String)code));
                        loginform.put("user%5Bcaptcha_type%5D", "securimg");
                        loginform.put("user%5Bcaptcha_subtype%5D", "9");
                    }
                    if (!requiredLoginCaptcha) {
                        if (this.isBrowserContainsLoginErrorInvalidCaptcha(this.br)) {
                            throw new PluginException(0x400000);
                        }
                        throw new PluginException(0x400000);
                    }
                    this.br.submitForm(loginform);
                    this.throwWebInvalidLoginOrPassword(this.br, account);
                    this.throwWebIncorrectCaptchaCode(this.br, account);
                }
                if (this.br.containsHTML(">\\s*Limit of login attempts exceeded for your account")) {
                    if ("de".equalsIgnoreCase(System.getProperty("user.language"))) {
                        throw new PluginException(256, "\r\nMaximale Anzahl von Loginversuchen \u00fcberschritten - dein Account wurde tempor\u00e4r gesperrt!\r\nBest\u00e4tige deinen Account per E-Mail um ihn zu entsperren.\r\nFalls du keine E-Mail bekommen hast, gib deine E-Mail Adresse auf folgender Seite ein und lasse dir erneut eine zuschicken: " + this.br.getHost() + "/restoreaccess", PluginException.VALUE_ID_PREMIUM_DISABLE);
                    }
                    throw new PluginException(256, "\r\nLimit of login attempts exceeded for your account - your account is locked!\r\nConfirm your account via e-mail to unlock it.\r\nIf you haven't received an e-mail, enter your e-mail address on the following site so the service can send you a new confirmation mail: " + this.br.getHost() + "/restoreaccess", PluginException.VALUE_ID_PREMIUM_DISABLE);
                }
                if (!this.isLoggedIN(this.br) && this.br.containsHTML("<div[^>]*id\\s*=\\s*\"activation-form\"")) {
                    String predefinedpremiumkey = this.br.getRegex("predefined-premium-key\\s*=\\s*\"(.*?)\"").getMatch(0);
                    String predefinedemail = this.br.getRegex("predefined-email\\s*=\\s*\"(.*?)\"").getMatch(0);
                    if (StringUtils.isEmpty((String)predefinedemail)) {
                        predefinedemail = account.getUser();
                    }
                    if (StringUtils.isEmpty((String)predefinedpremiumkey)) {
                        predefinedpremiumkey = account.getPass();
                    }
                    UrlQuery loginquery = new UrlQuery();
                    loginquery.appendEncoded("premium", predefinedpremiumkey);
                    loginquery.appendEncoded("email", predefinedemail);
                    this.br.postPage("/payments/premium/process", loginquery);
                    Map response = (Map)this.restoreFromString(this.br.getRequest().getHtmlCode(), TypeRef.MAP);
                    if (Boolean.TRUE.equals(response.get("success"))) {
                        String redirect = (String)response.get("redirect");
                        if (redirect != null) {
                            this.br.getPage(redirect);
                        }
                        if (this.isLoggedIN(this.br)) {
                            return null;
                        }
                        throw new PluginException(0x400000);
                    }
                    String message = (String)response.get("message");
                    throw new AccountInvalidException(message);
                }
                if (!this.isLoggedIN(this.br)) {
                    this.throwWebInvalidLoginOrPassword(this.br, account);
                    throw new AccountInvalidException();
                }
                if (requiredLoginCaptcha) {
                    this.showLoginCaptchaInformation(account);
                }
            } else if (this.allowWebsiteV2Handling()) {
                HashMap<String, Object> postdata = new HashMap<String, Object>();
                postdata.put("email", account.getUser());
                postdata.put("password", account.getPass());
                postdata.put("captcha", true);
                postdata.put("g-recaptcha-response", "");
                postdata.put("g-captcha-index", 4);
                this.br.addAllowedResponseCodes(new int[]{422});
                this.br.postPageRaw(this.getWebsiteV2Base() + "/api/auth/login", JSonStorage.serializeToJson(postdata));
                Map<String, Object> entries = this.checkErrorsWebsiteV2(this.br, null, account);
                return entries;
            }
            account.saveCookies(this.br.getCookies(curr_domain), "");
            return null;
        }
    }

    private Thread showLoginCaptchaInformation(final Account account) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String title;
                    String message = "";
                    if ("de".equalsIgnoreCase(System.getProperty("user.language"))) {
                        title = account.getHoster() + " - Login Captcha";
                        message = message + "Hallo liebe(r) " + account.getHoster() + " NutzerIn\r\n";
                        message = message + "Um den Account dieses Anbieters in JDownloader verwenden zu k\u00f6nnen, musst du derzeit ein Login-Captcha eingeben.\r\n";
                        message = message + "Falls dich das st\u00f6rt, kannst du folgendes tun:\r\n";
                        message = message + "1. Logge dich im Browser ein.\r\n";
                        message = message + "2. Navigiere zu: " + account.getHoster() + "/user/settings\r\n";
                        message = message + "3. Entferne das H\u00e4ckchen bei 'Captcha einsetzen, um meinen Account zu sch\u00fctzen' und klicke unten auf speichern.\r\n";
                        message = message + "Dein Account sollte sich ab sofort ohne Login-Captchas in JD hinzuf\u00fcgen/pr\u00fcfen lassen.\r\n";
                    } else {
                        title = account.getHoster() + " - Login-Captcha";
                        message = message + "Hello dear " + account.getHoster() + " user\r\n";
                        message = message + "In order to add/check your account of this service, you have to solve login-captchas at this moment.\r\n";
                        message = message + "If that is annoying to you, you can deactivate them as follows:\r\n";
                        message = message + "1. Login via browser.\r\n";
                        message = message + "2. Open this page: " + account.getHoster() + "/user/settings\r\n";
                        message = message + "3. Uncheck the checkbox 'Use a captcha to protect my account'.\r\n";
                        message = message + "From now on, you should be able to add/check your account in JD without the need of a login-captcha.\r\n";
                    }
                    ConfirmDialog dialog = new ConfirmDialog(4, title, message);
                    dialog.setTimeout(120000);
                    ConfirmDialogInterface ret = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)dialog);
                    ret.throwCloseExceptions();
                }
                catch (Throwable e) {
                    TurbobitCore.this.getLogger().log(e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    protected boolean isLoggedIN(Browser br) {
        return br.containsHTML("/user/logout");
    }

    protected void throwWebInvalidLoginOrPassword(Browser br, Account account) throws PluginException {
        if (!this.isLoggedIN(br) && br.containsHTML("<div[^>]*class\\s*=\\s*'login_error'[^>]*>\\s*Incorrect login or password\\s*<")) {
            throw new AccountInvalidException("Incorrect login or password");
        }
    }

    protected void throwWebIncorrectCaptchaCode(Browser br, Account account) throws PluginException {
        if (!this.isLoggedIN(br) && this.isBrowserContainsLoginErrorInvalidCaptcha(br)) {
            throw new PluginException(8);
        }
    }

    private boolean isBrowserContainsLoginErrorInvalidCaptcha(Browser br) {
        return br.containsHTML("<div[^>]*class\\s*=\\s*'login_error'[^>]*>\\s*Incorrect captcha code\\s*<");
    }

    protected Form findAndPrepareLoginForm(Browser br, Account account) throws PluginException {
        if (account == null) {
            return null;
        }
        Form loginForm = br.getFormbyAction("/user/login");
        if (loginForm == null) {
            return null;
        }
        loginForm.put("user%5Blogin%5D", Encoding.urlEncode((String)account.getUser()));
        loginForm.put("user%5Bpass%5D", Encoding.urlEncode((String)account.getPass()));
        return loginForm;
    }

    public String getMainpage() {
        if (this.supports_https()) {
            return "https://" + this.getConfiguredDomain() + "/";
        }
        return "http://" + this.getConfiguredDomain() + "/";
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink link) {
    }

    protected String getConfiguredDomain() {
        return this.getHost();
    }

    private String getWebsiteV2Base() {
        return "https://app." + this.getConfiguredDomain();
    }

    protected void setConfigElements() {
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), SETTING_FREE_PARALLEL_DOWNLOADSTARTS, "Enable parallel download starts in free mode? <html><p style=\"color:#F62817\"><b>Warning: This setting may cause a large number of unaccepted CAPTCHA pop-ups!</b></p></html>").setDefaultValue(false));
    }

    @Override
    public boolean hasCaptcha(DownloadLink link, Account acc) {
        if (acc == null) {
            return true;
        }
        return acc.getType() == Account.AccountType.FREE;
    }

    @Override
    public SiteType.SiteTemplate siteTemplateType() {
        return SiteType.SiteTemplate.Turbobit_Turbobit;
    }

    @Override
    public String buildExternalDownloadURL(DownloadLink link, PluginForHost buildForThisPlugin) {
        try {
            return this.getContentURL(this.getHost(), this.getFUID(link));
        }
        catch (PluginException e) {
            return super.buildExternalDownloadURL(link, buildForThisPlugin);
        }
    }

    @Override
    public boolean hasAutoCaptcha() {
        return false;
    }

    static enum DownloadType {
        ACCOUNT_PREMIUM,
        ACCOUNT_FREE,
        GUEST_FREE,
        GUEST_PREMIUMLINK;

    }
}

